package com.yeejoin.amos.boot.module.elevator.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author Zhang Yingbin
 */
@AllArgsConstructor
@Getter
public enum WarningEnum {
    /**
     * 预警等级枚举
     *
     */
    WARNING_SOON_EXPIRE("即将超期预警", "1", "即将超期", "warning_soon_expire"),
    WARNING_OVER_EXPIRE("已经超期预警", "2", "已经超期", "warning_over_expire");


    private String name;

    private String level;

    private String status;

    private String code;

    public static WarningEnum getEumByLevel(String level) {
        Optional<WarningEnum> op = Arrays.stream(WarningEnum.values()).filter(e -> e.getLevel().equals(level)).findFirst();
        return op.orElseThrow(() -> new RuntimeException("未知的类型"));
    }
}
