package com.yeejoin.amos.boot.module.jg.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 设备报废注销
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgScrapCancelDto", description = "设备报废注销")
public class JgScrapCancelDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "注销类型（1报废注销，2移装注销）")
    private String cancelType;

    @ApiModelProperty(value = "申请编号")
    private String applyNo;

    @ApiModelProperty(value = "流程实例id")
    private String instanceId;

    @ApiModelProperty(value = "办理状态")
    private String auditStatus;

    @ApiModelProperty(value = "状态")
    private String status;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "流程状态")
    private String instanceStatus;

    @ApiModelProperty(value = "下一执行节点ids")
    private String nextExecuteIds;

    @ApiModelProperty(value = "接收机构代码")
    private String receiveOrgCode;

    @ApiModelProperty(value = "接收机构")
    private String receiveOrgName;

    @ApiModelProperty(value = "接收机构公司代码")
    private String receiveCompanyCode;

    @ApiModelProperty(value = "注销证明")
    private String cancelCertificate;

    @ApiModelProperty(value = "注销证明文件集合格式")
    private List<Map<String, Object>> cancelCertificateList;

    @TableField(exist = false)
    @ApiModelProperty(value = "告知设备列表")
    private List<Map<String, Object>> deviceList;

    @ApiModelProperty(value = "设备ID")
    private String SEQUENCE_NBR;

    @ApiModelProperty(value = "任务发起人id")
    private String promoter;

    @ApiModelProperty(value = "终审通过时间")
    private Date auditPassDate;

    @ApiModelProperty(value = "下一步任务ID")
    private String nextTaskId;

    private List<String> roleIds;

    @ApiModelProperty(value = "区分监管和企业")
    private String type;

    @ApiModelProperty(value = "使用单位编码")
    private String useUnitCode;

    @ApiModelProperty(value = "使用单位名称")
    private String useUnitName;

    @ApiModelProperty(value = "设备监管码")
    private String supervisoryCode;

    @ApiModelProperty(value = "设备ID")
    private String record;

    @ApiModelProperty(value = "下一节点可执行人")
    private String nextExecuteUserIds;

    @ApiModelProperty(value = "转办后执行人的Id逗号分割")
    private String transferToUserIds;

    @ApiModelProperty(value = "设备代号")
    private String equList;


    @ApiModelProperty(value = "设备类别")
    private String equCategoryDesc;

    @ApiModelProperty(value = "设备名称")
    private String productName;

    @ApiModelProperty(value = "设备地址")
    private String fullAddress;

    @ApiModelProperty (value = "其他附件")
    private String otherAccessories;

}
