package com.yeejoin.amos.boot.module.jg.biz.controller;


import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.DataHandlerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.annotation.Resource;

/**
 * 用于业务变更过程中历史数据处理的控制层
 */
@Api(tags = "用于业务变更过程中历史数据处理的控制层")
@RestController
@RequestMapping(value = "/dataHandler")
public class DataHandlerController extends BaseController {

    @Resource
    private DataHandlerServiceImpl dataHandlerService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "安装告知压力管道历史数据修复-详情中的设备列表修改为汇总表格式", notes = "安装告知压力管道历史数据修复-详情中的设备列表修改为汇总表格式")
    @GetMapping(value = "/installNotice/deviceListInForm")
    public ResponseModel<Boolean> deviceListInFormWithInstallNotice() {
        return ResponseHelper.buildResponse(dataHandlerService.deviceListInFormWithInstallNotice());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "向新增的工程装置表刷入数据", notes = "向新增的工程装置表刷入数据")
    @GetMapping(value = "/projectContraption/writeData")
    public ResponseModel<Boolean> writeData2ProjectContraption() {
        return ResponseHelper.buildResponse(dataHandlerService.writeData2ProjectContraption());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "刷入工程装置id到es的idx_biz_view_jg_all索引", notes = "刷入工程装置id到es的idx_biz_view_jg_all索引")
    @GetMapping(value = "/jgAllIndex/writeProjectContraptionId")
    public ResponseModel<String> writeProjectContraptionId() {
        return ResponseHelper.buildResponse(dataHandlerService.writeProjectContraptionId());
    }

    /**
     * 向新增的工程装置表刷入数据(补充使用单位code为空的)
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "向新增的工程装置表刷入数据,条件是未做使用登记，使用单位code为空的", notes = "向新增的工程装置表刷入数据,条件是未做使用登记，使用单位code为空的")
    @GetMapping(value = "/projectContraption/writeDataUseCodeIsNull")
    public ResponseModel<Boolean> writeDataUseCodeIsNull2ProjectContraption() {
        return ResponseHelper.buildResponse(dataHandlerService.writeDataUseCodeIsNull2ProjectContraption());
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "使用登记表属地监管部门历史数据处理",notes = "supervisionOrgCode在history表json数据写入，气瓶导入页面无此字段，使用单位的属地监管部门写入")
    @PutMapping(value = "/useRegistration/supervisionOrgCode")
    public ResponseModel<Boolean> writeSupervisionOrgCode2UseRegister(){
        dataHandlerService.writeSupervisionOrgCode2UseRegister();
        return ResponseHelper.buildResponse(true);
    }


    @ApiOperation(httpMethod = "PUT", value = "安装告知缺少装置id、装置未创建、安装告知完成但是设备状态为未纳管数据处理", notes = "历史数据处理")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/v3/projectContraption/notice")
    public ResponseModel<Boolean> projectContraptionNoticeDataDealV3(){
        dataHandlerService.projectContraptionNoticeDataDeal();
        return ResponseHelper.buildResponse(true);
    }

    @ApiOperation(httpMethod = "PUT", value = "使用登记缺少装置id数据处理", notes = "历史数据处理,依赖/v3/projectContraption/notice作为基础数据")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/v3/projectContraption/useRegister")
    public ResponseModel<Boolean> projectContraptionUseRegisterDataDealV3(){
        dataHandlerService.projectContraptionUseRegisterDataDeal();
        return ResponseHelper.buildResponse(true);
    }

    @ApiOperation(httpMethod = "PUT", value = "由于前期设备纳管状态不对，导致的1220上线时 创建的装置纳管状态不对，刷库", notes = "历史数据处理")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/v2/projectContraption/info")
    public ResponseModel<Boolean> projectContraptionInfoUpdateV2(){
        dataHandlerService.projectContraptionInfoUpdateV2();
        return ResponseHelper.buildResponse(true);
    }


    @ApiOperation(httpMethod = "PUT", value = "20250108-刷管道，设备使用信息表装置id未更新，导致的错误数据处理，已es为准", notes = "历史数据处理")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/v3/projectContraption/useInfo")
    public ResponseModel<Boolean> projectUseInfoUpdateV3(){
        dataHandlerService.projectUseInfoUpdateV3();
        return ResponseHelper.buildResponse(true);
    }

    @ApiOperation(httpMethod = "PUT", value = "20250108-1220上线时, 已完成安装告知管道未写入装置的施工信息表（导致使用登记不能回显施工信息），刷库", notes = "历史数据处理")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/v3/projectContraption/info")
    public ResponseModel<Boolean> projectContraptionInfoUpdateV3(){
        dataHandlerService.projectContraptionInfoUpdateV3();
        return ResponseHelper.buildResponse(true);
    }

    @ApiOperation(httpMethod = "PUT", value = "20250109-之前刷库问题导致的管道的装置id与安装告知不一样，已安装告知为准，刷使用信息表的装置id、es的装置id【只处理未做过使用登记或者使用登记未完成的】", notes = "历史数据处理")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/v4/projectContraption/useInfo")
    public ResponseModel<Boolean> projectUseInfoUpdateV4(){
        dataHandlerService.projectUseInfoUpdateV4();
        return ResponseHelper.buildResponse(true);
    }

    @ApiOperation(httpMethod = "PUT", value = "20250110-处理一个管道在多个安装告知里，刷管道的use_info、es的装置id,已最新安装告知为准", notes = "历史数据处理")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/v5/projectContraption/useInfo")
    public ResponseModel<Boolean> projectUseInfoUpdateV5(){
        dataHandlerService.projectUseInfoUpdateV5();
        return ResponseHelper.buildResponse(true);
    }

    /**
     * 管道使用登记主表刷入原始工程装置ID集合和Eq表刷入工程装置ID
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "管道使用登记主表刷入原始工程装置ID集合和Eq表刷入工程装置ID", notes = "管道使用登记主表刷入原始工程装置ID集合和Eq表刷入工程装置ID")
    @GetMapping(value = "/useRegistration/writeProjectContraptionIdInJgUseRegistration")
    public ResponseModel<Boolean> writeProjectContraptionIdInJgUseRegistration() {
        return ResponseHelper.buildResponse(dataHandlerService.writeProjectContraptionIdInJgUseRegistration());
    }

    /**
     * BUG 26910 【现场需求】登记证管理中，历史设备登记的普通气瓶，状态为空，新增气瓶的状态为在用
     * 将历史导入的普通气瓶和正常导入的普通气瓶刷入设备状态
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "将历史导入的普通气瓶和正常导入的普通气瓶刷入设备状态", notes = "将历史导入的普通气瓶和正常导入的普通气瓶刷入设备状态")
    @GetMapping(value = "/ordinaryGasCylinder/equState")
    public ResponseModel<String> ordinaryGasCylinderWriteEquState() {
        return ResponseHelper.buildResponse(dataHandlerService.ordinaryGasCylinderWriteEquState());
    }

    /**
     * 使用登记、车用气瓶登记历史单据使用登记表生成
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "使用登记、车用气瓶登记历史单据使用登记表生成", notes = "使用登记、车用气瓶登记历史单据使用登记表生成")
    @GetMapping(value = "/initFormUrl")
    public ResponseModel<Boolean> initFormUrl() {
        dataHandlerService.initFormUrl();
        return ResponseHelper.buildResponse(Boolean.TRUE);
    }

    /**
     * 同步设备信息到ES
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "同步设备信息到ES", notes = "同步设备信息到ES")
    @PostMapping(value = "/synchronizeEqData2ES")
    public ResponseModel<String> synchronizeEqData2ES(@ApiParam(value = "设备的record，多个设备使用英文逗号分割", required = true)
                                                      @RequestParam(value = "records") String records,
                                                      @ApiParam(value = "是否安改维单位，默认值'false'", required = true, defaultValue = "false")
                                                      @RequestParam(value = "isAgw", defaultValue = "false") Boolean isAgw,
                                                      @ApiParam(value = "是否纳管，默认值'true'", required = true, defaultValue = "true")
                                                      @RequestParam(value = "isIntoManagement", defaultValue = "true") Boolean isIntoManagement) {
        StopWatch watch = new StopWatch();
        watch.start();
        dataHandlerService.synchronizeEqData2ES(records, isAgw, isIntoManagement);
        watch.stop();
        return ResponseHelper.buildResponse(String.format("同步成功，耗时：%s", watch.getTotalTimeSeconds()));
    }
}
