package com.yeejoin.amos.boot.module.tcm.flc.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tcm.flc.api.dto.UnitInfoChangeDto;
import com.yeejoin.amos.boot.module.tcm.flc.api.dto.UnitInfoDto;
import com.yeejoin.amos.boot.module.tcm.flc.api.entity.UnitInfoChange;
import com.yeejoin.amos.boot.module.tcm.flc.api.mapper.UnitInfoChangeMapper;
import com.yeejoin.amos.boot.module.tcm.flc.api.service.IUnitInfoChangeService;
import com.yeejoin.amos.boot.module.tcm.flc.api.service.IUnitInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;

/**
 * 企业信息变更表服务实现类
 *
 * @author system_generator
 * @date 2021-11-11
 */
@Service
public class UnitInfoChangeServiceImpl extends BaseService<UnitInfoChangeDto, UnitInfoChange, UnitInfoChangeMapper> implements IUnitInfoChangeService {

    @Autowired
    IUnitInfoService iUnitInfoService;

    /**
     * 分页查询
     */
    public Page<UnitInfoChangeDto> queryForFlcUnitInfoChangePage(Page<UnitInfoChangeDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<UnitInfoChangeDto> queryForFlcUnitInfoChangeList() {
        return this.queryForList("", false);
    }

    /**
     * 根据源码id 返回最新的变更记录
     * @param sourceId
     * @return
     */
    @Override
    public UnitInfoDto findLastChangInfo(Long sourceId) {
        UnitInfoChange result;
        List<UnitInfoChange> changInfoList = this.list(new LambdaQueryWrapper<UnitInfoChange>().eq(UnitInfoChange::getIsDelete,false).eq(UnitInfoChange::getSourceId,sourceId).orderByDesc(UnitInfoChange::getRecDate));
        if(changInfoList != null && changInfoList.size() >0) {
            result = changInfoList.get(0);
        } else {
            throw new BadRequest("未找到变更记录");
        }
        return iUnitInfoService.unitChangeInfoToDto(result);
    }

}