package com.yeejoin.amos.supervision.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 统计口径枚举
 * 
 * @author tianbo
 *
 */
public enum StatisticalCaliberEnum {

	PLAN("巡检计划", "p_plan"), 
	ROUTE("巡检路线", "p_route"), 
	POINT("巡检点", "p_point"), 
	GROUP("巡检部门", "s_department"),
	USER("巡检人员", "s_user"),
	DATE("巡检日期", "date"),
	MONTH("巡检月份", "month");

	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private String code;

	private StatisticalCaliberEnum(String name, String code) {
		this.name = name;
		this.code = code;
	}
	
	public static String getName(String code) {
		for (StatisticalCaliberEnum c : StatisticalCaliberEnum.values()) {
			if (c.getCode() == code) {
				return c.name;
			}
		}
		return null;
	}
	
	public static String getValue(String name) {
		for (StatisticalCaliberEnum c : StatisticalCaliberEnum.values()) {
			if (c.getName().equals(name)) {
				return c.getCode();
			}
		}
		return "";
	}

	public static StatisticalCaliberEnum getEnumByCode(String code) {
		for (StatisticalCaliberEnum c : StatisticalCaliberEnum.values()) {
			if (c.getCode().equals(code)) {
				return c;
			}
		}
		return null;
	}

	public static StatisticalCaliberEnum getEnumByName(String name) {
		for (StatisticalCaliberEnum c : StatisticalCaliberEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<String> getEnumNameList() {
		List<String> nameList = new ArrayList<String>();
		for (StatisticalCaliberEnum c: StatisticalCaliberEnum.values()) {
			nameList.add(c.getName());
		}
		return nameList;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (StatisticalCaliberEnum c: StatisticalCaliberEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("value", c.getCode());
			nameList.add(map);
		}
		return nameList;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

}
