package com.yeejoin.equipmanage.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.EquipmentQrcode;
import com.yeejoin.equipmanage.common.enums.EquipStatusEnum;
import com.yeejoin.equipmanage.common.utils.StringUtil;
import com.yeejoin.equipmanage.mapper.EquipmentQrcodeMapper;
import com.yeejoin.equipmanage.service.IEquipmentQrcodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 服务实现类
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Service
public class EquipmentQrcodeServiceImpl extends ServiceImpl<EquipmentQrcodeMapper, EquipmentQrcode>
		implements IEquipmentQrcodeService {

	@Autowired
	private EquipmentQrcodeMapper equipmentQrcodeMapper;

	@Override
	public Page<EquipmentQrcode> page(Page<EquipmentQrcode> pageBean, EquipmentQrcode equipmentQrcode) {
		List<EquipmentQrcode> list = equipmentQrcodeMapper.page(equipmentQrcode, pageBean.offset(), pageBean.getSize());

		for (EquipmentQrcode equipmentQrcodeOne : list) {
			if(StringUtil.isNotEmpty(equipmentQrcodeOne.getCarId())){
				//车辆二维码
				equipmentQrcodeOne.setFullQRCode("03#" + equipmentQrcodeOne.getQRCode());
			} else {
				//装备二维码
				equipmentQrcodeOne.setFullQRCode("01#" + equipmentQrcodeOne.getQRCode());
			}
			if (equipmentQrcodeOne.getStatus() != null) {
				equipmentQrcodeOne.setStatus(EquipStatusEnum.getEnum(Long.valueOf(equipmentQrcodeOne.getStatus())).getDescribe());
			}
		}
		int count = equipmentQrcodeMapper.count(equipmentQrcode);
		Page<EquipmentQrcode> page = new Page<EquipmentQrcode>(pageBean.getCurrent(), pageBean.getSize());
		page.setRecords(list);
		page.setTotal(count);
		return page;
	}

}
