package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarm;
import com.yeejoin.equipmanage.common.entity.dto.EquipSpecificAlarmDTO;
import com.yeejoin.equipmanage.common.utils.StringUtil;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificAlarmMapper;
import com.yeejoin.equipmanage.service.IEquipmentSpecificSerivceAlarm;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.service.impl
 * @ClassName: EquipmentSpecificSerivceAlarmImpl
 * @Author: Jianqiang Gao
 * @Description: EquipmentSpecificSerivceAlarmImpl
 * @Date: 2020/12/24 10:38
 * @Version: 1.0
 */
@Service
public class EquipmentSpecificSerivceAlarmImpl extends ServiceImpl<EquipmentSpecificAlarmMapper, EquipmentSpecificAlarm> implements IEquipmentSpecificSerivceAlarm {

    @Autowired
    EquipmentSpecificAlarmMapper equipmentSpecificAlarmMapper;

    @Override
    public Map<String, List<EquipSpecificAlarmDTO>> findByTypeAndDate(EquipSpecificAlarmDTO dto) {
        List<EquipSpecificAlarmDTO> alarmInfo = equipmentSpecificAlarmMapper.findByTypeAndDate(dto);
        if (CollectionUtils.isNotEmpty(alarmInfo)) {
            Map<String, List<EquipSpecificAlarmDTO>> collect = alarmInfo.parallelStream().collect(Collectors.groupingBy(EquipSpecificAlarmDTO::getCreateDate));
            Map<String,List<EquipSpecificAlarmDTO>> sortmap = new TreeMap<>((o1,o2)->o2.compareTo(o1));
            collect.entrySet()
                    .stream()
                    .forEach(x -> sortmap.put(x.getKey(), x.getValue()));
            return sortmap;
        }
        return new HashMap<>();
    }

    @Override
    public List<EquipSpecificAlarmDTO> findListByTypeAndDate(EquipSpecificAlarmDTO dto) {
        List<EquipSpecificAlarmDTO> alarmInfo = equipmentSpecificAlarmMapper.findByTypeAndDate(dto);
        if (CollectionUtils.isNotEmpty(alarmInfo)) {
            alarmInfo.forEach(entry -> {
                entry.setRow1(entry.getFireEquipmentSpecificIndexName());
                entry.setRow2("设备： " + entry.getFireEquipmentName() + (StringUtil.isNotEmpty(entry.getFireEquipmentCode()) ?
                        "(" + entry.getFireEquipmentCode() + ")" : ""));
                entry.setRow3("位置： " + entry.getWarehouseStructureName());
                entry.setDateAxis(entry.getCreateDate());
            });
        }
        return alarmInfo;
    }

    @Override
    public List<EquipSpecificAlarmDTO> findInfoByTypeAndDate(EquipSpecificAlarmDTO dto) {
        List<EquipSpecificAlarmDTO> alarmInfo = equipmentSpecificAlarmMapper.findInfoByTypeAndDate(dto);
        if (CollectionUtils.isNotEmpty(alarmInfo)) {
            alarmInfo.forEach(entry -> {
                entry.setRow1(entry.getFireEquipmentSpecificIndexName());
                entry.setRow2("设备： " + entry.getFireEquipmentName() + (StringUtil.isNotEmpty(entry.getFireEquipmentCode()) ?
                        "(" + entry.getFireEquipmentCode() + ")" : ""));
                entry.setRow3("位置： " + entry.getWarehouseStructureName());
                entry.setDateAxis(entry.getCreateDate());
            });
        }
        return alarmInfo;
    }
}