package com.yeejoin.precontrol.common.mapper;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.publics.CommonPageable;
import com.yeejoin.precontrol.common.param.PersonParam;
import com.yeejoin.precontrol.common.param.PersonStatisticParam;
import com.yeejoin.precontrol.common.vo.ApprovalPersonVo;
import com.yeejoin.precontrol.common.vo.PersonExcelVo;
import com.yeejoin.precontrol.common.vo.PersonStatisticVo;
import com.yeejoin.precontrol.common.vo.PersonVo;
import com.yeejoin.precontrol.common.vo.RiskWorkPersonVo;

/**
 * 人员基本信息 Mapper 接口
 *
 * @author duanwei
 * @date 2020-06-30
 */
public interface PersonMapper extends BaseMapper<Person> {
    int pageInfoCount(@Param("personParam") PersonParam personParam);

    List<PersonVo> pageInfo(@Param("personParam") PersonParam personParam, @Param("page")CommonPageable page);

    List<PersonExcelVo> exportExcel(PersonParam param);

    List<HashMap<Long, String>> nationSelect();

    PersonVo getPersonVoByAccountNumber(@Param("accountNum") String accountNum);

    /**
     * 项目人数
     */
    int statisticalByProject();

    /**
     * 入场人数
     */
    int statisticalByIn(@Param("projectId") Long projectId, @Param("start") String start, @Param("end") String end);

    /**
     * 合格人数
     */
    int statisticalByQualified();

    List<PersonStatisticVo> statisticPageInfo(@Param("personStatisticParam") PersonStatisticParam personStatisticParam,
                                              Page<PersonStatisticVo> page);

    /**
     * 查询已绑定用户account_number
     */
    List<String> selectBindUserSeqs();

    /**
     * 人员态势统计数据
     *
     * @param page
     * @param personStatisticParam
     * @return
     */
    IPage<PersonStatisticVo> listByPage(Page<PersonStatisticVo> page,
                                        @Param("personStatisticParam") PersonStatisticParam personStatisticParam);

    Integer isOk(@Param("projectId") Long projectId, @Param("orgCode") String orgCode);

    /**
     * 更新图片 有可能为null
     *
     * @param person
     */
    void updatePhoto(Person person);

    /**
     * 更新orgcode为null
     */
    void clearOrgCode(Person person);

    /**
     * 查询时间段内的人
     */
    IPage<PersonVo> period(Page<PersonVo> page, PersonParam personParam, Date start, Date end);

    /**
     * 查询指定角色的指定公司的人员
     */
    List<PersonVo> listByCompanyAndRole(List<Long> companyId, String role);

    /**
     * 入场人员
     */
    IPage<PersonVo> inPerson(PersonParam personParam, Page<PersonVo> page);

    /**
     * 红码人员
     */
    IPage<PersonVo> redPerson(Page<PersonVo> page, Long companyId, Boolean isCauseBad);

    /**
     * 按照审核状态分页查询
     *
     * @param page  分页信息
     * @param param 查询参数
     * @return Page<Map>
     */
    Page<ApprovalPersonVo> pageListByVerify(Page<ApprovalPersonVo> page, Map<String, Object> param);

    /**
     * 查询公司、项目下的人
     *
     * @param companyId 公司id
     * @param projectId 项目id
     * @param name      姓名
     * @return List<RiskWorkPersonVo>
     */
    List<RiskWorkPersonVo> queryPersonInComAndDept(@Param("companyId") Long companyId, @Param("projectId") Long projectId, @Param("name") String name);

    /**
     * 查询通过3级安全考试的人
     *
     * @param companyId       公司
     * @param projectId       项目
     * @param examSubjectType 考题类型
     * @return List<Long>
     */
    List<Long> selectPassPersonThreeExam(@Param("companyId") Long companyId, @Param("projectId") Long projectId, @Param("examSubjectType") String examSubjectType);

    /**
     * 查询通过指定作业考试的人
     *
     * @param param 参数
     * @return List<Long>
     */
    List<Long> selectProSkillExamPerson(Map<String, Object> param);

    /**
     * 查询阅读过知识的人
     *
     * @param param 参数
     * @return List<Long>
     */
    List<Long> selectKnowledgePerson(Map<String, Object> param);


    /**
     * 根据项目id获取分包商主管
     *
     * @param projectId
     */
    List<Person> getFBSDirector(Long projectId);

    /**
     * 根据项目id获取项目部HR
     *
     * @param roleKey
     */
    List<Person> getProjectDepartmentPersonByRolekey(String roleKey);
    /**
     * 待审核数量
     *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
     * @param verifyStatus 审核状态
     * @param companyId    公司id
     * @param projectId    项目id
     * @return Integer 数量
     */
    Integer waitVerifyCount(@Param("verifyStatus") int verifyStatus,
                            @Param("companyId") Long companyId,
                            @Param("projectId") Long projectId);


    /**
     * 根据任务id获取分包商主管
     *
     * @param taskId
     * @return
     */
    List<Person> getPersonByTaskId(Long taskId);

    IPage<PersonStatisticVo> statisticInPersonlistPage(Page<PersonStatisticVo> page, @Param("personStatisticParam") PersonStatisticParam personStatisticParam);
}
