package com.yeejoin.amos.boot.module.elevator.api.enums;
/**
 * 
 * 派遣单枚举类
 * @author kongfm
 * @date 2021-08-04
 * ***/
public  enum DispatchPaperEnums {


	//完成状态 WCZT
	notFinish("858","notFinish","未完成"),
	hasFinished("859","hasFinished","已完成"),

	//处置环节 CZHJ

	receivedAlert("860","receivedAlert","已接警"),
	dispatched("861","dispatched",	"已派遣"),
	rescueArrived("862","rescueArrived",	"已到达"),
	repaireArrived("863","repaireArrived",	"维保已到达"),
	rescued("864","rescued",	"救援完成"),
	rescueBack("865","rescueBack",	"救援回访"),
	repaired("866","repaired",	"维修完成"),
	reportorBack("867","reportorBack",	"报修人已反馈"),
	disposed("868","disposed",	"维保已处置"),
	complainantBack("869","complainantBack",	"投诉人已反馈"),


	// 警情类型 JJLX
	KRJY("960","KRJY","困人救援","250"),
	GZWX("961","GZWX",	"故障维修","251"),
	TSZX("962","TSZX",	"投诉咨询","252"),

	// 反馈方式 FKFS
	mainBack("856","mainBack","主动反馈"),
	phoneBack("857","phoneBack","电话回访"),

	// 维修结果 WXJG
	hasRepaired("940","hasRepaired","维修成功"),
	other("941","other","其他"),

	// 处置结果 CZJG
	hasDisposed("944","hasDisposed","已处置"),
	notDispose("945","notDispose","未处置"),

	// 反馈结果 FKJG
	satisfactory("942","satisfactory","满意"),
	unsatisfactory("943","unsatisfactory","不满意"),

	// 派遣单位 PQDW
	useUnit("949","useUnit","使用单位"),
	repairUnit("950","repairUnit","维保单位"),
	levelOneUnit("951","levelOneUnit","一级响应"),
	levelTwoUnit("952","levelTwoUnit","二级响应"),
	levelThreeUnit("953","levelThreeUnit","三级响应"),

	hasDispatched("956","hasDispatched","已派遣"),
	notDispatched("957","notDispatched","未派遣");




	private String id;
	private String code;
	private String value;
	private String dynamicCode;
	DispatchPaperEnums(String id, String code, String value) {
		this.id= id;
		this.code=code;
		this.value=value;
	}
	DispatchPaperEnums(String id, String code, String value, String dynamicCode) {
		this.id= id;
		this.code=code;
		this.value=value;
		this.dynamicCode = dynamicCode;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		this.value = value;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getDynamicCode() {
		return dynamicCode;
	}

	public void setDynamicCode(String dynamicCode) {
		this.dynamicCode = dynamicCode;
	}

	public static DispatchPaperEnums getEnumByCode(String code)
	{
		for (DispatchPaperEnums status : DispatchPaperEnums.values())
		{
			if (status.getCode().equals(code))
			{
				return status;
			}
		}
		return null;
	}
	public static DispatchPaperEnums getEnumById(String code)
	{
		for (DispatchPaperEnums status : DispatchPaperEnums.values())
		{
			if (status.getId().equals(code))
			{
				return status;
			}
		}
		return null;
	}
	
}
