package com.yeejoin.amos.boot.module.jg.api.enums;

import io.swagger.models.auth.In;

/**
 * 维保备案使用单位枚举
 */
public enum MaintenanceEnum {
    SHIYONG(0,"使用单位"),
    WEIBAO(1,"维保单位"),
    JIANGUAN(2,"监管单位");

    private Integer code;
    private String msg;

    MaintenanceEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }
    public static String getMsgByCode(Integer code) {
        String name = null;
        for (MaintenanceEnum enumOne : MaintenanceEnum.values()) {
            if (enumOne.getCode() == code) {
                name = enumOne.getMsg();
                break;
            }
        }
        return name;
    }
    public static MaintenanceEnum getEnumByMsg(String msg) {
        for (MaintenanceEnum enumOne : MaintenanceEnum.values()) {
            if (enumOne.getMsg().equals(msg)) {
                return enumOne;
            }
        }
        return null;
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
