package com.yeejoin.amos.boot.module.jg.flc.api.fegin;


import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;
import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.VerifyCodeAuthModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;


@FeignClient(name = "AMOS-API-WORKFLOW", path = "workflow", configuration = {MultipartSupportConfig.class})
public interface WorkFlowFeignService {

    /***
     * 根据task_id 获取节点信息
     *
     * */
    @RequestMapping(value = "/history/task/nodeInfo", method = RequestMethod.GET)
    FeignClientResult<JSONObject> getNodeInfo(@RequestParam(value = "taskId") String taskId);


    /***
     *
     * 查询当前流程对应的可执行任务，无权限级别
     * */

    @RequestMapping(value = "/task/getTaskNoAuth/{processInstanceId}", method = RequestMethod.GET)
    JSONObject getTaskNoAuth(@PathVariable(value = "processInstanceId") String processInstanceId);

    /***
     *
     * 获取流程审批日志
     * */
    @RequestMapping(value = "/task/flowLogger/{procInsId}", method = RequestMethod.GET)
    FeignClientResult<Map<String,Object>> getFlowLogger(@PathVariable(value = "procInsId") String procInsId);



    @RequestMapping(value = "/history/task/nodeInfo", method = RequestMethod.GET)
    FeignClientResult<JSONObject> getNodeInfotoken(
            @RequestHeader(name="appKey",required = true) String appKey,
            @RequestHeader(name="product",required = true) String product,
            @RequestHeader(name="token",required = true) String token,
            @RequestParam(value = "taskId") String taskId);


    /***
     *
     * 查询当前流程对应的可执行任务，无权限级别
     * */

    @RequestMapping(value = "/task/getTaskNoAuth/{processInstanceId}", method = RequestMethod.GET)
    JSONObject getTaskNoAuthtoken(
            @RequestHeader(name="appKey",required = true) String appKey,
            @RequestHeader(name="product",required = true) String product,
            @RequestHeader(name="token",required = true) String token,
            @PathVariable(value = "processInstanceId") String processInstanceId);


    @RequestMapping(value = "/v2/task/rollBack/{processInstanceId}", method = RequestMethod.POST)
    JSONObject rollBack(@PathVariable(value = "processInstanceId") String processInstanceId);



}
