package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintenanceContractDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContract;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContractEq;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.MaintenanceEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgMaintenanceContractMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgMaintenanceContractService;
import com.yeejoin.amos.boot.module.jg.api.vo.JgMaintenanceContractVo;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.WorkFlowFeignService;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.service.ICreateCodeService;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Service
public class JgMaintenanceContractServiceImpl extends BaseService<JgMaintenanceContractDto, JgMaintenanceContract, JgMaintenanceContractMapper> implements IJgMaintenanceContractService {

    public static final String SUBMIT_TYPE_FLOW = "1";
    public static final String WB_PROCESS_DEFINITION_KEY = "maintenanceFiling";
    private static final String HANDLING_STATUS_DICTIONARY = "JGGZZZ";
    @Autowired
    RestHighLevelClient restHighLevelClient;
    @Autowired
    WorkFlowFeignService workFlowFeginService;
    @Autowired
    @SuppressWarnings("all")
    private ICreateCodeService iCreateCodeService;
    @Autowired
    private JgMaintenanceContractMapper maintenanceContractMapper;
    @Autowired
    private JgMaintenanceContractEqServiceImpl jgMaintenanceContractEqService;
    @Autowired
    private DataDictionaryServiceImpl iDataDictionaryService;

    /**
     * 监管-根据字典type,code获取字典值
     */
    private DataDictionary getDict(String dictType, String dictCode) {
        HashMap<String, String> dictMap = new HashMap<>();
        LambdaQueryWrapper<DataDictionary> queryWrapper = new LambdaQueryWrapper<DataDictionary>().eq(DataDictionary::getType, dictType).eq(DataDictionary::getCode, dictCode);
        return iDataDictionaryService.getOne(queryWrapper);
    }

    /**
     * 分页查询
     */
    public Page<JgMaintenanceContractVo> queryForPage(Page<JgMaintenanceContract> page, int phase, JgMaintenanceContractDto dto, ReginParams reginParams) {
        Page<JgMaintenanceContractDto> contractList = new Page<>();
        Page<JgMaintenanceContractVo> result = new Page<>();
        CompanyBo company = reginParams.getCompany();
        if (MaintenanceEnum.SHIYONG.getCode().equals(phase)) {
            //使用单位用"使用单位统一信用代码"匹配数据
            dto.setUseUnitCode(company.getCompanyCode());
            dto.setApplyFlow(MaintenanceEnum.SHIYONG.getMsg());
            contractList = maintenanceContractMapper.getContractList(page, dto);
        } else if (MaintenanceEnum.WEIBAO.getCode().equals(phase)) {
            //维保单位用"维保单位统一信用代码"匹配数据
            dto.setMaintenanceUnitCode(company.getCompanyCode());
            dto.setApplyFlow(MaintenanceEnum.WEIBAO.getMsg());
            contractList = maintenanceContractMapper.getContractList(page, dto);
        } else if (MaintenanceEnum.JIANGUAN.getCode().equals(phase)) {
            //监管单位用"接收机构统一使用代码"匹配
            dto.setReceiveOrgCode(company.getOrgCode());
            dto.setApplyFlow(MaintenanceEnum.JIANGUAN.getMsg());
            contractList = maintenanceContractMapper.getContractList(page, dto);
        }
        BeanUtils.copyProperties(contractList, result);
        return result;
    }

    /**
     * 根据sequenceNbr查询数据
     */
    public JgMaintenanceContractVo queryBySequenceNbr(Long sequenceNbr) {
        JgMaintenanceContractDto dto = maintenanceContractMapper.queryBySequenceNbr(sequenceNbr);
        JgMaintenanceContractVo vo = new JgMaintenanceContractVo();
        BeanUtils.copyProperties(dto, vo);
        vo.setMaintenanceContract(ObjectUtils.isEmpty(dto.getMaintenanceContract()) ? null : JSON.parseArray(dto.getMaintenanceContract()));
        return vo;
    }

    /**
     * 根据sequenceNbr更新数据
     *
     * @param dto
     * @return
     */
    public Boolean updateBySequenceNbr(JgMaintenanceContractDto dto) {
        return maintenanceContractMapper.updateBySequenceNbr(dto);
    }

    /**
     * 批量删除
     */
    public Boolean deleteForBatch(Long[] ids) {
        return maintenanceContractMapper.deleteForBatch(Arrays.asList(ids));
    }

    /**
     * 维保合同提交
     */
    @Transactional
    public Boolean submit(JgMaintenanceContractDto dto) {
        String instanceId = "";
        //启动流程
        try {
            ActWorkflowStartDTO flowDto = new ActWorkflowStartDTO();
            flowDto.setProcessDefinitionKey(WB_PROCESS_DEFINITION_KEY);
            flowDto.setBusinessKey("1");
            HashMap<String, Object> dtoMap = new HashMap<>();
            dtoMap.put("condition", "ces");
            flowDto.setVariables(dtoMap);
            AjaxResult ajaxResult = Workflow.taskClient.startByVariable(flowDto);
            instanceId = ((Map<?, ?>) ajaxResult.get("data")).get("id").toString();
            ajaxResult = Workflow.taskClient.getTask(instanceId);
            // 执行一步
            JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
            String taskId = dataObject.getString("id");
            //组装信息
            TaskResultDTO taskResultDTO = new TaskResultDTO();
            taskResultDTO.setResultCode("approvalStatus");
            taskResultDTO.setTaskId(taskId);
            taskResultDTO.setComment("提交流程");
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", "1");
            taskResultDTO.setVariable(map);
            //执行流程
            Workflow.taskClient.completeByTask(taskId, taskResultDTO);
        } catch (Exception e) {
            e.printStackTrace();
        }

        String[] split = dto.getApplyFlow().split("-");
        String lastFlowName = split[split.length - 1];
        String applyFlow = dto.getApplyFlow() + "-" + MaintenanceEnum.getMsgByCode(Objects.requireNonNull(MaintenanceEnum.getEnumByMsg(lastFlowName)).getCode() + 1);
        dto.setApplyFlow(applyFlow);
        dto.setApplyStatus(FlowStatusEnum.TO_BE_PROCESSED.getName());
        dto.setInstanceId(instanceId);
        return this.updateBySequenceNbr(dto);
    }

    /**
     * 维保合同撤回
     */
    @Transactional
    public Boolean revocation(JgMaintenanceContractDto dto) {
        String[] split = dto.getApplyFlow().split("-");
        String lastFlowName = split[split.length - 1];
        String applyFlow = dto.getApplyFlow() + "-" + MaintenanceEnum.getMsgByCode(Objects.requireNonNull(MaintenanceEnum.getEnumByMsg(lastFlowName)).getCode() - 1);
        dto.setApplyFlow(applyFlow);
        dto.setApplyStatus(FlowStatusEnum.TO_BE_SUBMITTED.getName());
        workFlowFeginService.rollBack(dto.getInstanceId());
        return this.updateBySequenceNbr(dto);
    }

    /**
     * 维保合同驳回
     */
    @Transactional
    public Boolean rejected(JgMaintenanceContractDto dto) {
        String[] split = dto.getApplyFlow().split("-");
        String lastFlowName = split[split.length - 1];
        String applyFlow = dto.getApplyFlow() + "-" + MaintenanceEnum.getMsgByCode(Objects.requireNonNull(MaintenanceEnum.getEnumByMsg(lastFlowName)).getCode() - 1);
        dto.setApplyFlow(applyFlow);
        dto.setApplyStatus(FlowStatusEnum.REJECTED.getName());
        return this.updateBySequenceNbr(dto);
    }

    /**
     * 维保合同受理
     */
    @Transactional
    public Boolean accepted(JgMaintenanceContractDto dto) {
        String[] split = dto.getApplyFlow().split("-");
        String lastFlowName = split[split.length - 1];
        String applyFlow = dto.getApplyFlow() + "-" + MaintenanceEnum.getMsgByCode(Objects.requireNonNull(MaintenanceEnum.getEnumByMsg(lastFlowName)).getCode() + 1);
        dto.setApplyFlow(applyFlow);
        dto.setApplyStatus(FlowStatusEnum.TO_BE_PROCESSED.getName());
        return this.updateBySequenceNbr(dto);
    }

    /**
     * 新增维保合同
     */
    @Transactional
    public Boolean saveOrSubmit(String submit, Map<String, Object> map, ReginParams reginParams) {
        // 判断当前是否为提交
        String instanceId = null;
        if (SUBMIT_TYPE_FLOW.equals(submit)) {
            // 发起流程
            try {
                ActWorkflowStartDTO flowDto = new ActWorkflowStartDTO();
                flowDto.setProcessDefinitionKey(WB_PROCESS_DEFINITION_KEY);
                flowDto.setBusinessKey("1");
                HashMap<String, Object> dtoMap = new HashMap<>();
                dtoMap.put("condition", "ces");
                flowDto.setVariables(dtoMap);
                AjaxResult ajaxResult = Workflow.taskClient.startByVariable(flowDto);
                instanceId = ((Map<?, ?>) ajaxResult.get("data")).get("id").toString();
                ajaxResult = Workflow.taskClient.getTask(instanceId);
                // 执行一步
                JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
                String taskId = dataObject.getString("id");
                //组装信息
                TaskResultDTO taskResultDTO = new TaskResultDTO();
                taskResultDTO.setResultCode("approvalStatus");
                taskResultDTO.setTaskId(taskId);
                taskResultDTO.setComment("提交流程");
                HashMap<String, Object> hashMap = new HashMap<>();
                hashMap.put("approvalStatus", "0");
                taskResultDTO.setVariable(hashMap);
                //执行流程
                Workflow.taskClient.completeByTask(taskId, taskResultDTO);
            } catch (Exception e) {
                log.error("维保使用单位提交流程启动失败：{}", e);
            }
        }
        JgMaintenanceContractDto dto = JSON.parseObject(JSON.toJSONString(map), JgMaintenanceContractDto.class);
        Object o = map.get("equipmentLists");
        List<Object> equipmentLists = Collections.singletonList(o);
        CompanyBo company = reginParams.getCompany();
        JgMaintenanceContract contract = new JgMaintenanceContract();
        BeanUtils.copyProperties(dto, contract);
        //获取维保备案编号
        String wbApplyNo = iCreateCodeService.createApplicationFormCode(ApplicationFormTypeEnum.WB.getCode(), 1).get(0);
        contract.setApplyNo(wbApplyNo);
        contract.setInstanceId(instanceId);
        contract.setUseUnitCode(company.getCompanyCode());
        contract.setUseUnitName(company.getCompanyName());
        contract.setApplyFlow(MaintenanceEnum.SHIYONG.getMsg());
        contract.setApplyStatus(FlowStatusEnum.TO_BE_SUBMITTED.getName());
        contract.setEquNum(equipmentLists.size());
        contract.setInstanceId(instanceId);
        this.save(contract);
        List<JgMaintenanceContractEq> equipList = new ArrayList<>();
        equipmentLists.forEach(x -> {
            JgMaintenanceContractEq equip = new JgMaintenanceContractEq();
            equip.setEquId(String.valueOf(x));

            equipList.add(equip);
        });
        return jgMaintenanceContractEqService.saveBatch(equipList);
    }

    /**
     * 更新维保合同和设备对应关系
     */
    @Transactional
    public Boolean updateMaintenanceAndEquipment(JgMaintenanceContractDto dto, List<Integer> EquipmentLists) {
        //更新维保合同表
        this.updateBySequenceNbr(dto);

        List<Integer> collect = EquipmentLists.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            //先删除原先设备对应关系
            LambdaQueryWrapper<JgMaintenanceContractEq> queryWrapper = new LambdaQueryWrapper<JgMaintenanceContractEq>().eq(JgMaintenanceContractEq::getBusinessId, dto.getApplyNo()).eq(JgMaintenanceContractEq::getIsDelete, false);
            List<Long> list = jgMaintenanceContractEqService.list(queryWrapper).stream().map(JgMaintenanceContractEq::getSequenceNbr).collect(Collectors.toList());
            jgMaintenanceContractEqService.deleteBatchSeq(list);
            //重新生成关系表
            List<JgMaintenanceContractEq> equipList = new ArrayList<>();
            collect.forEach(x -> {
                JgMaintenanceContractEq equip = new JgMaintenanceContractEq();
//                equip.setBusinessId(dto.getApplyNo());
//                equip.setEquipId(String.valueOf(x));
//                equip.setBusinessType(BusinessTypeEnum.MAINTENANCE_RECORD.getName());
                equipList.add(equip);
            });
            return jgMaintenanceContractEqService.saveBatch(equipList);
        }
        return true;
    }


    /**
     * 列表查询 示例
     */
    public List<JgMaintenanceContractDto> queryForJgMaintenanceContractList() {
        return this.queryForList("", false);
    }
}