package com.yeejoin.amos.boot.module.jyjc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
 * 业务开通申请表
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_jyjc_inspection_result")
public class JyjcInspectionResult extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 检验检测单位编码
     */
	@TableField("inspection_unit_code")
    private String inspectionUnitCode;

    /**
     * 报检单号
     */
	@TableField("application_no")
    private String applicationNo;

    /**
     * 报检单位编号
     */
	@TableField("application_unit_code")
    private String applicationUnitCode;

    /**
     * 设备唯一标识
     */
	@TableField("equip_unicode")
    private String equipUnicode;

    /**
     * 检验结果状态（已出、未出）
     */
	@TableField("result_status")
    private String resultStatus;

    /**
     * 核准证号/许可证号
     */
	@TableField("license_number")
    private String licenseNumber;

    /**
     * 检验报告编号
     */
	@TableField("result_no")
    private String resultNo;

    /**
     * 检验人员（多个逗号分割）
     */
	@TableField("inspector")
    private String inspector;

    /**
     * 内部人员代码
     */
	@TableField("inner_person_code")
    private String innerPersonCode;

    /**
     * 检验结论
     */
	@TableField("inspection_conclusion")
    private String inspectionConclusion;

    /**
     * 检验日期
     */
	@TableField("inspection_date")
    private Date inspectionDate;

    /**
     * 下次检验日期
     */
	@TableField("next_inspection_date")
    private Date nextInspectionDate;

    /**
     * 检验开始日期
     */
	@TableField("inspection_start_date")
    private Date inspectionStartDate;

    /**
     * 检验结束日期
     */
	@TableField("inspection_end_date")
    private Date inspectionEndDate;

    /**
     * 检验结果汇总
     */
	@TableField("inspection_result_summary")
    private String inspectionResultSummary;

    /**
     * 不符合项
     */
	@TableField("non_conformance")
    private String nonConformance;

    /**
     * 整改情况
     */
	@TableField("rectification")
    private String rectification;

    /**
     * 备注(无用预留)
     */
	@TableField("remark")
    private String remark;

    /**
     * 业务类型（与菜单对应拆表使用）
     */
	@TableField("biz_type")
    private String bizType;

    /**
     * 设备类别
     */
    @TableField("equ_category")
    private String equCategory;

    /**
     * 检验检测类型编码
     */
    @TableField("inspection_type")
    private String inspectionType;

    /**
     * 检验检测类型名称（冗余）
     */
    @TableField("inspection_type_name")
    private String inspectionTypeName;

    /**
     * 报检日期
     */
    @TableField("application_date")
    private Date applicationDate;

    /**
     * 检验结果方式
     */
    @TableField("result_type")
    private String resultType;


    /**
     * 设备种类
     */
    @TableField("equ_list")
    private String equList;


    /**
     * 设备品种
     */
    @TableField("equ_define")
    private String equDefine;
}
