package com.yeejoin.amos.boot.module.jyjc.biz.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationEquipModel;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationModel;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionApplicationServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 *
 * @author system_generator
 * @date 2023-12-14
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/jyjc-inspection-application")
public class JyjcInspectionApplicationController extends BaseController {

    @Autowired
    JyjcInspectionApplicationServiceImpl jyjcInspectionApplicationServiceImpl;


    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<JyjcInspectionApplicationModel> save(@RequestBody JyjcInspectionApplicationModel model) {

		ReginParams selectedOrgInfo = getSelectedOrgInfo();
		model.setApplicationUnitCode(selectedOrgInfo.getCompany().getCompanyCode());
		return ResponseHelper.buildResponse(jyjcInspectionApplicationServiceImpl.save(model));
	}



	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<JyjcInspectionApplicationModel> updateBySequenceNbrJyjcInspectionApplication(@RequestBody JyjcInspectionApplicationModel model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {

		model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jyjcInspectionApplicationServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jyjcInspectionApplicationServiceImpl.removeById(sequenceNbr));
    }



	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/deleteBatch")
	@ApiOperation(httpMethod = "DELETE", value = "批量删除", notes = "批量删除")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, List<Long>sequenceNbr){

		jyjcInspectionApplicationServiceImpl.deleteBatchData(sequenceNbr);


		return ResponseHelper.buildResponse(jyjcInspectionApplicationServiceImpl.deleteBatchSeq(sequenceNbr));
	}

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<Map<String,Object>> selectOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(jyjcInspectionApplicationServiceImpl.selectBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/pageByInstitution")
	@ApiOperation(httpMethod = "GET",value = "分页查询（检验机构）",  notes = "分页查询（检验机构）")
	public ResponseModel<Page<JyjcInspectionApplication>> queryForPageByInstitution(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size,@RequestParam(required = false) String applicationNo,
											  @RequestParam(required = false) String inspectionClassify,
											  @RequestParam(required = false) String applicationUnitCode,
											  @RequestParam(required = false) String applicationUnitName,
											  @RequestParam(required = false) String inspectionUnitName,
											  @RequestParam(required = false) String equipClassify,
											  @RequestParam(required = false) String inspectionUnitCode,
											  @RequestParam(required = false) String applicationDate,
											  @RequestParam(required = false) String acceptDate,
											  @RequestParam(required = false) String inspectionChargePerson,
											  @RequestParam(required = false) String status , String bizType) {
	    Page<JyjcInspectionApplication> page = new Page<JyjcInspectionApplication>();
	    page.setCurrent(current);
	    page.setSize(size);

		ReginParams reginParams = getSelectedOrgInfo();
		inspectionUnitCode = reginParams.getCompany().getCompanyCode();
		return ResponseHelper.buildResponse(jyjcInspectionApplicationServiceImpl.queryForJyjcInspectionApplicationPage(page,applicationNo,inspectionClassify,applicationUnitCode,applicationUnitName,equipClassify,inspectionUnitCode,inspectionUnitName,applicationDate,acceptDate,inspectionChargePerson,status,bizType));
	}


		@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/pageByCompany")
	@ApiOperation(httpMethod = "GET",value = "分页查询（报检单位）",  notes = "分页查询（报检单位）")
	public ResponseModel<Page<JyjcInspectionApplication>> queryForPageByCompany(@RequestParam(value = "current") int current,@RequestParam
			(value = "size") int size,@RequestParam(required = false) String applicationNo,
																				@RequestParam(required = false) String inspectionClassify,
																				@RequestParam(required = false) String applicationUnitCode,
																				@RequestParam(required = false) String equipClassify,
																				@RequestParam(required = false) String inspectionUnitCode,
																				@RequestParam(required = false) String applicationUnitName,
																				@RequestParam(required = false) String inspectionUnitName,
																				@RequestParam(required = false) String applicationDate,
																				@RequestParam(required = false) String acceptDate,
																				@RequestParam(required = false) String inspectionChargePerson,
																				@RequestParam(required = false) String status , String bizType) {
		Page<JyjcInspectionApplication> page = new Page<JyjcInspectionApplication>();
		page.setCurrent(current);
		page.setSize(size);
		ReginParams reginParams = getSelectedOrgInfo();
		applicationUnitCode = reginParams.getCompany().getCompanyCode();
		return ResponseHelper.buildResponse(jyjcInspectionApplicationServiceImpl.queryForJyjcInspectionApplicationPage(page,applicationNo,inspectionClassify,applicationUnitCode,applicationUnitName,equipClassify,inspectionUnitCode,inspectionUnitName,applicationDate,acceptDate,inspectionChargePerson,status,bizType));
		}

			/**
             * 列表全部数据查询
             *
             * @return
             */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JyjcInspectionApplicationModel>> selectForList() {
	    return ResponseHelper.buildResponse(jyjcInspectionApplicationServiceImpl.queryForJyjcInspectionApplicationList());
	}

	/**
	 * 接收接口
	 *
	 *
	 * @param params params
	 * @return {@link  ResponseModel< HashMap< String  String>>}
	 * @author yangyang
	 * @throws
	 * @date 2023/12/15 11:25
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "接收",   notes = "接收")
	@PostMapping(value = "/flow/{type}/receive")
	public ResponseModel<HashMap<String,String>> execueFlow(@PathVariable(value = "type") String type, @RequestBody Map<String, Object> params) {
		params.put("type", type);
		jyjcInspectionApplicationServiceImpl.doReceive(params);
		HashMap<String,String> result =new HashMap<>();
		result.put("result","success");
		return ResponseHelper.buildResponse(result);
	}

	/**
	 * 退回接口（监督检验、定（首）检、检测）-通用
	 *
	 *
	 * @param params params
	 * @return {@link }
	 * @author yangyang
	 * @throws
	 * @date 2023/12/15 13:44
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "退回",   notes = "退回")
	@PostMapping(value = "/flow/reject")
	public void doRejectFlow(@RequestBody Map<String,Object> params) {
		jyjcInspectionApplicationServiceImpl.doReject(params);
	}

	/**
	 * 撤回接口（监督检验、定（首）检、检测）-通用
	 *
	 *
	 * @param sequenceNbr sequenceNbr
	 * @return {@link }
	 * @author yangyang
	 * @throws
	 * @date 2023/12/15 13:39
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "撤回",   notes = "撤回")
	@GetMapping(value = "/flow/rollback")
	public void doRollbackFlow(@RequestParam("sequenceNbr") String sequenceNbr) {
		jyjcInspectionApplicationServiceImpl.doRollback(sequenceNbr);
	}
	/**
	 * 查询指定设备种类的设备列表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "查询指定设备种类的设备列表",   notes = "查询指定设备种类的设备列表")
	@GetMapping(value = "/listByCategory")
	public ResponseModel<Page<JyjcInspectionApplicationEquipModel>> listByCategory(
			@RequestParam("current") int current,
			@RequestParam("size") int size,
			@RequestParam("equipClassify") String equipClassify) {
		Page<JyjcInspectionApplicationEquipModel> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(jyjcInspectionApplicationServiceImpl.listByCategory(page,equipClassify));
	}
}
