package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapBuilder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.enums.WorkFlowEnum;
import com.yeejoin.amos.boot.biz.common.workflow.feign.WorkflowFeignService;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationAttachment;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationEquip;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResult;
import com.yeejoin.amos.boot.module.jyjc.api.enums.DocumentEnum;
import com.yeejoin.amos.boot.module.jyjc.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationAttachmentModel;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationEquipModel;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationModel;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionApplicationService;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.handler.JyjcInspectionApplicationHandlerFactory;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.service.ICreateCodeService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.*;
import java.util.stream.Collectors;


import static com.yeejoin.amos.boot.biz.common.service.impl.WorkflowExcuteServiceImpl.buildOrderNo;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
@Slf4j
public class JyjcInspectionApplicationServiceImpl extends BaseService<JyjcInspectionApplicationModel, JyjcInspectionApplication, JyjcInspectionApplicationMapper> implements IJyjcInspectionApplicationService {

    @Autowired
    private JyjcInspectionResultServiceImpl inspectionResultService;
    @Autowired
    private JyjcInspectionApplicationEquipServiceImpl applicationEquipService;
    @Autowired
    private ICreateCodeService createCodeService;
    @Autowired
    private WorkflowHelper workflowHelper;
    /**
     * 分页查询
     */

    @Autowired
    JyjcInspectionApplicationAttachmentServiceImpl jyjcInspectionApplicationAttachmentService;
    @Autowired
    JyjcInspectionApplicationEquipServiceImpl jyjcInspectionApplicationEquipService;
    @Autowired
    JyjcInspectionApplicationPushLogServiceImpl jyjcInspectionApplicationPushLogService;

    @Autowired
    WorkflowFeignService workflowFeignService;


    public JyjcInspectionApplicationModel save(@RequestBody JyjcInspectionApplicationModel model) {

        //开启报检流程工作流
        if (!model.getOperationType().equals("2")) {
            if (model.getOperationType().equals("0")) {
                JSONObject body = new JSONObject();
                String businessKey = buildOrderNo();
                body.put(WorkFlowEnum.BUSINESSKEY.getCode(), businessKey);
                body.put(WorkFlowEnum.processDefinitionKey.getCode(), model.getProcessKey());
                JSONObject jsonObject = workflowFeignService.startByVariable(body);
                String processId = JSONObject.parseObject(JSONObject.toJSONString(jsonObject.get("data"))).getString("id");
                model.setProcessInstanceId(processId);
                model.setStatus("已提交");
            } else if (model.getOperationType().equals("1")) {
                model.setStatus("草稿");
            }
            model.setApplicationNo(UUID.randomUUID().toString());
            model.setApplicationDate(new Date());
            model = this.createWithModel(model);
            //保存报检装备监管码
            if (null != model.getEquip() && model.getEquip().size() > 0) {
                List<Map<String, Object>> equip = model.getEquip();
                List<String> jgm = equip.stream().map(e -> e.get("equipUnicode").toString()).collect(Collectors.toList());
                for (String s : jgm) {
                    JyjcInspectionApplicationEquip equipInfo = new JyjcInspectionApplicationEquip();
                    equipInfo.setApplicationSeq(model.getSequenceNbr());
                    equipInfo.setEquipUnicode(s);
                    jyjcInspectionApplicationEquipService.save(equipInfo);
                }
            }

            Map<String, Object> map = BeanUtil.beanToMap(model);
            // 附件保存
            List<String> enumNameList = DocumentEnum.getEnumNameList();
            List<JyjcInspectionApplicationAttachmentModel> attachmentModels = new ArrayList<>();
            for (String code : enumNameList) {
                if (map.containsKey(code)) {
                    JyjcInspectionApplicationAttachment attachments = new JyjcInspectionApplicationAttachment();
                    attachments.setAttachmentType(code);
                    attachments.setAttachmentUrl(JSONObject.toJSONString(map.get(code)));
                    attachments.setApplicationSeq(model.getSequenceNbr());
                    jyjcInspectionApplicationAttachmentService.getBaseMapper().insert(attachments);
                }
            }
        } else {

            //更新报检装备监管码
            jyjcInspectionApplicationEquipService.getBaseMapper().deleteByApplicationSeq(model.getSequenceNbr());
            if (model.getEquip().size() > 0) {
                List<Map<String, Object>> equip = model.getEquip();
                List<String> jgm = equip.stream().map(e -> e.get("equipUnicode").toString()).collect(Collectors.toList());
                for (String s : jgm) {
                    JyjcInspectionApplicationEquip equipInfo = new JyjcInspectionApplicationEquip();
                    equipInfo.setApplicationSeq(model.getSequenceNbr());
                    equipInfo.setEquipUnicode(s);
                    jyjcInspectionApplicationEquipService.save(equipInfo);
                }
            }

            Map<String, Object> map = BeanUtil.beanToMap(model);
            // 附件更新
            List<String> enumNameList = DocumentEnum.getEnumNameList();
            List<JyjcInspectionApplicationAttachmentModel> attachmentModels = new ArrayList<>();

            jyjcInspectionApplicationAttachmentService.getBaseMapper().deleteByApplicationSeq(model.getSequenceNbr());
            for (String code : enumNameList) {
                if (map.containsKey(code)) {
                    JyjcInspectionApplicationAttachment attachments = new JyjcInspectionApplicationAttachment();
                    attachments.setAttachmentType(code);
                    attachments.setAttachmentUrl(JSONObject.toJSONString(map.get(code)));
                    attachments.setApplicationSeq(model.getSequenceNbr());
                    jyjcInspectionApplicationAttachmentService.getBaseMapper().insert(attachments);
                }
            }
            model.setStatus("已提交");
            this.updateWithModel(model);
        }
        return model;
    }


    public void deleteBatchData(List<Long> sequenceNbr) {

        List<JyjcInspectionApplication> jyjcInspectionApplications = this.getBaseMapper().selectBatchIds(sequenceNbr);
        long count = jyjcInspectionApplications.stream().filter(e -> !e.getStatus().equals("已撤销") && !e.getStatus().equals("已撤回")).count();

        if (count > 0) {
            throw new BadRequest("存在 非已撤销、已退回状态的报检单 不可删除!");
        }


        this.deleteBatchSeq(sequenceNbr);
        for (Long seq : sequenceNbr) {
            jyjcInspectionApplicationEquipService.getBaseMapper().deleteByApplicationSeq(seq);
            jyjcInspectionApplicationAttachmentService.getBaseMapper().deleteByApplicationSeq(seq);
            jyjcInspectionApplicationPushLogService.getBaseMapper().deleteByApplicationSeq(seq);
        }


    }

    public Page<JyjcInspectionApplicationEquipModel> listByCategory(Page<JyjcInspectionApplicationEquipModel> page, String equipClassify) {
        return getBaseMapper().listByCategory(page, equipClassify);
    }


    public Page<JyjcInspectionApplication> queryForJyjcInspectionApplicationPage(Page<JyjcInspectionApplication> page,
                                                                                 String applicationNo,
                                                                                 String inspectionClassify,
                                                                                 String applicationUnitCode,
                                                                                 String equipClassify,
                                                                                 String inspectionUnitCode,
                                                                                 String applicationUnitName,
                                                                                 String inspectionUnitName,
                                                                                 String applicationDate,
                                                                                 String acceptDate,
                                                                                 String inspectionChargePerson,
                                                                                 String status, String bizType) {

        return this.getBaseMapper().queryForDataList(page, applicationNo, inspectionClassify, applicationUnitCode, applicationUnitName, equipClassify, inspectionUnitCode, inspectionUnitName, applicationDate, acceptDate, inspectionChargePerson, status, bizType);

    }

    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionApplicationModel> queryForJyjcInspectionApplicationList() {
        return this.queryForList("", false);
    }

    public Map<String, Object> selectBySeq(Long sequenceNbr) {

        JyjcInspectionApplicationModel model = this.getBaseMapper().selectDataBySeq(sequenceNbr);
        Map<String, Object> map = BeanUtil.beanToMap(model);
        List<Map<String, Object>> dataByApplicationSeq = jyjcInspectionApplicationAttachmentService.getBaseMapper().getDataByApplicationSeq(sequenceNbr);
        Map<String, Object> attMap = new HashMap<>();
        for (Map<String, Object> maps : dataByApplicationSeq) {
            List<AttachmentDto> data = JSONArray.parseArray(maps.get("attachment_url").toString(), AttachmentDto.class);
            attMap.put(maps.get("attachment_type").toString(), data);
        }
        map.putAll(attMap);
        return map;
    }


    /**
     * 接收
     *
     * @param params params
     * @return {@link }
     * @throws
     * @author yangyang
     * @date 2023/12/15 15:14
     */
    public void doReceive(Map<String, Object> params) {
        execueFlow(params);
        // 执行接收业务
        String type = (String) params.get("type");
        Long sequenceNbr = (Long) params.get("sequenceNbr");
        JyjcInspectionApplicationModel inspectionApplicationModel = this.queryBySeq(sequenceNbr);
        List<JyjcInspectionApplicationEquipModel> applicationEquipModels = applicationEquipService.listApplicationEquipByApplicationSeq(sequenceNbr);
        if (inspectionApplicationModel == null || ValidationUtil.isEmpty(applicationEquipModels)) {
            log.warn("JyjcInspectionApplicationModel Not Found！");
            return;
        }
        List<JyjcInspectionResult> resultModels = new ArrayList(applicationEquipModels.size());
        List<String> codes = createCodeService.createApplicationFormCode(ApplicationFormTypeEnum.JG.getCode(), applicationEquipModels.size());
        for (int i = 0; i < applicationEquipModels.size(); i++) {
            JyjcInspectionResult resultModel = new JyjcInspectionResult();
            resultModel.setInspectionUnitCode(inspectionApplicationModel.getInspectionUnitCode());
            resultModel.setApplicationNo(inspectionApplicationModel.getApplicationNo());
            resultModel.setApplicationUnitCode(inspectionApplicationModel.getApplicationUnitCode());
            resultModel.setResultStatus("未出");
            resultModel.setApplicationDate(inspectionApplicationModel.getApplicationDate());
            resultModel.setResultType(inspectionApplicationModel.getResultType());
            // 解析设备
            resultModel.setBizType(inspectionApplicationModel.getBizType());
            resultModel.setResultNo(codes.get(i));
            resultModel.setEquipUnicode(applicationEquipModels.get(i).getEquipUnicode());//设备唯一标识
        }
        inspectionResultService.saveOrUpdateBatch(resultModels);
        // 通知对应的检验机构
        Map<String, Object> thiryPartParams = MapBuilder.<String, Object>create().put("inspectionApplication", inspectionApplicationModel).put("applicationEquips", applicationEquipModels).build();
        JyjcInspectionApplicationHandlerFactory.apply(type).notifyInspectionUnit(thiryPartParams);
    }

    /**
     * 退回
     *
     * @param params params
     * @return {@link }
     * @throws
     * @author yangyang
     * @date 2023/12/15 15:14
     */
    public void doReject(Map<String, Object> params) {
        execueFlow(params);
        String instanceId = Optional.ofNullable(params.get("instanceId")).orElse("").toString();
        params.put("status", FlowStatusEnum.REJECTED.getCode() + "");
        updateModelByInstanceId(instanceId, params);
    }

    /**
     * 接收/驳回通知检验单
     */
    public void execueFlow(Map<String, Object> params) {
        String op = params.get("op").toString();
        String instanceId = params.get("instanceId").toString();
        String comments = params.get("comments").toString();
        try {
            AjaxResult ajaxResult = Workflow.taskClient.getTask(instanceId);
            JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
            String taskId = dataObject.getString("id");
            //组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResultCode("approvalStatus");
            dto.setTaskId(taskId);
            HashMap<String, Object> varibalble = new HashMap<>();
            varibalble.put("approvalStatus", op);
            dto.setVariable(varibalble);
            dto.setComment(comments);
            // 执行流程
            AjaxResult ajaxResult1 = Workflow.taskClient.completeByTask(taskId, dto);
            if (ObjectUtils.isEmpty(ajaxResult1)) {

            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("执行工作流错误, => {}", params, e);
        }
    }

    /**
     * 撤回流程办理单
     */
    public void doRollback(String sequenceNbr) {
        JSONObject jsonObject;
        JyjcInspectionApplicationModel inspectionApplicationModel = this.queryBySeq(Long.valueOf(sequenceNbr));
        if (inspectionApplicationModel == null) {
            log.warn("JyjcInspectionApplicationModel Not Found！sequenceNbr => " + sequenceNbr);
            return;
        }
        try {
            // 撤回流程
            jsonObject = workflowHelper.rollBack(inspectionApplicationModel.getProcessInstanceId());
            if (ObjectUtils.isEmpty(jsonObject)) {

            }
            updateModelByInstanceId(inspectionApplicationModel.getProcessInstanceId(), MapBuilder.<String, Object>create().put("status", FlowStatusEnum.REJECTED.getCode() + "").build());
        } catch (Exception e) {
            e.printStackTrace();
            log.error("撤回工作流错误, => {}", inspectionApplicationModel.getProcessInstanceId(), e);
        }
    }

    public void updateModelByInstanceId(String instanceId, Map<String, Object> params) {
        JyjcInspectionApplication entity = this.lambdaQuery().eq(JyjcInspectionApplication::getProcessInstanceId, instanceId).one();
        if (entity == null) {
            return;
        }
        String status = (String) params.get("status");
        String inspectionChargePerson = (String) params.get("inspectionChargePerson");
        String inspectionChargePhone = (String) params.get("inspectionChargePhone");
        String processDescription = (String) params.get("comments");
        if (StringUtils.isNotBlank(inspectionChargePerson)) {
            entity.setInspectionChargePerson(inspectionChargePerson);
        }
        if (StringUtils.isNotBlank(inspectionChargePhone)) {
            entity.setInspectionChargePhone(inspectionChargePhone);
        }
        if (StringUtils.isNotBlank(processDescription)) {
            entity.setProcessDescription(processDescription);
        }
        JSONObject taskJson = workflowHelper.getTask(instanceId);
        if (taskJson == null) {
            log.warn("流程=>{}查询不到或已结束", instanceId);
            return;
        }
        entity.setWorkflowRole(workflowHelper.getWorkflowRoleGroups(taskJson));
        entity.setWorkflowNode(taskJson.getString("taskDefinitionKey"));
        // entity.setWorkflowActiveKey();
        entity.setStatus(status);
        // entity.setStatusName(FlowStatusEnum.getNameByType(Long.parseLong(status)));
        this.updateById(entity);
    }
}