package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultAttachment;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionResultAttachmentMapper;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultAttachmentService;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultAttachmentModel;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
public class JyjcInspectionResultAttachmentServiceImpl extends BaseService<JyjcInspectionResultAttachmentModel,JyjcInspectionResultAttachment,JyjcInspectionResultAttachmentMapper> implements IJyjcInspectionResultAttachmentService {
    /**
     * 分页查询
     */
    public Page<JyjcInspectionResultAttachmentModel> queryForJyjcInspectionResultAttachmentPage(Page<JyjcInspectionResultAttachmentModel> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionResultAttachmentModel> queryForJyjcInspectionResultAttachmentList()   {
        return this.queryForList("" , false);
    }

    @Override
    public List<JyjcInspectionResultAttachment> getObjByResultSeq(Long resultSeq) {
        LambdaQueryWrapper<JyjcInspectionResultAttachment> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(JyjcInspectionResultAttachment::getResultSeq, resultSeq);
        return this.baseMapper.selectList(wrapper);
    }
}