package com.yeejoin.amos.boot.module.ugp.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
@ApiModel(value = "ProblemCodeLibDto", description = "质量问题代码库表")
public class ProblemCodeLibDto extends BaseDto {
    @ApiModelProperty("质量问题产生阶段")
    private String genStage;

    @ApiModelProperty("质量问题")
    private String content;

    @ApiModelProperty("质量问题代码")
    private String code;

    @ApiModelProperty("监管指标")
    private String indicator;

    @ApiModelProperty("监管指标单位")
    private String idxUnit;

    @ApiModelProperty("监管指标类型")
    private String idxType;

    @ApiModelProperty("监管指标阈值")
    private List<Map<String, String>> idxThresholds = new ArrayList<>();

    @ApiModelProperty("创建日期")
    private Date createDate;

    @ApiModelProperty("备注")
    private String remark;
}
