package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 
 *
 * @author chenhao
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equipment_standard")
@ApiModel(value = "EquipmentStandard对象", description = "")
public class EquipmentStandard extends BaseEntity {

    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty(value = "装备编码")
    @TableField("equipment_id")
    private String equipmentId;
    
    @ApiModelProperty(value = "当前维保规范的设定类型")
    @TableField("type")
    private String type;
    
    @ApiModelProperty(value = "性能指标对应id")
    @TableField("standard_key")
    private String standardKey;
    
    @ApiModelProperty(value = "维保规范内容")
    @TableField("standard_name")
    private String standardName;
    
    @ApiModelProperty(value = "维保规范创建人id")
    @TableField("create_id")
    private String createId;
    
    @ApiModelProperty(value = "当前维保规范操作人对应的公司编码")
    @TableField("org_code")
    private String orgCode;



}
