package com.yeejoin.precontrol.common.vo.taskStatistical;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.yeejoin.precontrol.common.annotations.TableFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 作业活动Vo
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class TaskPayStatisticalVo {
    private static final long serialVersionUID = 1L;
    private Long id;
    @ApiModelProperty(value = "作业类型")
    @Excel(name = "作业类型", replace = {"技术交底_0", "三交三查_1", "违规管理_2"}, width = 20)
    private Long type;
    @ApiModelProperty(value = "任务单号")
    @Excel(name = "单号", width = 20)
    private Long taskNo;
    @Excel(name = "所属项目", width = 20)
    @ApiModelProperty(value = "项目名称")
    private String projectName;
    @Excel(name = "风险作业", width = 20)
    @ApiModelProperty(value = "风险作业名称")
    private String riskType;
    @ApiModelProperty(value = "发起人名称")
    @Excel(name = "发起人", width = 20)
    private String createPersonName;
    @Excel(name = "地区", width = 20)
    @ApiModelProperty(value = "地区名称")
    private String regionName;
    @ApiModelProperty(value = "创建时间")
    @Excel(name = "日期", exportFormat = "yyyy-MM-dd HH:mm:ss", width = 20)
    private Date createDate;


    @ApiModelProperty(value = "发起人id")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "createPersonName")
    private Long createPersonId;
    @ApiModelProperty(value = "所属项目id")
    @TableFormat(entityName = "rpm_project", fieldName = "name", operFieldName = "projectName")
    private Long projectId;

}
