package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.config.PersonIdentify;
import com.yeejoin.equipmanage.service.IEmergencyService;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: AlarmStatisticController
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2024/7/31 19:33
 */
@RestController
@Api(tags = "中心告警统计Api")
@RequestMapping(value = "/center/alarm", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class AlarmStatisticController extends AbstractBaseController {

    @Autowired
    IEmergencyService iEmergencyService;

    @Autowired
    private IFireFightingSystemService iFireFightingSystemService;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/CAFS/cannon", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取消防炮统计信息", notes = "获取消防炮统计信息")
    public ResponseModel getFireCannonInfo(@RequestParam(required = false) String bizOrgCode) {
        List<Map<String, Object>> list = iFireFightingSystemService.getFireCannonInfo(bizOrgCode);
        return CommonResponseUtil.success(list);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("炮阀")
    @GetMapping(value = "/fireCannonValve")
    public ResponseModel<List<Map<String, Object>>> fireCannonValve(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode) {
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
        }
        return CommonResponseUtil.success(iEmergencyService.fireCannonValve(bizOrgCode));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/alarmList")
    @ApiOperation(httpMethod = "GET", value = "消防告警信息", notes = "消防告警信息")
    public ResponseModel alarmList(@RequestParam Integer pageNumber,
                                   @RequestParam Integer pageSize,
                                   @RequestParam(required = false) List<String> types,
                                   @RequestParam(required = false) List<String> emergencyLevels,
                                   @RequestParam(required = false) String name,
                                   @RequestParam(required = false) Integer cleanStatus,
                                   @RequestParam(required = false) Integer handleStatus,
                                   @RequestParam(required = false) String bizOrgCode,
                                   @RequestParam(required = false) String systemCode,
                                   @RequestParam(required = false) String systemType,
                                   @RequestParam(required = false) String createDate,
                                   @RequestParam(required = false) String startDate,
                                   @RequestParam(required = false) String endDate
    ) {
        Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
                if (bizOrgCode == null) {
                    return CommonResponseUtil.success(page);
                }
            }
        }
        return CommonResponseUtil.success(iEmergencyService.alarmList(page, bizOrgCode, systemCode, systemType, types, emergencyLevels,
                name, cleanStatus, handleStatus, createDate, startDate, endDate, "", ""));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "报警趋势统计")
    @GetMapping("/statistic/trend")
    public ResponseModel getSystemAlarmTrend(@RequestParam(value = "systemCode", required = false)String systemCode,
                                             @RequestParam(value = "updateTime", required = false)String updateTime,
                                             @RequestParam(value = "bizOrgCode", required = false) String bizOrgCode,
                                             @RequestParam(value = "startDate", required = false) String startDate,
                                             @RequestParam(value = "endDate", required = false) String endDate
    ) {
        return CommonResponseUtil.success(iFireFightingSystemService.getCenterSystemAlarmTrend(systemCode, updateTime, bizOrgCode, startDate, endDate));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "系统告警事件数量占比")
    @GetMapping("/num")
    public ResponseModel getSystemAlarmNum(
            @RequestParam(value = "bizOrgCode", required = false)String bizOrgCode,
            @RequestParam(value = "startDate", required = false) String startDate,
            @RequestParam(value = "endDate", required = false) String endDate
    ) {
        return CommonResponseUtil.success(iFireFightingSystemService.getSystemAlarmNum(bizOrgCode, startDate, endDate));
    }
}
