package com.yeejoin.amos.patrol.business.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.yeejoin.amos.boot.biz.common.constants.RuleConstant;
import com.yeejoin.amos.boot.biz.common.interceptors.PermissionInterceptorContext;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.patrol.business.constants.XJConstant;
import com.yeejoin.amos.patrol.business.dao.mapper.PlanMapper;
import com.yeejoin.amos.patrol.business.dao.mapper.PlanTaskDetailMapper;
import com.yeejoin.amos.patrol.business.dao.mapper.PlanTaskMapper;
import com.yeejoin.amos.patrol.business.dao.repository.*;
import com.yeejoin.amos.patrol.business.dto.MsgRo;
import com.yeejoin.amos.patrol.business.entity.mybatis.CheckChkExListBo;
import com.yeejoin.amos.patrol.business.entity.mybatis.PointCheckDetailBo;
import com.yeejoin.amos.patrol.business.feign.Business;
import com.yeejoin.amos.patrol.business.feign.EquipFeign;
import com.yeejoin.amos.patrol.business.feign.IdxFeign;
import com.yeejoin.amos.patrol.business.feign.JcsFeignClient;
import com.yeejoin.amos.patrol.business.param.CheckPtListPageParam;
import com.yeejoin.amos.patrol.business.param.PlanTaskPageParam;
import com.yeejoin.amos.patrol.business.service.intfc.ICheckService;
import com.yeejoin.amos.patrol.business.service.intfc.IPatrolDataSyncService;
import com.yeejoin.amos.patrol.business.service.intfc.IPlanTaskService;
import com.yeejoin.amos.patrol.business.util.MyByteArrayMultipartFile;
import com.yeejoin.amos.patrol.business.util.PlanTaskUtil;
import com.yeejoin.amos.patrol.business.util.Toke;
import com.yeejoin.amos.patrol.business.util.WordTemplateUtils;
import com.yeejoin.amos.patrol.business.vo.*;
import com.yeejoin.amos.patrol.common.enums.NotifyBusinessTypeEum;
import com.yeejoin.amos.patrol.core.common.request.CommonPageable;
import com.yeejoin.amos.patrol.core.common.response.AppCheckInputRespone;
import com.yeejoin.amos.patrol.core.common.response.AppPointCheckRespone;
import com.yeejoin.amos.patrol.core.enums.DefectLevelEnum;
import com.yeejoin.amos.patrol.core.enums.WordTemplateEnum;
import com.yeejoin.amos.patrol.core.util.DateUtil;
import com.yeejoin.amos.patrol.core.util.StringUtil;
import com.yeejoin.amos.patrol.dao.entity.Check;
import com.yeejoin.amos.patrol.dao.entity.Plan;
import com.yeejoin.amos.patrol.dao.entity.PlanTask;
import com.yeejoin.amos.patrol.dao.entity.PlanTaskDetail;
import com.yeejoin.amos.patrol.exception.YeeException;
import com.yeejoin.amos.patrol.feign.RemoteSecurityService;
import com.yeejoin.amos.patrol.quartz.IJobService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.compress.utils.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("planTaskService")
public class PlanTaskServiceImpl implements IPlanTaskService {
    private final Logger log = LoggerFactory.getLogger(PlanTaskServiceImpl.class);
    @Autowired
    PlanTaskMapper planTaskMapper;
    @Autowired
    PlanTaskDetailMapper planTaskDetailMapper;
    @Autowired
    PlanMapper planMapper;
    @Autowired
    IPlanTaskDao iplanTaskDao;
    @Autowired
    IPlanDao iplanDao;
    @Autowired
    private ICheckDao checkDao;
    @Autowired
    private RemoteSecurityService remoteSecurityService;
    @Autowired
    private IPlanTaskDetailDao planTaskDetail;
    @Autowired
    IRoutePointDao iRoutePointDao;

    @Autowired
    IJobService jobService;

    @Autowired
    private ICheckService checkService;

    @Autowired
    private Business business;

    @Autowired
    private EquipFeign equipFeign;

    @Autowired
    private RuleTrigger ruleTrigger;

    @Autowired
    RedisUtils redisUtils;

    @Autowired
    JcsFeignClient  jcsFeignClient;

    @Autowired
    private IPatrolDataSyncService patrolDataSyncService;

    @Autowired
    private IdxFeign idxFeign;

    private final String PATROL_PLAN_TASK_KEY = "PATROL_PLAN_ID:";

    private final String packageId = "消息/addCheckRule";
    private final String msgType = "patrolSystem";
    private final String APP = "APP";
    private final String WEB = "WEB";
    private final String APP_WEB = "APP/WEB";
    private static final String TAB = "\r\n";
    @Value("${auth-key-auth-enabled:}")
    private String authKey;

    @Value("${auth-key-auth-enabled:}")
    private String authKeyEnabled;


    @Override
    public Page<HashMap<String, Object>> getPlanTaskInfo(String toke, String product, String appKey, PlanTaskPageParam params) {
        long total = planTaskMapper.countPlanTask(params);
        List<HashMap<String, Object>> content = planTaskMapper.getPlanTaskInfo(params);

        String userIds = "";
        String deptIds = "";
        Set<String> set = new HashSet<>();
        Set<String> userDeptSet = new HashSet<>();
        content.forEach(s -> {
            if (s.containsKey("userName")) {
                set.add(s.get("userName").toString());
            }
            if (s.containsKey("userDept")) {
                userDeptSet.add(s.get("userDept").toString());
            }
        });

        List<String> userList = new ArrayList<>(set);
        List<String> userDeptList = new ArrayList<>(userDeptSet);

        Map<String, String> LoginName = new HashMap<>();
        Map<String, String> userMap = new HashMap<>();
        Map<String, String> depMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(userList)) {
            userIds = String.join(",", userList);
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, userIds);
            userMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
            for (AgencyUserModel agencyUserModel : userModelList) {
                LoginName.put(agencyUserModel.getUserId(), agencyUserModel.getMobile() != null ? agencyUserModel.getMobile() : agencyUserModel.getLandlinePhone());
            }
        }
        if (!CollectionUtils.isEmpty(userDeptList)) {
            StringBuilder strBuilder = new StringBuilder();
            for (String str : userDeptList) {
                if (!StringUtils.isEmpty(str)) {
                    String[] userDeptArr = str.split("@");
                    if (strBuilder.length() < 1) {
                        strBuilder.append(userDeptArr[1]);
                    } else {
                        strBuilder.append(",");
                        strBuilder.append(userDeptArr[1]);
                    }
                }
            }
//          String depts = String.join(",", userDeptList);
//          List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey,strBuilder.toString());


            //新安全
            content.forEach(s -> {
                if (s.get("userDept").toString().indexOf("@") > 0) {
                    String[] dept = s.get("userDept").toString().split(",");
                    Arrays.asList(dept).stream().forEach(x -> {
                        String[] deptTemp = x.split("@");
                        List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, deptTemp[1]);
                        if (deptL.size() > 0) {
                            s.put("userDept", deptTemp[0] + "(" + deptL.get(0).get("departmentName") + ")");
                            depMap.put(deptTemp[0], deptL.get(0).get("departmentName").toString());
                        } else {
                            s.put("userDept", deptTemp[0] + "()");
                            depMap.put(deptTemp[0], "其他");
                        }

                    });
                } else {
                    String[] deptTemp = s.get("userDept").toString().split("@");
                    List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, deptTemp[1]);
                    if (deptL.size() > 0) {
                        s.put("userDept", deptTemp[0] + "(" + deptL.get(0).get("departmentName") + ")");
                        depMap.put(deptTemp[0], deptL.get(0).get("departmentName").toString());
                    } else {
                        s.put("userDept", deptTemp[0] + "()");
                        depMap.put(deptTemp[0], "其他");
                    }

                }

//                deptL.forEach(s1 -> {
//                    String[] deptTemp = s.get("userDept").toString().split("@");
//                    if (deptTemp[1].equals(s1.get("sequenceNbr")+"")) {
//                        s.put("deptName",s1.get("departmentName")+"");
//                        s.put("userDept", deptTemp[0] + "("+ s1.get("departmentName") +")" );
//                    }
//                });

            });

        }

        Map<String, String> finalUserMap = userMap;
        Map<String, String> finalDeptMap = LoginName;

        content.forEach(c -> {
            StringBuilder userNames = new StringBuilder("");
            List<String> userIdsList = Arrays.asList(c.get("userName").toString().split(","));
//            String userDept = c.get("userDept").toString();

            for (String userId : userIdsList) {
                userNames.append(finalUserMap.get(userId) + "(" + depMap.get(userId) + ")");
                userNames.append(",");

            }
            String deptTemp = c.get("userDept").toString();
            deptTemp = deptTemp.replace(c.get("userName").toString(), "");
            c.put("userName", userNames.substring(0, userNames.lastIndexOf(",")));
            c.put("userDept", userNames.substring(0, userNames.lastIndexOf(",")) + deptTemp);
            if (c.get("userName") != null)

                if (c.get("realName") != null)
                    c.put("LoginName", finalDeptMap.get(c.get("realName")));

        });

        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, params, total);
        return result;
    }

    @Override
    public Page<HashMap<String, Object>> getPlanTaskInfoNew(PlanTaskPageParam params) {
        long total = planTaskMapper.countPlanTask(params);
        List<HashMap<String, Object>> content = planTaskMapper.getPlanTaskInfo(params);
        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, params, total);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reGenPlanTask(HashMap<String, Object> param) throws ParseException {
        //1.公共参数准备
        String planId = param.get("planId").toString();//重做的计划编号id
        String strBginDate = param.get("beginDate").toString();//开始日期（yyyy-MM-dd）
        String strEndDate = param.get("endDate").toString();//结束日期（yyyy-MM-dd）
        String flag = param.get("changeFlag").toString();//是否记为合格标记：0-否，1-是
        Plan plan = iplanDao.findById(Long.parseLong(planId)).get();//
        if (plan == null) {
            throw new YeeException("计划不存在");
        }

        if (StringUtil.isNotEmpty(plan.getUserId())) {
            //2.数据必输校验，不满足直接return，不再向下进行
            Boolean fileFlag = PlanTaskUtil.checkMustFile(plan);
            if (!fileFlag) {
                return;
            }

            //3.计算生成数据的日期区间（前10位：yyyy-MM-dd）
            CalDateVo vo = PlanTaskUtil.reGenPlanTaskData(plan, strBginDate, strEndDate);

            if (null == vo) {//计划未开始,则结束
                return;
            }


            if (!vo.getIsGenData()) {//日期不符合条件直接结束
                return;
            }

            //3.删除planTask表，按照计划id+日期
            deletePlanTaskAndDet(param);

            //5.执行数据生成（具体时间 + 人员）
            List<HashMap<String, Object>> list = genAllExeDate(plan, vo, XJConstant.REGEN_FLAG);

            //6.插入planTask及planTaskDetail
            insertPlanTaskAndDet(list, plan, flag, new Date());

            //7.重新统计计划
            if (ObjectUtils.isEmpty(plan.getUserId())) {
                return;
            }

            reformStatisticsPlanTask(strBginDate, strEndDate, plan.getUserId(), plan.getOrgCode());
            //8.通知3d数据统计进行更新（换流站全景监控）
            this.notifyBusinessRefresh(NotifyBusinessTypeEum.planTask.getCode());
        }


    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reGenPlanTaskNew(HashMap<String, Object> param) throws ParseException {
        //1.公共参数准备
        String planId = param.get("planId").toString();//重做的计划编号id
        String strBginDate = param.get("beginDate").toString();//开始日期（yyyy-MM-dd）
        String strEndDate = param.get("endDate").toString();//结束日期（yyyy-MM-dd）
        String flag = param.get("changeFlag").toString();//是否记为合格标记：0-否，1-是
        Plan plan = iplanDao.findById(Long.parseLong(planId)).get();//
        if (plan == null) {
            throw new YeeException("计划不存在");
        }

        if (StringUtil.isNotEmpty(plan.getUserId())) {
            //2.数据必输校验，不满足直接return，不再向下进行
            Boolean fileFlag = PlanTaskUtil.checkMustFile(plan);
            if (!fileFlag) {
                return;
            }

            //3.计算生成数据的日期区间（前10位：yyyy-MM-dd）
            CalDateVo vo = PlanTaskUtil.reGenPlanTaskData(plan, strBginDate, strEndDate);

            if (null == vo) {//计划未开始,则结束
                return;
            }

            if (!vo.getIsGenData()) {//日期不符合条件直接结束
                return;
            }

            //3.删除planTask表，按照计划id+日期
            deletePlanTaskAndDet(param);

            //5.执行数据生成（具体时间 + 人员）
            List<HashMap<String, Object>> list = genAllExeDate(plan, vo, XJConstant.REGEN_FLAG);

            //6.插入planTask及planTaskDetail
            insertPlanTaskAndDetNew(list, plan, flag, new Date());

            //7.重新统计计划
            if (ObjectUtils.isEmpty(plan.getUserId())) {
                return;
            }

            reformStatisticsPlanTask(strBginDate, strEndDate, plan.getUserId(), plan.getBizOrgCode());
            //8.通知3d数据统计进行更新（换流站全景监控）
//            this.notifyBusinessRefresh(NotifyBusinessTypeEum.planTask.getCode());
        }


    }




    private void notifyBusinessRefresh(String type) {
        try {
            business.planTaskInsertToB(type);
        } catch (Exception e) {
            log.error("通知业务进行数据刷新失败->" + type);
        }
    }


    public void reformStatisticsPlanTask(String strBginDate, String strEndDate, String userId, String orgCode) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        Date startTime = sdf.parse(strBginDate);
        Date endTime = sdf.parse(strEndDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        Date currentDate = new Date();
        String strCurrentDate = sdf.format(currentDate);
        long abortTime = endTime.getTime();
        if (endTime.getTime() >= sdf.parse(strCurrentDate).getTime()) {
            abortTime = sdf.parse(strCurrentDate).getTime();
        }
        String[] ids = userId.split(",");
//        StringBuffer orgCodeBuffer = new StringBuffer();
//        Map<String,String> deptMap =new HashMap<>();
//        Set<Object> userIds =new HashSet<>();
//        for (int i = 0; i <ids.length ; i++) {
//            userIds.add(ids[i].toString());
//        }
//        Map<String,AgencyUserModel> agencyUserModelMap = remoteSecurityService.getUsersMap(toke.getToke(),toke.getProduct(),toke.getAppKey(),userIds);
//        List<Map<String, String>> idOrgCodeList = new ArrayList<>();
//        for(Map.Entry<String, AgencyUserModel> entry : agencyUserModelMap.entrySet()){
//            String id = entry.getKey();
//            AgencyUserModel agencyUserModels = entry.getValue();
//            StringBuffer agencyUserOrgcode = new StringBuffer();
//            if(agencyUserModelMap.size() > 0){
//                agencyUserModels.getCompanys().forEach(companyModel -> {
//                    agencyUserOrgcode.append(companyModel.getOrgCode()).append(",");
//                });
//            }
//            Map<String,String> map = new HashMap<>();
//            map.put(id,agencyUserOrgcode.toString().substring(0,agencyUserOrgcode.length()-1));
//        }
//
//        Map<String, String> userIdOrgCodeMap = new HashMap<>(ids.length);
//        if (!CollectionUtils.isEmpty(idOrgCodeList)) {
//            userIdOrgCodeMap = idOrgCodeList.stream().collect(Collectors.toMap(x-> String.valueOf(x.get(
//                    "id")),    x->x.get("org_code")));
//        }
        while (cal.getTime().getTime() <= abortTime) {
            String refDate = sdf.format(cal.getTime());
            for (String id : ids) {
                if (!ObjectUtils.isEmpty(id)) {
                    planTaskMapper.reformStatistics(id, refDate, orgCode);
//                    planTaskMapper.reformStatistics(id, refDate, userIdOrgCodeMap.get(id));

                }
            }
            cal.add(Calendar.DATE, 1);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void planTaskDet(String[] strArry) {
        if (strArry.length <= 0) {
            throw new YeeException("删除数据内容不能为空");
        }
        Set<Long> taskNos = new HashSet<>();
        for (String id : strArry) {
            PlanTaskDetail planTkDet = planTaskDetail.findById(Long.parseLong(id)).get();
            if (null != planTkDet) {
                taskNos.add(planTkDet.getTaskNo());
            }
        }
        planTaskMapper.planTaskDet(strArry);// 删除数据
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("IDS", new ArrayList<>(taskNos));
        param.put("FINISH_YES", XJConstant.PLAN_TASK_DET_FINISH_YES);
        planTaskMapper.updatePlanTaskPtInfo(param);// 更新主表，点数量，完成数量
    }

    @Override
    public List<PlanTaskVo> planTaskReport(String toke, String product, String appKey, PlanTaskPageParam param) {
        List<PlanTaskVo> content = planTaskMapper.getPlanTaskInfoList(param);

        String userIds = "";
        String deptIds = "";
        Set<String> set = new HashSet<>();
        Set<String> deptIdSet = new HashSet<>();
        content.forEach(s -> {
            if (s.getUserName() != null) {
                set.add(s.getUserName());
            }
            if (s.getDeptId() > 0) {
                deptIdSet.add(s.getDeptId() + "");
            }
        });

        List<String> userList = new ArrayList<>(set);
        List<String> deptList = new ArrayList<>(deptIdSet);

        Map<String, String> LoginName = new HashMap<>();
        Map<String, String> userMap = new HashMap<>();
        Map<String, String> depMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(userList)) {
            userIds = String.join(",", userList);
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, userIds);
            userMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
            for (AgencyUserModel agencyUserModel : userModelList) {
                LoginName.put(agencyUserModel.getUserId(), agencyUserModel.getMobile() != null ? agencyUserModel.getMobile() : agencyUserModel.getLandlinePhone());
            }
        }
//        if(!CollectionUtils.isEmpty(deptList)){
//        String	dept = String.join(",", deptList);
//            List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey,dept);
//            if(deptL!=null&&deptL.size()>0){
//            	  //新安全
//            	content.forEach(s -> {
//            		deptL.forEach(s1 -> {
//                        if ((s.getDeptId()+"").equals(s1.get("sequenceNbr")+"")) {
//                            s.setDeptName(s1.get("departmentName")+"");
//                        }
//                    });
//
//                });
//            }
//        }
        //新安全
        content.forEach(s -> {
            StringBuffer buffer = new StringBuffer();
            if (s.getUserDept().indexOf("@") > 0) {
                String[] dept = s.getUserDept().split(",");
                Arrays.asList(dept).stream().forEach(x -> {
                    String[] deptTemp = x.split("@");
                    List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, deptTemp[1]);
                    if (deptL.size() > 0) {
                        buffer.append(deptL.get(0).get("departmentName")).append(",");
                    } else {
                        buffer.append("其他").append(",");
                    }

                });
            } else {
                String[] deptTemp = s.getUserDept().split(",");
                List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, deptTemp[1]);
                if (deptL.size() > 0) {
                    buffer.append(deptL.get(0).get("departmentName")).append(",");
                } else {
                    buffer.append("其他").append(",");
                }

            }
            s.setDeptName(buffer.substring(0, buffer.length() - 1));
        });
        Map<String, String> finalUserMap = userMap;
        content.forEach(c -> {
            StringBuilder userNames = new StringBuilder("");
            List<String> userIdsList = Arrays.asList(c.getUserName().split(","));
            for (String userId : userIdsList) {
                userNames.append(finalUserMap.get(userId));
                userNames.append(",");
            }
            c.setUserName(userNames.toString());
        });


        return content;
    }

    @Override
    public List<PlanTaskVo> planTaskReportNew(PlanTaskPageParam params) {
        List<PlanTaskVo> content = planTaskMapper.getPlanTaskInfoList(params);
        return content;
    }

    /**
     * 自动任务执行
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void taskExecution(String runDate) {
        //1.扫描plan表查询，需要生成执行数据的任务信息，无则return
        Date now = new Date();//今天
        if (runDate != null) {//上送则已上送的为准
            now = DateUtil.str2Date(runDate, "yyyyMMdd");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = df.format(now);
        String tomorrow = DateUtil.getIntervalDateStr(now, 1, "yyyy-MM-dd");//下一天
        List<Plan> planList = iplanDao.queryScheduledPlan(strDate, XJConstant.PLAN_STATUS_START);
        if (planList == null || planList.size() <= 0) {
            log.info(strDate + " " + " 暂无待生成执行数据的计划");
            return;
        }
        //2.循环遍历执行
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (Plan plan : planList) {
            if (StringUtils.isEmpty(plan.getUserId()))
                continue;
            paramMap.clear();
            paramMap.put("id", plan.getId());
            //2.1计划数据合法性校验
            Boolean fileFlag = PlanTaskUtil.checkMustFile(plan);
            if (!fileFlag) {
                paramMap.put("next_gen_date", tomorrow);
                planMapper.updPlanStatusOrGenDate(paramMap);//更新为明天
                continue;
            }
            //2.2.计算生成数据的日期区间
            CalDateVo vo = PlanTaskUtil.reGenPlanTaskData(plan, tomorrow, tomorrow);

            //计划未开始，则更新生成时间为明天
            if (null == vo) {
                paramMap.put("next_gen_date", tomorrow);
                planMapper.updPlanStatusOrGenDate(paramMap);//更新为明天
                continue;
            }
            //计划已过期,则更新status = 1,停用
            if (!vo.getIsGenData()) {
                paramMap.put("status", XJConstant.PLAN_STATUS_STOP);
                planMapper.updPlanStatusOrGenDate(paramMap);
                continue;
            }

            //2.3.执行数据生成（具体时间 + 人员）
            List<HashMap<String, Object>> list = genAllExeDate(plan, vo, XJConstant.SCHED_FLAG);

            if (XJConstant.UPD_PLAN_GEN_DATE.equals(vo.getUpdFlag())) {
                paramMap.put("next_gen_date", tomorrow);
                planMapper.updPlanStatusOrGenDate(paramMap);//更新为明天
                continue;
            } else if (XJConstant.UPD_PLAN_STATUS.equals(vo.getUpdFlag())) {
                paramMap.put("status", XJConstant.PLAN_STATUS_STOP);
                planMapper.updPlanStatusOrGenDate(paramMap);//更新status = 1,停用
                continue;
            }

            //2.4.删除今天可能重做生成的数据（计划重做后进行了计划的编辑）
            if (iplanTaskDao.findById(plan.getPlanTaskId()) != null && plan.getFirstFlag() == XJConstant.PLAN_FIRST_STATUS_YES)
                if (iplanTaskDao.existsById(plan.getPlanTaskId())) {
                    iplanTaskDao.deleteById(plan.getPlanTaskId());
                }

            //2.5.插入planTask及planTaskDetail
            insertPlanTaskAndDetNew(list, plan, XJConstant.SCHED_FLAG, now);

        }
    }

    /**
     * 删除plantask及det
     *
     * @param param
     */
    public void deletePlanTaskAndDet(HashMap<String, Object> param) {
        param.put("beginDate", param.get("beginDate") + " " + "00:00:00");
        param.put("endDate", param.get("endDate") + " " + "23:59:59");
        List<Long> ids = planTaskMapper.getGenPlanTask(param);
        for (long id : ids) {
            iplanTaskDao.deleteById(id);
            ;
        }

    }

    /**
     * 执行数据生成
     *
     * @param plan
     * @param vo
     * @return
     */
    public List<HashMap<String, Object>> genAllExeDate(Plan plan, CalDateVo vo, String flag) {
        //1.生成前8位日期（yyyy-MM-dd）
        List<HashMap<String, Date>> list = PlanTaskUtil.genExeDate(plan, vo, flag);
        if (list == null || list.size() <= 0) {
            vo.setUpdFlag(XJConstant.UPD_PLAN_GEN_DATE);
            return null;
        }
        //2.生成完整时间（yyyy-MM-dd HH:mm:ss）
        List<HashMap<String, Object>> timeList = PlanTaskUtil.genWholeExeDate(list, plan);
        if (timeList == null || timeList.size() <= 0) {
            vo.setUpdFlag(XJConstant.UPD_PLAN_STATUS);
        }
        //3.生成含有人员信息的日期执行数据
        List<HashMap<String, Object>> dataList = PlanTaskUtil.genWholeExeData(timeList, plan);
        return dataList;
    }



    /**
     * plantask及det入库
     *
     * @param list
     * @param plan
     * @param flag 是否初始状态0-初始 1-非初始
     */
    public void insertPlanTaskAndDetNew(List<HashMap<String, Object>> list, Plan plan, String flag, Date now) {
        if (list == null || list.size() <= 0) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("id", plan.getId());
            paramMap.put("next_gen_date", DateUtil.formatDatrToStr(now, "yyyy-MM-dd"));
            planMapper.updPlanStatusOrGenDate(paramMap);// 更新下次任务生成日期
        }
//        Toke toke = remoteSecurityService.getServerToken();
        Map<String, String> deptMap = new HashMap<>();
        Map<String, Object> nameMap = new HashMap<>();
        try {
            String isFixDate = plan.getIsFixedDate();// 是否固定日期
            List<Long> pointIdList = iRoutePointDao.queryRoutePointIds(plan.getRouteId());
            int pointNum = iRoutePointDao.countRoutePoint(plan.getRouteId());
            long batchNo = now.getTime();

//            List<AgencyUserModel> agencyUserModels = remoteSecurityService.listUserByUserIds(toke.getToke(), toke.getProduct(), toke.getAppKey(),
//                    plan.getUserId());

            FeignClientResult<List<Map<String, Object>>> agencyUserModelsDate=   jcsFeignClient.selectByAmosOrgIdDeptList(plan.getUserId());
            List<Map<String, Object>> agencyUserModels = agencyUserModelsDate.getResult();


            for (int i = 0; i < agencyUserModels.size(); i++) {
                //遍历获取orgcode
                nameMap.put(agencyUserModels.get(i).get("amosOrgId").toString(), agencyUserModels.get(i).get("bizOrgName"));
            }
            Set<String> departmentIds = new HashSet<>();
            List<String> depts = Arrays.asList(plan.getUserDept().split(","));
            depts.stream().forEach(dept -> {
                deptMap.put(dept.substring(0, dept.indexOf("@")), dept.substring(dept.indexOf("@") + 1));
            });
            for (String entry : deptMap.keySet()) {
                String entryValue = deptMap.get(entry);
                departmentIds.add(entryValue);
            }

            StringBuffer departmentIdBuffer = new StringBuffer();
            Iterator<String> it = departmentIds.iterator();
            while (it.hasNext()) {
                departmentIdBuffer.append(it.next()).append(",");
            }
          Map<String, String> orgCodeMap = new HashMap<>();

            if (departmentIds.size() > 0) {

//                List<DepartmentModel> departmentModels = remoteSecurityService.getlistDepartmentByDeptIds(
//                        toke.getToke(), toke.getProduct(), toke.getAppKey(),
//                        departmentIdBuffer.toString().substring(0, departmentIdBuffer.toString().length() - 1));
                              FeignClientResult<List<Map<String, Object>>> departmentModeldate=   jcsFeignClient.selectByIdDeptList(departmentIdBuffer.toString().substring(0, departmentIdBuffer.toString().length() - 1));
                List<Map<String, Object>> departmentModels = departmentModeldate.getResult();

                for (String key : deptMap.keySet()) {
                    String entryValue = deptMap.get(key);

                    for (Map<String, Object> departmentModel : departmentModels) {
                        if (entryValue.equals(departmentModel.get("sequenceNbr").toString())) {
                            orgCodeMap.put(key, departmentModel.get("bizOrgCode").toString());
                        }
                    }
                }
            }

            List<PlanTask> planTaskList = new ArrayList<>();
            List<PlanTaskDetail> planTaskDetailListSync = new ArrayList<>();

            if(list!=null){
            for (int i = 0; i < list.size(); i++) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String startTime = list.get(i).get("BEGIN_TIME").toString();
                String endTime = list.get(i).get("END_TIME").toString();
                String userId = list.get(i).get("USER_ID") == null ? "-1" : list.get(i).get("USER_ID").toString();
                String userDept = list.get(i).get("USER_DEPT") == null ? "-1" : list.get(i).get("USER_DEPT").toString();
                PlanTask planTask = iplanTaskDao.findByUserIdAndBeginTimeAndEndTimeAndPlanIdAndRouteId(userId, startTime, endTime, plan.getId(), plan.getRouteId());
                if (planTask != null) {
                    continue;
                }
                planTask = new PlanTask();

                //修改巡检p_plan_task orgcode为执行人的org_code  -- add by wujunkai 20201216
                if (plan.getUserDept().indexOf(",") > 0 && plan.getIsSingleExecution() != true) {

                    Set<String> orgCodes = new HashSet<>();
                    StringBuffer nameBuffer = new StringBuffer();
                    orgCodeMap.forEach((key, entryValue) -> {
                        orgCodes.add(entryValue);
                    });
                    for (Map.Entry<String, Object> entry : nameMap.entrySet()) {
                        String entryValue = entry.getValue().toString();
                        nameBuffer.append(entryValue).append(",");
                    }
                    planTask.setOrgCode(orgCodes.toString().substring(1, orgCodes.toString().length() - 1));
                    planTask.setUserName(nameBuffer.toString().substring(0, nameBuffer.toString().length() - 1));

                } else {
                    planTask.setOrgCode(orgCodeMap.get(userId));
                    planTask.setUserName(nameMap.get(userId).toString());
                }

                planTask.setPlanId(plan.getId());
                planTask.setBatchNo(batchNo);
                planTask.setRouteId(plan.getRouteId());
                planTask.setInOrder(plan.getInOrder());
                planTask.setUserId(userId);
                planTask.setUserDept(userDept);
                planTask.setPointNum(pointNum);
                if (XJConstant.FIX_DATE_NO.equals(isFixDate)) {
                    if (sdf.parse(startTime).getTime() <= now.getTime() && sdf.parse(endTime).getTime() >= now.getTime()) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_DEAL);
                        planTask.setFinishNum(0);
                    } else {
                        if (sdf.parse(endTime).getTime() < now.getTime()) {
                            planTask.setFinishStatus(XJConstant.TASK_STATUS_TIMEOUT);
                            planTask.setFinishNum(0);
                        }
                    }
                } else {
                    if (sdf.parse(startTime).getTime() <= now.getTime() && sdf.parse(endTime).getTime() >= now.getTime()) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_DEAL);
                        planTask.setFinishNum(0);
                    }
                    if (sdf.parse(endTime).getTime() < now.getTime()) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_TIMEOUT);
                        planTask.setFinishNum(0);
                    }
                }
                if (XJConstant.CHECK_CHANGE_YES.equals(flag)) {
                    planTask.setFinishStatus(XJConstant.TASK_STATUS_FINISH);
                    planTask.setFinishNum(pointNum);
                }
                if (XJConstant.FIX_DATE_YES.equals(isFixDate) || (XJConstant.FIX_DATE_NO.equals(isFixDate)
                        && XJConstant.PLAN_TYPE_DAY.equals(plan.getPlanType()))) {
                    planTask.setCheckDate(list.get(i).get("BEGIN_TIME").toString().substring(0, 10));
                }
                planTask.setBeginTime(startTime);
                planTask.setEndTime(endTime);
                planTask.setPlanName(plan.getName());
                // 1.保存执行数据主表
                iplanTaskDao.saveAndFlush(planTask);
                // 发送APP待办消息       (20220617  改为定时任务发送消息)
//                sendMessage(plan, planTask);
                String executorId = planTask.getUserId();
                long planId = planTask.getId();
                for (int i1 = 0; i1 < pointIdList.size(); i1++) {
                    Number pointId = pointIdList.get(i1);
                    PlanTaskDetail planTaskDetailInstance = new PlanTaskDetail();
                    planTaskDetailInstance.setPointId(pointId.longValue());
                    planTaskDetailInstance.setTaskNo(planId);
                    planTaskDetailInstance.setStatus("0");
                    if (XJConstant.TASK_STATUS_TIMEOUT == planTask.getFinishStatus()) {
                        planTaskDetailInstance.setIsFinish(Integer.parseInt(XJConstant.PLAN_TASK_DET_FINISH_OUT));
                        planTaskDetailInstance.setStatus("3");
                    }
                    if (XJConstant.CHECK_CHANGE_YES.equals(flag)) {
                        planTaskDetailInstance.setIsFinish(Integer.parseInt(XJConstant.PLAN_TASK_DET_FINISH_YES));
                        planTaskDetailInstance.setStatus("1");
                    }
                    // 2.保存执行数据明细表
                    planTaskDetail.saveAndFlush(planTaskDetailInstance);
                    planTaskDetailListSync.add(planTaskDetailInstance);
                }
                // 定时任务监控
                jobService.planTaskAddJob(planTask);
                planTaskList.add(planTask);
            }

            // 3.如果为自动任务调用,则更新id，如果重做或且下次时间大于等于明天，则更新planTaskId到plan表
            Date genDate = DateUtil.str2Date(list.get(list.size() - 1).get("NEXT_GEN_DATE").toString(), "yyyy-MM-dd");//下次生成日期
            Date tomorrow = DateUtil.getIntervalDate(now, 1);//明天
            String strGenDate = list.get(list.size() - 1).get("NEXT_GEN_DATE").toString().substring(0, 10);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("id", plan.getId());
            paramMap.put("next_gen_date", strGenDate);
            if (XJConstant.SCHED_FLAG.equals(flag)) {
                paramMap.put("plan_task_id", 0);//修改为初始值
                paramMap.put("first_flag", XJConstant.PLAN_FIRST_STATUS_NO);
            } else if (!XJConstant.SCHED_FLAG.equals(flag) && (genDate.getTime() - tomorrow.getTime() >= 0) && XJConstant.FIX_DATE_NO.equals(plan.getIsFixedDate())) {//更新日期及plantaskId到plan表
                long planTaskId = iplanTaskDao.findMaxIdByBatchNo(batchNo);
                paramMap.put("plan_task_id", planTaskId);// 更新新的任务id到plan
                paramMap.put("first_flag", XJConstant.PLAN_FIRST_STATUS_NO);
            }
            if (DateUtil.str2Date(strGenDate, "yyyy-MM-dd").getTime() - now.getTime() < 0 || org.apache.commons.lang.StringUtils.isBlank(strGenDate)) {
                paramMap.put("next_gen_date", DateUtil.formatDatrToStr(now, "yyyy-MM-dd"));
            }
            planMapper.updPlanStatusOrGenDate(paramMap);// 更新下次任务生成日期
            //  巡检站端与中心级数据同步
            TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
                @Override
                public void afterCommit() {
                    // 事物提交后业务逻辑
                    patrolDataSyncService.planTaskDataSync(planTaskList);
                    patrolDataSyncService.planTaskDetailDataSync(planTaskDetailListSync);
                }
            });


            }

        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new  RuntimeException(e.getMessage());

        }
    }






    /**
     * plantask及det入库
     *
     * @param list
     * @param plan
     * @param flag 是否初始状态0-初始 1-非初始
     */
    public void insertPlanTaskAndDet(List<HashMap<String, Object>> list, Plan plan, String flag, Date now) {
        if (list == null || list.size() <= 0) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("id", plan.getId());
            paramMap.put("next_gen_date", DateUtil.formatDatrToStr(now, "yyyy-MM-dd"));
            planMapper.updPlanStatusOrGenDate(paramMap);// 更新下次任务生成日期
        }
        Toke toke = remoteSecurityService.getServerToken();
        Map<String, String> deptMap = new HashMap<>();
        Map<String, Object> nameMap = new HashMap<>();
        try {
            String isFixDate = plan.getIsFixedDate();// 是否固定日期
            List<Long> pointIdList = iRoutePointDao.queryRoutePointIds(plan.getRouteId());
            int pointNum = iRoutePointDao.countRoutePoint(plan.getRouteId());
            long batchNo = now.getTime();

            List<AgencyUserModel> agencyUserModels = remoteSecurityService.listUserByUserIds(toke.getToke(), toke.getProduct(), toke.getAppKey(), plan.getUserId());
            for (int i = 0; i < agencyUserModels.size(); i++) {
                //遍历获取orgcode
                nameMap.put(agencyUserModels.get(i).getUserId(), agencyUserModels.get(i).getRealName());
            }
            Set<String> departmentIds = new HashSet<>();
            List<String> depts = Arrays.asList(plan.getUserDept().split(","));
            depts.stream().forEach(dept -> {
                deptMap.put(dept.substring(0, dept.indexOf("@")), dept.substring(dept.indexOf("@") + 1));
            });
            for (String entry : deptMap.keySet()) {
                String entryValue = deptMap.get(entry);
                departmentIds.add(entryValue);
            }

            StringBuffer departmentIdBuffer = new StringBuffer();
            Iterator<String> it = departmentIds.iterator();
            while (it.hasNext()) {
                departmentIdBuffer.append(it.next()).append(",");
            }
            Map<String, String> orgCodeMap = new HashMap<>();

            if (departmentIds.size() > 0) {
                List<DepartmentModel> departmentModels = remoteSecurityService.getlistDepartmentByDeptIds(toke.getToke(), toke.getProduct(), toke.getAppKey(), departmentIdBuffer.toString().substring(0, departmentIdBuffer.toString().length() - 1));
                for (String key : deptMap.keySet()) {
                    String entryValue = deptMap.get(key);
                    if ("-1".equals(entryValue)) {
                        orgCodeMap.put(key, plan.getOrgCode());
                        continue;
                    }
                    for (DepartmentModel departmentModel : departmentModels) {
                        if (entryValue.equals(departmentModel.getSequenceNbr().toString())) {
                            orgCodeMap.put(key, departmentModel.getOrgCode());
                        }
                    }
                }
            }

            List<PlanTask> planTaskList = new ArrayList<>();

            if(list!=null){
            for (int i = 0; i < list.size(); i++) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String startTime = list.get(i).get("BEGIN_TIME").toString();
                String endTime = list.get(i).get("END_TIME").toString();
                String userId = list.get(i).get("USER_ID") == null ? "-1" : list.get(i).get("USER_ID").toString();
                String userDept = list.get(i).get("USER_DEPT") == null ? "-1" : list.get(i).get("USER_DEPT").toString();
                PlanTask planTask = iplanTaskDao.findByUserIdAndBeginTimeAndEndTimeAndPlanIdAndRouteId(userId, startTime, endTime, plan.getId(), plan.getRouteId());
                if (planTask != null) {
                    continue;
                }
                planTask = new PlanTask();

                //修改巡检p_plan_task orgcode为执行人的org_code  -- add by wujunkai 20201216
                if (plan.getUserDept().indexOf(",") > 0 && plan.getIsSingleExecution() != true) {

                    Set<String> orgCodes = new HashSet<>();
                    StringBuffer nameBuffer = new StringBuffer();
                    orgCodeMap.forEach((key, entryValue) -> {
                        orgCodes.add(entryValue);
                    });
                    for (Map.Entry<String, Object> entry : nameMap.entrySet()) {
                        String entryValue = entry.getValue().toString();
                        nameBuffer.append(entryValue).append(",");
                    }
                    planTask.setOrgCode(orgCodes.toString().substring(1, orgCodes.toString().length() - 1));
                    planTask.setUserName(nameBuffer.toString().substring(0, nameBuffer.toString().length() - 1));

                } else {
                    planTask.setOrgCode(orgCodeMap.get(userId));
                    planTask.setUserName(nameMap.get(userId).toString());
                }

                planTask.setPlanId(plan.getId());
                planTask.setBatchNo(batchNo);
                planTask.setRouteId(plan.getRouteId());
                planTask.setInOrder(plan.getInOrder());
                planTask.setUserId(userId);
                planTask.setUserDept(userDept);
                planTask.setPointNum(pointNum);
                if (XJConstant.FIX_DATE_NO.equals(isFixDate)) {
                    if (sdf.parse(startTime).getTime() <= now.getTime() && sdf.parse(endTime).getTime() >= now.getTime()) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_DEAL);
                        planTask.setFinishNum(0);
                    } else {
                        if (sdf.parse(endTime).getTime() < now.getTime()) {
                            planTask.setFinishStatus(XJConstant.TASK_STATUS_TIMEOUT);
                            planTask.setFinishNum(0);
                        }
                    }
                } else {
                    if (sdf.parse(startTime).getTime() <= now.getTime() && sdf.parse(endTime).getTime() >= now.getTime()) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_DEAL);
                        planTask.setFinishNum(0);
                    }
                    if (sdf.parse(endTime).getTime() < now.getTime()) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_TIMEOUT);
                        planTask.setFinishNum(0);
                    }
                }
                if (XJConstant.CHECK_CHANGE_YES.equals(flag)) {
                    planTask.setFinishStatus(XJConstant.TASK_STATUS_FINISH);
                    planTask.setFinishNum(pointNum);
                }
                if (XJConstant.FIX_DATE_YES.equals(isFixDate) || (XJConstant.FIX_DATE_NO.equals(isFixDate)
                        && XJConstant.PLAN_TYPE_DAY.equals(plan.getPlanType()))) {
                    planTask.setCheckDate(list.get(i).get("BEGIN_TIME").toString().substring(0, 10));
                }
                planTask.setBeginTime(startTime);
                planTask.setEndTime(endTime);
                // 1.保存执行数据主表
                iplanTaskDao.saveAndFlush(planTask);
                // 发送APP待办消息       (20220617  改为定时任务发送消息)
//                sendMessage(plan, planTask);
                String executorId = planTask.getUserId();
                long planId = planTask.getId();
                for (int i1 = 0; i1 < pointIdList.size(); i1++) {
                    Number pointId = pointIdList.get(i1);
                    PlanTaskDetail planTaskDetailInstance = new PlanTaskDetail();
                    planTaskDetailInstance.setPointId(pointId.longValue());
                    planTaskDetailInstance.setTaskNo(planId);
                    planTaskDetailInstance.setStatus("0");
                    if (XJConstant.TASK_STATUS_TIMEOUT == planTask.getFinishStatus()) {
                        planTaskDetailInstance.setIsFinish(Integer.parseInt(XJConstant.PLAN_TASK_DET_FINISH_OUT));
                        planTaskDetailInstance.setStatus("3");
                    }
                    if (XJConstant.CHECK_CHANGE_YES.equals(flag)) {
                        planTaskDetailInstance.setIsFinish(Integer.parseInt(XJConstant.PLAN_TASK_DET_FINISH_YES));
                        planTaskDetailInstance.setStatus("1");
                    }
                    // 2.保存执行数据明细表
                    planTaskDetail.saveAndFlush(planTaskDetailInstance);
                }
                // 定时任务监控
                jobService.planTaskAddJob(planTask);
                planTaskList.add(planTask);
            }

            // 3.如果为自动任务调用,则更新id，如果重做或且下次时间大于等于明天，则更新planTaskId到plan表
            Date genDate = DateUtil.str2Date(list.get(list.size() - 1).get("NEXT_GEN_DATE").toString(), "yyyy-MM-dd");//下次生成日期
            Date tomorrow = DateUtil.getIntervalDate(now, 1);//明天
            String strGenDate = list.get(list.size() - 1).get("NEXT_GEN_DATE").toString().substring(0, 10);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("id", plan.getId());
            paramMap.put("next_gen_date", strGenDate);
            if (XJConstant.SCHED_FLAG.equals(flag)) {
                paramMap.put("plan_task_id", 0);//修改为初始值
                paramMap.put("first_flag", XJConstant.PLAN_FIRST_STATUS_NO);
            } else if (!XJConstant.SCHED_FLAG.equals(flag) && (genDate.getTime() - tomorrow.getTime() >= 0) && XJConstant.FIX_DATE_NO.equals(plan.getIsFixedDate())) {//更新日期及plantaskId到plan表
                long planTaskId = iplanTaskDao.findMaxIdByBatchNo(batchNo);
                paramMap.put("plan_task_id", planTaskId);// 更新新的任务id到plan
                paramMap.put("first_flag", XJConstant.PLAN_FIRST_STATUS_NO);
            }
            if (DateUtil.str2Date(strGenDate, "yyyy-MM-dd").getTime() - now.getTime() < 0 || org.apache.commons.lang.StringUtils.isBlank(strGenDate)) {
                paramMap.put("next_gen_date", DateUtil.formatDatrToStr(now, "yyyy-MM-dd"));
            }
            planMapper.updPlanStatusOrGenDate(paramMap);// 更新下次任务生成日期
            //  巡检站端与中心级数据同步
            TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
                @Override
                public void afterCommit() {
                    // 事物提交后业务逻辑
                    patrolDataSyncService.planTaskDataSync(planTaskList);
                }
            });
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }


    //bug 5980 待办任务消息应只触发执行中的任务，漏检的任务和未开始的任务不需要触发待办任务消息.
    @Override
    @Transactional
    public void taskMessage(String runDate) {

        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        //1.扫描plan表查询，需要生成执行数据的任务信息，无则return
        Date now = new Date();//今天
        String format = df.format(now);
        if (runDate != null) {//上送则已上送的为准
            runDate = runDate + " " + format;
            now = DateUtil.str2Date(runDate, "yyyyMMdd HH:mm:ss");
        }
        List<Plan> planIdsByDate = planTaskMapper.getPlanIdsByDate(now);
        List<PlanTask> planTaskList = planTaskMapper.getPlanTaskList(now);
        Map<Long, Plan> collect = planIdsByDate.stream().collect(Collectors.toMap(Plan::getId, t -> t));

        for (PlanTask planTask : planTaskList) {
            if (!redisUtils.hasKey(PATROL_PLAN_TASK_KEY + planTask.getId())) {
                try {
                    sendMessage(collect.get(planTask.getPlanId()), planTask);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                redisUtils.set(PATROL_PLAN_TASK_KEY + planTask.getId(), 1, (long) collect.get(planTask.getPlanId()).getDuration() * 60);
            }
        }
    }


    public void sendMessage(Plan plan, PlanTask planTask) throws Exception {
        Toke toke=  remoteSecurityService.getServerToken();
        RequestContext.setToken(toke.getToke());
        RequestContext.setProduct(toke.getProduct());
        RequestContext.setAppKey(toke.getAppKey());

        MsgRo msgRo = new MsgRo();
        // 标题
        msgRo.setName(plan.getName());
        // 内容
        String body = "";
        body += "待执行巡检任务" + TAB;
        body += "巡检任务名称：" + plan.getName() + TAB;
        body += "执行时间：" + planTask.getBeginTime() + "-" + planTask.getEndTime();
        msgRo.setContent(body);
        // 接收人
        ArrayList<String> userIdList = new ArrayList<>();
        userIdList.add(planTask.getUserId());
        msgRo.setRecivers(userIdList);
        msgRo.setMsgType(msgType);
        msgRo.setTerminal(APP_WEB);
        msgRo.setSendTime(DateTime.now().toString());
        // 关联id
        msgRo.setRelationId(String.valueOf(plan.getId()));
        // 扩展参数
        HashMap<String, String> extras = new HashMap<>();
        extras.put("type", msgType);
        extras.put("planId", String.valueOf(plan.getId()));
        extras.put("planTaskId", String.valueOf(planTask.getId()));
        msgRo.setExtras(extras);
        msgRo.setIsSendApp(true);
        msgRo.setIsSendWeb(true);
        msgRo.setCategory(RuleConstant.TASK);
//        PushMsgParam pushMsgParam = new PushMsgParam();
//        rulePlanService.sendRule(pushMsgParam);
        log.info("巡检待办任务：%s {}", JSON.toJSON(msgRo));
        //触发规则
        ruleTrigger.publish(msgRo, packageId, new String[0]);
    }

    @Override
    public List<PlanTask> getPlanTaskByRouteId(Long routeId) {
        List<PlanTask> planTaskList = planTaskMapper.getPlanTaskByRouteId(routeId);
        return planTaskList;
    }

    @Override
    public void disablePlanTask(Long[] planTaskIds) {
        // planTask表中status字段置为1
        for (long planTaskId : planTaskIds) {
            List<PlanTask> planTaskList = getPlanTaskByRouteId(planTaskId);
            for (PlanTask planTask : planTaskList) {
                planTask.setStatus((byte) 1);
                iplanTaskDao.save(planTask);
            }
        }
    }

    @Override
    public List getPlanTaskInfo(HashMap<String, Object> param) {
        return planTaskMapper.getPlanTaskByPointId(param);
    }

    @Override
    public Map findPlanTaskByTaskIdAndPointId(long plantaskId, long pointId) {
        return planTaskDetailMapper.findPlanTaskByTaskIdAndPointId(plantaskId, pointId);
    }

    @Override
    public Page<Map<String, Object>> getPlanTasks(String toke, String product, String appKey, HashMap<String, Object> params) {
        CommonPageable pageParam = new CommonPageable();
        List<Map<String, Object>> content = Lists.newArrayList();
        long total = planTaskMapper.getPlanTasksCount(params);
        if (total == 0) {
            return new PageImpl<>(content, pageParam, total);
        }
//        content = planTaskMapper.getPlanTasks(params);
        content = planTaskMapper.getPlanTaskNew(params);
        if (!CollectionUtils.isEmpty(content)) {
//            Set<String> userIds = Sets.newHashSet();
//            content.forEach(e -> {
//                String userId = e.get("userId").toString();
//                if (StringUtil.isNotEmpty(userId)) {
//                    userIds.add(userId);
//                }
//            });
//            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIds));
//            Map<String, String> userModelMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
//            List<String> userNames = new ArrayList<>();
//            content.forEach(e -> {
//                userNames.clear();
//                String[] userIds1 = e.get("userId").toString().split(",");
//                for (String userId : userIds1) {
//                    if (!ObjectUtils.isEmpty(userModelMap.get(userId))) {
//                        userNames.add(userModelMap.get(userId));
//                    }
//                }
//                if (userNames.size() > 0) {
//                    e.put("executiveName", Joiner.on(",").join(userNames));
//                } else {
//                    e.put("executiveName", " ");
//                }
//            });
            content.forEach(e -> {
                e.put("executiveName",e.get("userName") );
            });
            return new PageImpl<>(content, pageParam, total);
        }
        return new PageImpl<>(new ArrayList<>(), pageParam, 0);
    }

    @Override
    public Map queryPlanTaskById(Long planTaskId) {
        return planTaskMapper.queryPlanTaskById(planTaskId);
    }

    @Override
    public List getPlanTaskPoints(Long planTaskId) {
        return planTaskMapper.getPlanTaskPoints(planTaskId);
    }

    @Override
    public int getCurrentPlanTaskCount(String userId) {
        return planTaskMapper.getCurrentPlanTaskCount(userId);
    }

    @Override
    public List<PlanTaskVo> getPlanTaskListByIds(String toke, String product, String appKey, Long[] ids) {
        List<PlanTaskVo> content = planTaskMapper.getPlanTaskListByIds(ids);

        String userIds = "";
        String deptIds = "";
        Set<String> set = new HashSet<>();
        Set<String> deptIdSet = new HashSet<>();
        Map<Long, Set<String>> deptMap = new HashMap<>();
        content.forEach(s -> {
            String userDept = s.getUserDept();
            if (!ValidationUtil.isEmpty(userDept)) {
                String[] udStrs = userDept.split(",");
                for (String udStr : udStrs) {
                    try {
                        String[] split = udStr.split("@");
                        set.add(split[0]);
                        if (split.length > 1) {
                            if (!"-1".equals(split[1])) {
                                deptIdSet.add(split[1]);
                            }
                            if (!deptMap.containsKey(s.getId())) {
                                deptMap.put(s.getId(), new HashSet<>());
                            }
                            deptMap.get(s.getId()).add(split[1]);
                        }
                    } catch (Exception e) {
                    }
                }
            }
        });
        List<String> userList = new ArrayList<>(set);
        List<String> deptList = new ArrayList<>(deptIdSet);

        Map<String, String> LoginName = new HashMap<>();
        Map<String, String> userMap = new HashMap<>();
        Map<String, String> depMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(userList)) {
            userIds = String.join(",", userList);
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, userIds);
            userMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
            for (AgencyUserModel agencyUserModel : userModelList) {
                LoginName.put(agencyUserModel.getUserId(), agencyUserModel.getMobile() != null ? agencyUserModel.getMobile() : agencyUserModel.getLandlinePhone());
            }
        }
        if (!CollectionUtils.isEmpty(deptList)) {
            String dept = String.join(",", deptList);
            List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, dept);
            if (deptL != null && deptL.size() > 0) {
                //新安全
                content.forEach(s -> {
                    Set<String> set1 = deptMap.get(s.getId());
                    if (!ValidationUtil.isEmpty(set1)) {
                        deptL.forEach(s1 -> {
                            if (set1.contains(s1.get("sequenceNbr"))) {
                                if (!ValidationUtil.isEmpty(s.getDeptName())) {
                                    s.setDeptName(s.getDeptName() + "," + s1.get("departmentName"));
                                } else {
                                    s.setDeptName(s1.get("departmentName").toString());
                                }
                            }
                        });
                        if (set1.contains("-1")) {
                            if (!ValidationUtil.isEmpty(s.getDeptName())) {
                                s.setDeptName(s.getDeptName() + "," + "其他");
                            } else {
                                s.setDeptName("其他");
                            }
                        }
                    }
                });
            }
        }
        Map<String, String> finalUserMap = userMap;
        content.forEach(c -> {
            StringBuilder userNames = new StringBuilder("");
            List<String> userIdsList = Arrays.asList(c.getUserName().split(","));
            for (String userId : userIdsList) {
                userNames.append(finalUserMap.get(userId));
                userNames.append(",");
            }
            c.setUserName(userNames.toString());
        });
        return content;
    }

    @Override
    public List<PlanTaskVo> getPlanTaskListByIdsNew(Long[] ids) {
        List<PlanTaskVo> content = planTaskMapper.getPlanTaskListByIds(ids);

        return content;
    }

    @Override
    public Page<CheckChkExListBo> getChkExList(String toke, String product, String appKey, CheckPtListPageParam param) {
        long total = planTaskMapper.countChkExListData(param);
        List<CheckChkExListBo> content = planTaskMapper.getChkExList(param);

        //获取用户联系方式
        String userIds = "";
        Set<String> set = new HashSet<>();
        content.forEach(s -> {
            if (s.getRealName() != null) {
                String[] sArr = s.getRealName().split(",");
                set.addAll(Arrays.asList(sArr));
            }
        });
        List<String> userList = new ArrayList<>(set);
        Map<String, AgencyUserModel> agencyUserModelMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(userList)) {
            userIds = String.join(",", userList);
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, userIds);
            agencyUserModelMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, Function.identity()));
        }
        for (CheckChkExListBo bo : content) {
            ArrayList<String> names = new ArrayList<>();
            ArrayList<String> mobiles = new ArrayList<>();
            String nameStrings = String.join(",", names);

            String[] realNames = bo.getRealName().split(",");
            if (realNames.length > 1) {
                System.out.println("asd");
            }
            for (int i = 0; i < realNames.length; i++) {
                if (agencyUserModelMap.containsKey(realNames[i])) {
                    AgencyUserModel agencyUserModel = agencyUserModelMap.get(realNames[i]);
                    names.add(agencyUserModel.getRealName());
                    if (StringUtil.isNotEmpty(agencyUserModel.getMobile())) {
                        mobiles.add(agencyUserModel.getMobile());
                    }
                }

            }
            bo.setRealName(String.join(",", names));
            if (mobiles.size() > 0) {
                bo.setLoginName(String.join(",", mobiles));
            }
        }
        Page<CheckChkExListBo> result = new PageImpl<CheckChkExListBo>(content, param, total);
        return result;
    }



    @Override
    public HashMap<String, Object> getChkExListNew(String orgCode,CommonPageable commonPageable) {
        CheckPtListPageParam param =new CheckPtListPageParam();
        param.setPageNumber(commonPageable.getPageNumber());
        param.setPageSize(commonPageable.getPageSize());
        param.setOrgCode(orgCode);
        DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Date date = new Date();
        String c=dateFormat.format(date);
        param.setCheckDate(c);
        long total = planTaskMapper.countChkExListDataNew(param);
        List<CheckChkExListBo> content = planTaskMapper.getChkExListNew(param);
        Page<CheckChkExListBo> result = new PageImpl<CheckChkExListBo>(content, param, total);

        List< HashMap<String, Object>> colModel=new ArrayList<>();
        HashMap<String, Object> temph1 = new HashMap<>();
        temph1.put("fid","name");
        temph1.put("dataIndex","name");
        temph1.put("name","巡检计划名称");
        temph1.put("title","巡检计划名称");
        temph1.put("type","name");
        temph1.put("key","name");
        HashMap<String, Object> temph2 = new HashMap<>();
        temph2.put("fid","lastTime");
        temph2.put("dataIndex","lastTime");
        temph2.put("name","开始时间");
        temph2.put("title","开始时间");
        temph2.put("type","lastTime");
        temph2.put("key","lastTime");
        HashMap<String, Object> temph3 = new HashMap<>();
        temph3.put("fid","endTime");
        temph3.put("dataIndex","endTime");
        temph3.put("name","结束时间");
        temph3.put("title","结束时间");
        temph3.put("type","endTime");
        temph3.put("key","endTime");
        HashMap<String, Object> temph4 = new HashMap<>();
        temph4.put("fid","finishStatus");
        temph4.put("dataIndex","finishStatus");
        temph4.put("name","完成情况");
        temph4.put("title","完成情况");
        temph4.put("type","finishStatus");
        temph4.put("key","finishStatus");
        HashMap<String, Object> temph5 = new HashMap<>();
        temph5.put("fid","realName");
        temph5.put("dataIndex","realName");
        temph5.put("name","巡检人员");
        temph5.put("title","巡检人员");
        temph5.put("type","realName");
        temph5.put("key","realName");
        colModel.add(temph1);
        colModel.add(temph2);
        colModel.add(temph3);
        colModel.add(temph4);
        colModel.add(temph5);
        HashMap<String, Object> dataGridMock = new HashMap<>();
        dataGridMock.put("current",result.getNumber()+1);
        dataGridMock.put("total",result.getTotalElements());
        dataGridMock.put("pagination",true);
        dataGridMock.put("totalPage",result.getTotalPages());
        dataGridMock.put("dataList",result.getContent());
        dataGridMock.put("pageSize",result.getSize());

        HashMap<String, Object> DATE = new HashMap<>();
        DATE.put("dataGridMock",dataGridMock);
        DATE.put("colModel",colModel);
        return DATE;
    }



    @Override
    public Map<String, Object> getPlanTaskStatisticsForApp(HashMap<String, Object> params) {
        return planTaskMapper.getPlanTaskStatisticsForApp(params);
    }

    @Override
    public AppPointCheckRespone queryPointPlanTaskDetail(String toke, String product, String appKey, Long planTaskId, Long pointId) {
        AppPointCheckRespone pointCheckRespone = new AppPointCheckRespone();
        Check check = checkDao.findByPlanTaskIdAndPointId(planTaskId, pointId);
        if (check != null) {
            pointCheckRespone = checkService.queryCheckPointDetail(toke, product, appKey, check.getId());
        } else {
            // 权限处理
            PermissionInterceptorContext.setDataAuthRule(authKey);
            PointCheckDetailBo planPointInfo = planTaskMapper.getPointPlanTaskInfo(planTaskId, pointId);


            if (planPointInfo != null) {
                List<String> userIds = Arrays.asList(planPointInfo.getUsername().split(","));
                List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, planPointInfo.getUsername());
                Map<String, String> userModelMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
                if (userModelMap != null) {
                    List<String> userNameList = new ArrayList<>();
                    for (String userId : userIds) {
                        userNameList.add(userModelMap.get(userId));
                    }
                    userNameList.remove("");
                    userNameList.remove(null);
                    pointCheckRespone.setUsername(Joiner.on(",").join(userNameList));
                }
                DepartmentModel departmentBo = remoteSecurityService.getDepartmentByDeptId(toke, product, appKey, planPointInfo.getUsername());
                if (departmentBo != null) {
                    pointCheckRespone.setDepartmentName(departmentBo.getDepartmentName());
                }
                pointCheckRespone.setPointId(pointId);
                pointCheckRespone.setPointName(planPointInfo.getPointName());
                pointCheckRespone.setPointNo(planPointInfo.getPointNo());
                pointCheckRespone.setPointStatus("0");
                pointCheckRespone.setPlanName(planPointInfo.getPlanName());
                // 权限处理
                PermissionInterceptorContext.setDataAuthRule(authKey);
                List<PointCheckDetailBo> pointInputs = planTaskMapper.getPointInputByRouteIdAndPointId(planPointInfo.getRouteId(), planPointInfo.getPointId());
                JSONObject appResponeMap = new JSONObject();
                pointInputs.forEach(action -> {
                    AppCheckInputRespone input = new AppCheckInputRespone();
                    input.setInputName(action.getInputName());
                    input.setCheckInputId(action.getCheckInputId());
                    input.setDataJson(action.getDataJson());
                    input.setIsMultiline(action.getIsMultiline());
                    input.setIsMust(action.getIsMust());
                    input.setItemType(action.getItemType());
                    input.setOrderNo(action.getOrderNo());
                    input.setPictureJson(action.getPictureJson());
                    input.setClassifyId(action.getClassifyId());
                    input.setClassifyName(action.getClassifyName());
                    String key = ObjectUtils.isEmpty(action.getClassifyName()) ? "其他" : action.getClassifyName();
                    if (appResponeMap.containsKey(key)) {
                        appResponeMap.getJSONArray(key).add(input);
                    } else {
                        List<AppCheckInputRespone> appCheckInputResponeList = new ArrayList<AppCheckInputRespone>();
                        appCheckInputResponeList.add(input);
                        appResponeMap.put(key, appCheckInputResponeList);
                    }
                });
                pointCheckRespone.setAppCheckInput(appResponeMap);
            } else {
                return null;
            }
        }

        return pointCheckRespone;
    }

    @Override
    public AppPointCheckRespone queryPointPlanTaskDetailInVersion2(String toke, String product, String appKey, Long planTaskId, Long pointId) {
        // 权限处理
        PermissionInterceptorContext.setDataAuthRule(authKeyEnabled);
        AppPointCheckRespone pointCheckRespone = new AppPointCheckRespone();
        Check check = checkDao.findByPlanTaskIdAndPointId(planTaskId, pointId);
        if (check != null) {
            pointCheckRespone = checkService.queryCheckPointDetailInVersion2(toke, product, appKey, check.getId());
        } else {
            // 权限处理
            PermissionInterceptorContext.setDataAuthRule(authKey);
            PointCheckDetailBo planPointInfo = planTaskMapper.getPointPlanTaskInfo(planTaskId, pointId);

            if (planPointInfo != null) {
                pointCheckRespone.setPointId(pointId);
                pointCheckRespone.setPointName(planPointInfo.getPointName());
                pointCheckRespone.setPointNo(planPointInfo.getPointNo());
                pointCheckRespone.setPointStatus("0");
                pointCheckRespone.setPlanName(planPointInfo.getPlanName());
                List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, planPointInfo.getUserId());
                for (AgencyUserModel userModel : userModelList) {
                    pointCheckRespone.setUsername(userModel.getRealName());
                }
//                DepartmentModel departmentModel= remoteSecurityService.getDepartmentByDeptId(toke, product, appKey,planPointInfo.getCheckDepartmentId());
                DepartmentModel departmentModel = new DepartmentModel();
                pointCheckRespone.setDepartmentName(departmentModel.getDepartmentName());
                List<PointCheckDetailBo> pointInputs = planTaskMapper.getPointInputByRouteIdAndPointId(planPointInfo.getRouteId(), planPointInfo.getPointId());

                JSONObject appResponeMap = new JSONObject();
                pointInputs.forEach(action -> {
                    AppCheckInputRespone input = new AppCheckInputRespone();
                    input.setInputName(action.getInputName());
                    input.setCheckInputId(action.getCheckInputId());
                    input.setDataJson(action.getDataJson());
                    input.setIsMultiline(action.getIsMultiline());
                    input.setIsMust(action.getIsMust());
                    input.setItemType(action.getItemType());
                    input.setOrderNo(action.getOrderNo());
                    input.setPictureJson(action.getPictureJson());
                    input.setClassifyId(action.getClassifyId());
                    input.setClassifyName(action.getClassifyName());
                    String classifyName = action.getClassifyName();
                    if (!StringUtil.isNotEmpty(classifyName)) {
                        classifyName = "其他";
                    }
                    String riskDesc = action.getRiskDesc();
                    if (!StringUtil.isNotEmpty(riskDesc)) {
                        riskDesc = XJConstant.DEFAULT_RISKDESC;
                    }
                    JSONObject classifyJson;
                    if (appResponeMap.containsKey(classifyName)) {
                        classifyJson = appResponeMap.getJSONObject(classifyName);
                    } else {
                        classifyJson = new JSONObject();
                    }
                    JSONArray riskDescArr;
                    if (classifyJson.containsKey(riskDesc)) {
                        riskDescArr = classifyJson.getJSONArray(riskDesc);
                    } else {
                        riskDescArr = new JSONArray();
                    }
                    riskDescArr.add(action);
                    classifyJson.put(riskDesc, riskDescArr);
                    appResponeMap.put(classifyName, classifyJson);
                });
                pointCheckRespone.setAppCheckInput(appResponeMap);
            } else {
                return null;
            }
        }
        return pointCheckRespone;
    }









    @Override
    public AppPointCheckRespone queryPointPlanTaskDetailInVersion2New( Long planTaskId, Long pointId) {
        AppPointCheckRespone pointCheckRespone = new AppPointCheckRespone();
        // 权限处理
        PermissionInterceptorContext.setDataAuthRule(authKey);
        Check check = checkDao.findByPlanTaskIdAndPointId(planTaskId, pointId);
        if (check != null) {
            pointCheckRespone = checkService.queryCheckPointDetailInVersion2New(check.getId());
        } else {
            PointCheckDetailBo planPointInfo = planTaskMapper.getPointPlanTaskInfo(planTaskId, pointId);

            if (planPointInfo != null) {
                pointCheckRespone.setPointId(pointId);
                pointCheckRespone.setPointName(planPointInfo.getPointName());
                pointCheckRespone.setPointNo(planPointInfo.getPointNo());
                pointCheckRespone.setPointStatus("0");
                pointCheckRespone.setPlanName(planPointInfo.getPlanName());
                List<PointCheckDetailBo> pointInputs = planTaskMapper.getPointInputByRouteIdAndPointId(planPointInfo.getRouteId(), planPointInfo.getPointId());

                JSONObject appResponeMap = new JSONObject();
                pointInputs.forEach(action -> {
                    AppCheckInputRespone input = new AppCheckInputRespone();
                    input.setInputName(action.getInputName());
                    input.setCheckInputId(action.getCheckInputId());
                    input.setDataJson(action.getDataJson());
                    input.setIsMultiline(action.getIsMultiline());
                    input.setIsMust(action.getIsMust());
                    input.setItemType(action.getItemType());
                    input.setOrderNo(action.getOrderNo());
                    input.setPictureJson(action.getPictureJson());
                    input.setClassifyId(action.getClassifyId());
                    input.setClassifyName(action.getClassifyName());
                    String classifyName = action.getClassifyName();
                    if (!StringUtil.isNotEmpty(classifyName)) {
                        classifyName = "其他";
                    }
                    String riskDesc = action.getRiskDesc();
                    if (!StringUtil.isNotEmpty(riskDesc)) {
                        riskDesc = XJConstant.DEFAULT_RISKDESC;
                    }
                    JSONObject classifyJson;
                    if (appResponeMap.containsKey(classifyName)) {
                        classifyJson = appResponeMap.getJSONObject(classifyName);
                    } else {
                        classifyJson = new JSONObject();
                    }
                    JSONArray riskDescArr;
                    if (classifyJson.containsKey(riskDesc)) {
                        riskDescArr = classifyJson.getJSONArray(riskDesc);
                    } else {
                        riskDescArr = new JSONArray();
                    }
                    riskDescArr.add(action);
                    classifyJson.put(riskDesc, riskDescArr);
                    appResponeMap.put(classifyName, classifyJson);
                });
                pointCheckRespone.setAppCheckInput(appResponeMap);
            } else {
                return null;
            }
        }
        return pointCheckRespone;
    }


    @Override
    public String getCumulativePlanCountByOrgCode(String loginOrgCode) {
        return planTaskMapper.getCumulativePlanCountByOrgCode(loginOrgCode);
    }

    @Override
    public List<LeavePlanTaskVo> queryLeavePlanTask(HashMap<String, Object> params) {
        return planTaskMapper.queryLeavePlanTask(params);
    }

    @Override
    public List<CodeOrderVo> queryCodeOrderVo(HashMap<String, Object> params) {
        return planTaskMapper.queryCodeOrderVo(params);
    }

    @Override
    public PlanTask selectPlanTaskStatus(Long id) {
        // TODO Auto-generated method stub
        if (iplanTaskDao.existsById(id)) {
            return iplanTaskDao.findById(id).get();
        }
        return null;
    }

    @Override
    public void initPlanStatusOrGenDate() {
        planMapper.initUpdatePlanStatus();
        planMapper.initUpdatePlanNextGenDate();
    }

    @Override
    public List<Map<String, Object>> queryPlanTaskTimeAxis(Long userId, Integer createDate) {
        HashMap<String, Object> params = new HashMap<>();
        params.put("userId", userId);
        String endTime = DateUtil.getShortCurrentDate();
        ;
        String beginTime = "";
        if (createDate != null && createDate == 7) {
            beginTime = DateUtil.getIntervalDateStr(new Date(), -7, "yyyy-MM-dd");
        } else if (createDate != null && createDate == 30) {
            beginTime = DateUtil.getIntervalDateStr(new Date(), -30, "yyyy-MM-dd");
        } else {
            beginTime = DateUtil.getShortCurrentDate();
        }

        params.put("beginTime", beginTime + " 00:00:00");
        params.put("endTime", endTime + " 23:59:59");
        List<Map<String, Object>> content = planTaskMapper.queryPlanTaskTimeAxis(params);
        if (!CollectionUtils.isEmpty(content)) {
            Set<String> userIds = Sets.newHashSet();
            content.forEach(e -> {

                String id = e.get("userId").toString();
                if (StringUtil.isNotEmpty(id)) {
                    userIds.add(id);
                }
            });
            Toke toke = remoteSecurityService.getServerToken();
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke.getToke(), toke.getProduct(), toke.getAppKey(), Joiner.on(",").join(userIds));
            Map<String, String> userModelMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));

            content.forEach(e -> {
                StringBuffer userNames = new StringBuffer();
                List<String> userIds1 = Arrays.asList(e.get("userId").toString().split(","));
                for (String userId1 : userIds1) {
                    userNames.append(userModelMap.get(userId1)).append(",");
                }
                e.put("userName", userNames.substring(0, userNames.length() - 1));
                e.put("beginTime", DateUtil.formatDatrToStr((Date) e.get("beginTime"), DateUtil.LONG_PATTERN));
                e.put("endTime", DateUtil.formatDatrToStr((Date) e.get("endTime"), DateUtil.LONG_PATTERN));
            });
        }
        return content;
    }

    @Override
    public List<Map<String, Object>> queryTimeAxis(Long userId, Integer createDate) {
        HashMap<String, Object> params = new HashMap<>();
        params.put("userId", userId);
        String endTime = DateUtil.getShortCurrentDate();
        ;
        String beginTime = "";
        if (createDate != null && createDate == 7) {
            beginTime = DateUtil.getIntervalDateStr(new Date(), -7, "yyyy-MM-dd");
        } else if (createDate != null && createDate == 30) {
            beginTime = DateUtil.getIntervalDateStr(new Date(), -30, "yyyy-MM-dd");
        } else {
            beginTime = DateUtil.getShortCurrentDate();
        }

        params.put("beginTime", beginTime + " 00:00:00");
        params.put("endTime", endTime + " 23:59:59");
        String structListString = equipFeign.getStructureNameAll();
        JSONObject jsonObject = JSONObject.parseObject(structListString);
        JSONArray structList = jsonObject.getJSONArray("result");
        List<Map<String, Object>> result = new ArrayList<>();

        List<Map<String, Object>> content = planTaskMapper.queryTimeAxis(params);
        if (!CollectionUtils.isEmpty(content)) {
            Set<String> userIds = Sets.newHashSet();
            content.forEach(e -> {

                String id = e.get("userId").toString();
                if (StringUtil.isNotEmpty(id)) {
                    userIds.add(id);
                }
            });
            Toke toke = remoteSecurityService.getServerToken();
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke.getToke(), toke.getProduct(), toke.getAppKey(), Joiner.on(",").join(userIds));
            Map<String, String> userModelMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));

            content.forEach(e -> {
                StringBuffer userNames = new StringBuffer();
                List<String> userIds1 = Arrays.asList(e.get("userId").toString().split(","));
                for (String userId1 : userIds1) {
                    userNames.append(userModelMap.get(userId1)).append(",");
                }
                HashMap<String, Object> map = new HashMap();
                map.put("userName", userNames.substring(0, userNames.length() - 1));
                map.put("beginTime", DateUtil.formatDatrToStr((Date) e.get("beginTime"), DateUtil.LONG_PATTERN));
                map.put("endTime", DateUtil.formatDatrToStr((Date) e.get("endTime"), DateUtil.LONG_PATTERN));
                map.put("leftName", "巡检点");
                map.put("titleName", userNames.substring(0, userNames.length() - 1) + "-" + e.get("name").toString() + "-" + e.get("STATUS").toString());
                String structName = "";
                if (!StringUtils.isEmpty(e.get("risk_source_id"))) {
                    for (int i = 0; i < structList.size(); i++) {
                        if (structList.getJSONObject(i).get("id").equals(e.get("risk_source_id"))) {
                            structName = structList.getJSONObject(i).get("name").toString();
                        }
                    }
                } else {
                    structName = "无";
                }

                if (!StringUtils.isEmpty(e.get("executorDate"))) {
                    map.put("firstPropsValue", structName + "-" + e.get("executorDate"));
                } else {
                    map.put("firstPropsValue", structName + "-无");
                }

                result.add(map);
            });
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> firePatrolStatics(String bizOrgCode) {
        return planTaskMapper.firePatrolStatics(bizOrgCode);
    }

    @Override
    public Page<HashMap<String, Object>> getPlanTaskPageList(PlanTaskPageParam param) {
        CommonPageable commonPageable = new CommonPageable(param.getPageNumber() - 1, param.getPageSize());
        if (param.getPageNumber() >= 1) {
            param.setPageNumber((param.getPageNumber() - 1)* param.getPageSize());
        }
        long total = planTaskMapper.countData(param);
        List<HashMap<String, Object>> content = planTaskMapper.planTaskPage(param);
        Page<HashMap<String, Object>> result = new PageImpl<>(content, commonPageable, total);
        return result;
    }

    @Override
    public Map<String, String> preview(String taskDetailId) {
        WordTemplateUtils instance = WordTemplateUtils.getInstance();
        Map<String, Object> map = getWordMap(taskDetailId);
        String urlString = "";
        File filepdf = null;
        try {
            filepdf = instance.getWordFileItem(map, (String) map.get("document_name"), WordTemplateEnum.firePatrolPlanTaskReport.getTemplateFile(), "pdf");
            filepdf.getAbsolutePath();
            MultipartFile multipartFile = new MyByteArrayMultipartFile("file", "file.pdf", "application/pdf", file2byte(filepdf));
            FeignClientResult<Map<String, String>> result = Systemctl.fileStorageClient.updateCommonFile(multipartFile);
            if (result != null) {
                Iterator<String> it = result.getResult().keySet().iterator();
                while (it.hasNext()) {
                    urlString = it.next();
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (filepdf != null) {
                filepdf.delete();
            }
        }
        HashMap<String, String> resultMap = new HashMap<>();
        resultMap.put("pdfUrl", urlString);
        return resultMap;
    }

    @Override
    public Map<String, Object> queryPatrolInfoList(String bizOrgCode, Date startDate, Date endDate) {
        Map<String, Object> map = new HashMap<>();
        map = planTaskMapper.queryPatrolInfoList(bizOrgCode, startDate, endDate);
        Map<String, Object> map1 = new HashMap<>();
        map1 = planTaskMapper.queryPatrolEquipInfo(bizOrgCode, startDate, endDate);
        map.put("equipment_count", map1.get("equipment_count"));
        map.put("checked_equipment_count", map1.get("checked_equipment_count"));
        map.put("unchecked_equipment_count", map1.get("unchecked_equipment_count"));
        return map;
    }


    @Override
    public void download(HttpServletRequest request, HttpServletResponse response, String taskDetailId) throws UnsupportedEncodingException {
        WordTemplateUtils instance = WordTemplateUtils.getInstance();
        Map<String, Object> map = getWordMap(taskDetailId);
        try {
            instance.exportMillCertificateWord(request, response, map, (String) map.get("document_name"), WordTemplateEnum.firePatrolPlanTaskReport.getTemplateFile());
        } catch (IOException e) {
            throw new BadRequest("下载巡查任务报表失败");
        }
    }

    private Map<String, Object> getWordMap(String taskDetailId) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotEmpty(taskDetailId)) {
            Map<String, Object> infoMap = planTaskMapper.getPlanTaskBasicInfo(taskDetailId);
            SimpleDateFormat dateStat = new SimpleDateFormat("yyyy年MM月dd日 HH:mm:ss");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            LocalDateTime beginTime = (LocalDateTime) infoMap.get("beginTime");
            LocalDateTime endTime = (LocalDateTime) infoMap.get("endTime");
            String begin = dateStat.format(Date.from(beginTime.atZone(ZoneId.systemDefault()).toInstant()));
            String end = dateStat.format(Date.from(endTime.atZone(ZoneId.systemDefault()).toInstant()));
            // 设置文档文件名
            map.put("document_name", infoMap.get("taskName") + " " + begin + "-" + end + "消防设施巡查报告");
            // 换流站名称
            map.put("station_name", infoMap.get("stationName"));
            map.put("station_check_time", begin + " - " + end);
            map.put("document_create_date", dateStat.format(new Date()));
            map.put("task_name", infoMap.get("taskName"));
            map.put("begin_time", begin);
            map.put("end_time", end);
            String timestr = DateUtils.secondsToTimeStr(Integer.parseInt( infoMap.get("difSecond").toString()));
            map.put("task_total_time",timestr);
            map.put("task_status", infoMap.get("taskStatus"));
            Map<String, Object> executeInfoMap = planTaskMapper.getPlanTaskExecuteInfo(taskDetailId);
            // 执行情况参数
            int total_count = Integer.valueOf(String.valueOf(executeInfoMap.get("should_check_equip_num")));
            int real_count = Integer.valueOf(String.valueOf(executeInfoMap.get("real_check_equip_num")));
            map.put("should_check_equip_num", total_count);
            map.put("real_check_equip_num", real_count);
            double complete_task_percent;
            if (0 == total_count) {
                complete_task_percent = 0.0;
                log.error("-----------------------------应巡查总数是 0，请检查！-----------------------------");
            } else {
                complete_task_percent = (Double.valueOf(real_count) / Double.valueOf(total_count)) * 100;
            }
            map.put("check_equip_rate", complete_task_percent);
            int qualified_count = Integer.valueOf(String.valueOf(executeInfoMap.get("qualified_equip_num")));
            map.put("qualified_equip_num", qualified_count);
            map.put("not_qualified_equip_num", executeInfoMap.get("not_qualified_equip_num"));
            double qualified_task_percent;
            if (0 == total_count) {
                qualified_task_percent = 0.0;
                log.error("-----------------------------应巡查总数是 0，请检查！-----------------------------");
            } else {
                qualified_task_percent = (Double.valueOf(qualified_count) / Double.valueOf(total_count)) * 100;
            }
            map.put("qualified_equip_rate", qualified_task_percent);
            int missed_count = Integer.valueOf(String.valueOf(executeInfoMap.get("missed_equip_num")));
            map.put("missed_check_equip_num", missed_count);
            double miss_task_percent;
            if (0 == total_count) {
                miss_task_percent = 0.0;
                log.error("-----------------------------应巡查总数是 0，请检查！-----------------------------");
            } else {
                miss_task_percent = (Double.valueOf(missed_count) / Double.valueOf(total_count)) * 100;
            }
            map.put("missed_equip_rate", miss_task_percent);
            List<String> codes = planTaskMapper.getDefinitionObjCode(taskDetailId);
            String checkId = planTaskMapper.getCheckIdByDetailId(taskDetailId);
            FeignClientResult responseModel = new FeignClientResult();
            List result = new ArrayList();
            try {
                responseModel = idxFeign.queryDefectByCodes(codes, checkId);
                result = (List) responseModel.getResult();
            } catch (Exception e) {
                e.printStackTrace();
            }
            List<DefectVo> res = new ArrayList();
            if (result != null && 0 < result.size()) {
                for(Object object : result) {
                    DefectVo vo = JSON.parseObject(JSON.toJSONString(object), DefectVo.class);
                    res.add(vo);
                }
            }
            map.put("defect_report_num", res.size());
            // 上报缺陷
            List<Map<String, Object>> defects = new ArrayList<>();
            if (!CollectionUtils.isEmpty(res)) {
                res.forEach(x -> {
                    Map defectMap = new LinkedHashMap();
                    defectMap.put("defect_num", x.getDefectNum());
                    defectMap.put("defect_level", DefectLevelEnum.getByKey(x.getDefectLevel()).getValue());
                    defectMap.put("defect_equip_name", x.getDefectEquipmentName());
                    StringBuffer sb = new StringBuffer();
                    if (!StringUtils.isEmpty(x.getDefectEquipmentIds())){
                        if (x.getDefectEquipmentIds().contains(",")){
                            String[] ids = x.getDefectEquipmentIds().split(",");
                            List<String> equipIds = Arrays.asList(ids);
                            List<String> collect = equipIds.stream().distinct().collect(Collectors.toList());
                            List<Map<String, String>> defectEquipInfoByIds = planTaskMapper.getDefectEquipInfoByIds(collect);
                            Map<String, String> equipLocationMap = defectEquipInfoByIds.stream().collect(Collectors.toMap(t -> t.get("id"), t -> t.get("equipLocation")));
                            if (CollectionUtils.isNotEmpty(equipIds)) {
                                for (String s : equipIds) {
                                    sb.append(!ObjectUtils.isEmpty(equipLocationMap) ? equipLocationMap.getOrDefault(s, "") : "").append(",");
                                }
                            }
                        }else {
                            Map<String, Object> defectEquipInfo = planTaskMapper.getDefectEquipInfo(x.getDefectEquipmentIds());
                            sb.append(ObjectUtils.isEmpty(defectEquipInfo) ? "": defectEquipInfo.getOrDefault("equipLocation", ""));
                        }
                    }
                    defectMap.put("defect_equip_position", sb == null ? "" :sb);
                    defectMap.put("defect_equip_describe", x.getDefectDescribe());
                    defectMap.put("defect_report_time", sdf.format(x.getAddTime()));
                    defectMap.put("defect_discovery_name", x.getDefectDiscover());
                    defects.add(defectMap);
                });
            }
            map.put("defect_list", defects);
            // 漏检设备
            List<Map<String, Object>> missedMaps = planTaskMapper.getCheckMissedEquipInfo(taskDetailId);
            List<Map<String, Object>> missedList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(missedMaps)) {
                for (int i = 0; i < missedMaps.size(); i++) {
                    Map defectMap = new LinkedHashMap();
                    defectMap.put("missed_equip_index", i + 1);
                    defectMap.put("missed_equip_name", missedMaps.get(i).get("equipName"));
                    defectMap.put("missed_equip_position", missedMaps.get(i).get("equipPosition"));
                    defectMap.put("missed_equip_result", missedMaps.get(i).get("result"));
                    defectMap.put("missed_equip_remark", missedMaps.get(i).get("remark"));
                    missedList.add(defectMap);
                }
            }
            map.put("missed_equip_list", missedList);
            // 合格设备
            List<Map<String, Object>> qualifiedMaps = planTaskMapper.getCheckQualifiedEquipInfo(taskDetailId);
            List<Map<String, Object>> qualifiedEquipLists = new ArrayList<>();
            if (!CollectionUtils.isEmpty(qualifiedMaps)) {
                for (int i = 0; i < qualifiedMaps.size(); i++) {
                    Map qualifiedMap = new LinkedHashMap();
                    qualifiedMap.put("qualified_equip_index", i + 1);
                    qualifiedMap.put("qualified_equip_name", qualifiedMaps.get(i).get("equipName"));
                    qualifiedMap.put("qualified_equip_position", qualifiedMaps.get(i).get("equipPosition"));
                    qualifiedMap.put("qualified_equip_check_item", qualifiedMaps.get(i).get("checkItem"));
                    qualifiedMap.put("qualified_equip_result", qualifiedMaps.get(i).get("result"));
                    LocalDateTime checkTime = (LocalDateTime) qualifiedMaps.get(i).get("checkDate");
                    String qualifiedTime = sdf.format(Date.from(checkTime.atZone(ZoneId.systemDefault()).toInstant()));
                    qualifiedMap.put("qualified_equip_check_time", qualifiedTime);
                    qualifiedMap.put("qualified_equip_check_user", qualifiedMaps.get(i).get("checkUserName"));
                    qualifiedEquipLists.add(qualifiedMap);
                }
            }
            map.put("qualified_equip_list", qualifiedEquipLists);
            // 不合格设备
            List<Map<String, Object>> notQualifiedMaps = planTaskMapper.getCheckNotQualifiedEquipInfo(taskDetailId);
            List<Map<String, Object>> notQualifiedEquipLists = new ArrayList<>();
            if (!CollectionUtils.isEmpty(notQualifiedMaps)) {
                for (int i = 0; i < notQualifiedMaps.size(); i++) {
                    Map notQualifiedMap = new LinkedHashMap();
                    notQualifiedMap.put("not_qualified_equip_index", i + 1);
                    notQualifiedMap.put("not_qualified_equip_name", notQualifiedMaps.get(i).get("equipName"));
                    notQualifiedMap.put("not_qualified_equip_position", notQualifiedMaps.get(i).get("equipPosition"));
                    notQualifiedMap.put("not_qualified_equip_check_item", notQualifiedMaps.get(i).get("checkItem"));
                    notQualifiedMap.put("not_qualified_equip_result", notQualifiedMaps.get(i).get("result"));
                    LocalDateTime notQualifiedCheckTime = (LocalDateTime) notQualifiedMaps.get(i).get("checkDate");
                    String notQualifiedTime = sdf.format(Date.from(notQualifiedCheckTime.atZone(ZoneId.systemDefault()).toInstant()));
                    notQualifiedMap.put("not_qualified_equip_check_time", notQualifiedTime);
                    notQualifiedMap.put("not_qualified_equip_check_user", notQualifiedMaps.get(i).get("checkUserName"));
                    if (0 < res.size()) {
                         for (DefectVo vo : res) {
                             if (StringUtil.isNotEmpty(vo.getDefectEquipmentCode()) && String.valueOf(notQualifiedMaps.get(i).get("objCode")).equals(vo.getDefectEquipmentCode())) {
                                 notQualifiedMap.put("not_qualified_equip_defect_num", vo.getDefectNum());
                                 break;
                             }
                         }
                    }
                    notQualifiedEquipLists.add(notQualifiedMap);
                }
            }
            map.put("not_qualified_equip_list", notQualifiedEquipLists);
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> getStatics(String companyCode, String bizOrgCode) {
        // 权限处理
        PermissionInterceptorContext.setDataAuthRule(authKeyEnabled);
        if (StringUtils.isEmpty(bizOrgCode) && StringUtil.isNotEmpty(companyCode)) {
            bizOrgCode = planTaskMapper.queryByCompanyCode(companyCode);
        }
        List<Map<String, Object>> statics = planTaskMapper.getStatics(bizOrgCode);
        int xcdw = 0;
        int hgdw = 0;
        int lcdw = 0;
        int zxcdw = 0;
        for (Map<String, Object> map  : statics
             ) {
            if(map.get("code").equals("xfxcjrljxcdw")) {
                xcdw = Integer.parseInt(map.get("value").toString());
            }
            if(map.get("code").equals("xfxchg")) {
                hgdw = Integer.parseInt(map.get("value").toString());
            }
            if(map.get("code").equals("xfxcjrlcdw")) {
                lcdw = Integer.parseInt(map.get("value").toString());
            }
            if(map.get("code").equals("xfxcjrzxcdw")) {
                zxcdw = Integer.parseInt(map.get("value").toString());
            }
        }
        if(xcdw == 0) {
            for (Map<String, Object> map  : statics
            ) {
                if(map.get("code").equals("xfxchgzb")) {
                    map.put("value","0");
                }
            }
        } else {
            for (Map<String, Object> map  : statics
            ) {
                if(map.get("code").equals("xfxchgzb")) {
                    map.put("value",String.format("%.2f", (((double)hgdw / (double)xcdw)) *100));
                }
            }
        }
        if(zxcdw == 0) {
            for (Map<String, Object> map  : statics
            ) {
                if(map.get("code").equals("xfxclcl")) {
                    map.put("value","0");
                }
            }
        } else {
            for (Map<String, Object> map  : statics
            ) {
                if(map.get("code").equals("xfxclcl")) {
                    map.put("value", String.format("%.2f", (((double)lcdw / (double)zxcdw))*100)  );
                }
            }
        }

        return statics;
    }

    @Override
    public Map<String, Number> getCenterStatics(String bizOrgCode) {
        List<Map<String, Object>> statics = planTaskMapper.getCenterStatics(bizOrgCode);
        Map<String, Number> resultMap = new HashMap<>();
        for (Map<String, Object> item : statics) {
            resultMap.put((String) item.get("code"), Long.valueOf(item.getOrDefault("value", "0").toString()));
        }
        // 今日漏查率 = 今日漏查点位(JRLCDW) / 今日应巡查点(JRYXCD)
        resultMap.put("JRLCL", getPercent(resultMap.get("JRLCDW").floatValue(), resultMap.get("JRYXCD").floatValue()));
        // 今日巡查点位合格占比 = 合格(HG) / 今日应巡查点(JRYXCD)  今日巡查点位合格占比 = 合格(HG) / 今日已巡查点(HG + BHG)
        resultMap.put("JRHGZB", getPercent(resultMap.get("HG").floatValue(), resultMap.get("HG").floatValue() + resultMap.get("BHG").floatValue()));
        return resultMap;
    }
    @Override
    public Map<String, Number> getStationStatics(String bizOrgCode) {
        List<Map<String, Object>> statics = planTaskMapper.getStationStatics(bizOrgCode);
        Map<String, Number> resultMap = new HashMap<>();
        for (Map<String, Object> item : statics) {
            resultMap.put((String) item.get("code"), Long.valueOf(item.getOrDefault("value", "0").toString()));
        }
        // 执行进度
        resultMap.put("ZXJD", getPercent(resultMap.get("JRLJXCDW").floatValue(), resultMap.get("JRYXCD").floatValue()));
        return resultMap;
    }

    /**
     *
     * @param bizOrgCode
     * @param date
     * @return
     */
    @Override
    public Map<String, Number> getPatrolActivityStats(String bizOrgCode, String date) {
        FeignClientResult<List<Map<String, Object>>> response = idxFeign.queryStationInfoOnlineList(bizOrgCode);
        if (response.getStatus() != 200) {
            throw new RuntimeException("获取idx服务异常");
        }
        List<Map<String, Object>> stations = response.getResult();
        AtomicInteger missNum = new AtomicInteger();  // 有漏检
        List<Map<String, String>> queryMaps = planTaskMapper.selectPatrolActivityStats(bizOrgCode, date);
        for (Map<String, String> queryMap : queryMaps) {
            String missStatus = queryMap.get("missStatus");
            if (Objects.equals(missStatus, "有漏检")) {
                missNum.incrementAndGet();
            }
        }
        Integer doneNum = planTaskMapper.getDoneNum(bizOrgCode, date);
        return new HashMap<String, Number>() {{
            this.put("done", doneNum);
            this.put("undone", stations.size() - doneNum);
            this.put("miss", missNum);
            this.put("noMiss", stations.size() - missNum.intValue());
        }};
    }

    @Override
    public Page<HashMap<String, Object>> getPatrolRecordPage(Integer pageNumber, Integer pageSize, String bizOrgCode, String patrolStatus, String missStatus, String date, String sorter) {
        if (StringUtils.isEmpty(date)) {
            date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        }
        FeignClientResult<List<Map<String, Object>>> response = idxFeign.queryStationInfoOnlineList(bizOrgCode);
        if (response.getStatus() != 200) {
            throw new RuntimeException("获取idx服务异常");
        }

        if (StringUtils.isEmpty(date)) {
            date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        }
        FeignClientResult<List<Map<String, String>>> jcsResponse = jcsFeignClient.getStationTypeList();
        if (jcsResponse.getStatus() != 200) {
            throw new RuntimeException("获取jcs服务异常");
        }

        List<Map<String, String>> jcsStations = jcsResponse.getResult();
        Map<String, String> stationTypeMap = new HashMap<>();
        if (CollUtil.isNotEmpty(jcsStations)) {
            stationTypeMap = jcsStations.stream().collect(Collectors.toMap(t -> t.get("bizOrgCode"), t -> t.get("stationType")));
        }
        List<Map<String, Object>> stations = response.getResult();
        List<HashMap<String, Object>> records = new ArrayList<>();

        // 未开展
        List<HashMap<String, Object>> queryMaps = planTaskMapper.selectPatrolRecordPage(bizOrgCode, date);
        Map<String, List<HashMap<String, Object>>> hasDataMapInfo = queryMaps.stream()
                .collect(Collectors.groupingBy(
                        map -> map.get("bizOrgCode").toString()
                ));
        for (Map<String, Object> station : stations) {
            if (hasDataMapInfo.containsKey(station.get("bizOrgCode").toString())) {
                List<HashMap<String, Object>> queryMapList = hasDataMapInfo.get(station.get("bizOrgCode").toString());
                for (HashMap<String, Object> queryMap : queryMapList) {
                    if (Integer.parseInt(queryMap.get("finishPointCount").toString()) > 0) {
                        queryMap.put("patrolStatus", "已开展");
                    } else {
                        queryMap.put("patrolStatus", "未开展");
                    }
                    int totalValue = Integer.parseInt(queryMap.getOrDefault("allCount", "0").toString());
                    int missPointCount = Integer.parseInt(queryMap.getOrDefault("missPointCount", "0").toString());
                    int finishPointCount = Integer.parseInt(queryMap.getOrDefault("finishPointCount", "0").toString());
                    // 获取漏检率：missPointCount / totalValue
                    queryMap.put("missPointRate", getPercent((float) missPointCount, (float) totalValue));
                    // 执行进度：finishCount / totalValue
                    queryMap.put("finishRate", getPercent((float) finishPointCount, (float) totalValue));
                    String realStartTime = queryMap.getOrDefault("realStartTime", cn.hutool.core.date.DateUtil.now()).toString();
                    String realEndTime = queryMap.getOrDefault("realEndTime", cn.hutool.core.date.DateUtil.now()).toString();
                    long minutesBetween = this.getMinutesBetween(realStartTime, realEndTime);
                    queryMap.put("totalTime", minutesBetween);
                    queryMap.put("stationType", ObjectUtil.isNotEmpty(stationTypeMap) ? stationTypeMap.getOrDefault(queryMap.get("bizOrgCode").toString(), "常规") : "常规");
                    queryMap.put("id", queryMap.get("id").toString() + "");
                    records.add(queryMap);
                }
            } else {
                HashMap<String, Object> record = new HashMap<>();
                record.put("bizOrgCode", station.get("bizOrgCode"));
                record.put("bizOrgName", station.get("bizOrgName"));
                record.put("stationType", ObjectUtil.isNotEmpty(stationTypeMap) ? stationTypeMap.getOrDefault(station.get("bizOrgCode").toString(), "常规") : "常规");
                record.put("time", date);
                record.put("beginTime", '-');
                record.put("endTime", '-');
                record.put("patrolStatus", "未开展");
                record.put("allCount", 0);
                record.put("missPointCount", 0);
                record.put("missPointRate", 0);
                record.put("finishRate", 0);
                record.put("totalTime", 0);
                record.put("finishPointCount", 0);
                records.add(record);
            }
        }

        if (StrUtil.isNotEmpty(patrolStatus)) {
            if("undone".equals(patrolStatus)) {
                records = records.stream().filter(item -> Integer.parseInt(item.get("finishPointCount").toString()) == 0).collect(Collectors.toList());
            } else {
                records = records.stream().filter(item -> Integer.parseInt(item.get("finishPointCount").toString()) > 0).collect(Collectors.toList());
            }
        }
        if (StrUtil.isNotEmpty(missStatus)) {
            if("miss".equals(missStatus)) {
                records = records.stream().filter(item -> Integer.parseInt(item.get("missPointCount").toString()) > 0).collect(Collectors.toList());
            } else {
                records = records.stream().filter(item -> Integer.parseInt(item.get("missPointCount").toString()) == 0).collect(Collectors.toList());
            }
        }

        // 排序
        if (org.springframework.util.StringUtils.hasText(sorter)) {
            String sortField = sorter.split("@")[0];
            String sortOrder = sorter.split("@")[1];
            if ("ascend".equals(sortOrder)) {
                records.sort(Comparator.comparing(o -> o.get(sortField).toString()));
            } else {
                records.sort(Comparator.comparing(o -> ((Map) o).get(sortField).toString()).reversed());
            }
        } else {
            records.sort(Comparator
                    .comparing(o -> ((Map) o).get("beginTime").toString())
                    .thenComparing(o -> ((Map) o).get("stationType").toString()).reversed());
        }
        int startIndex = (pageNumber - 1) * pageSize;
        int size = Math.min(pageSize, records.size());
        int endIndex = Math.min(startIndex + size, records.size());
        List<HashMap<String, Object>> finalRecords = records.subList(startIndex, endIndex);
        return new PageImpl<>(finalRecords, new CommonPageable(), records.size());
    }

    @Override
    public List<Map<String, Object>> queryPatrolInfo(String bizOrgCode, Date startDate, Date endDate) {
        List<Map<String, Object>> list = new ArrayList<>();
        return planTaskMapper.queryPatrolInfo(bizOrgCode, startDate, endDate);
    }

    private float getPercent(double num1, double num2) {
        if (num2 == 0) {
            return 0;
        }
        double result = (num1 / num2) * 100;

        BigDecimal decimal =  BigDecimal.valueOf(result).setScale(2, RoundingMode.HALF_UP);
        return decimal.floatValue();
    }

    public static byte[] file2byte(File file) {
        try (
                FileInputStream in = new FileInputStream(file);
                ) {

            //当文件没有结束时，每次读取一个字节显示
            byte[] data = new byte[in.available()];
            in.read(data);
            return data;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 计算两个时间间隔分钟数
     * @param startTime 开始时间 yyyy-MM-dd HH:mm:ss
     * @param endTime 结束时间 yyyy-MM-dd HH:mm:ss
     */
    public long getMinutesBetween(String startTime, String endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date startDate = sdf.parse(startTime);
            Date endDate = sdf.parse(endTime);
            long diff = endDate.getTime() - startDate.getTime();
            return TimeUnit.MILLISECONDS.toMinutes(diff);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return 0;
    }
}
