package com.yeejoin.amos.fas.dao.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the equipment database table.
 *
 */
@Entity
@Table(name="c_plan_classify_tree")
@NamedQuery(name="PlanClassifyTree.findAll", query="SELECT e FROM PlanClassifyTree e")
@Data
public class PlanClassifyTree extends BasicEntity {

	private static final long serialVersionUID = -6580123563351367727L;
	/**
	 * 预案分类名称
	 */
	@Column(name="classify_name")
	private String classifyName;

	/**
	 * 预案分类名称
	 */
	@Column(name="parent_id")
	private Long parentId;

	/**
	 * 创建人
	 */
	@Column(name="creator")
	private String creator;
	/**
	 * 组织机构
	 */
	@Column(name="org_code")
	private String orgCode;

}