package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.datasync.entity.FireFightingSystem;
import com.yeejoin.equipmanage.common.entity.FireFightingSystemEntity;
import com.yeejoin.equipmanage.common.entity.dto.EquipTypeAmountPageDTO;
import com.yeejoin.equipmanage.common.entity.vo.*;
import com.yeejoin.equipmanage.common.vo.*;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface FireFightingSystemMapper extends BaseMapper<FireFightingSystemEntity> {

    /**
     * 根据系统id查询设备列表
     *
     * @param systemId
     * @return
     */
    List<EquiplistSpecificBySystemVO> getEquiplistBySystemId(Long systemId);

    /**
     * 根据系统id查询分组设备数量
     *
     * @param systemId
     * @return
     */
    List<EquipCountBySystemVO> getEquipCountBySystemId(Long systemId);

    /**
     * 保存
     *
     * @param vo
     * @return
     */
    int save(FireFightingSystemVo vo);

    /**
     * 修改
     *
     * @param vo
     * @return
     */
    int update(FireFightingSystemVo vo);

    /**
     * 保存文件
     *
     * @param vo
     * @return
     */
    int insertFile(FileUploadVo vo);

    /**
     * 删除文件
     *
     * @param id
     * @return
     */
    int deleteFilre(String id);

    /**
     * 系统绑定画布id
     *
     * @param vo
     * @return
     */
    int setSceneId(FireFightingSystemVo vo);

    /**
     * 获取装备数据
     *
     * @return
     */
    List<PointTreeVo> getPointData(@Param("id") String id, @Param("instanceId") String instanceId);

    List<PointTreeVo> getPointDataNew(@Param("id") String id, @Param("instanceId") String instanceId, @Param("displayName") String displayName);

    List<PointTreeVo> getPointDataNum(@Param("id") String id);


    /**
     * 获取装备数据
     *
     * @return
     */
    List<PointTreeVo> get3dPointData();

    /**
     * 装备点性能指标接口
     *
     * @return
     */
    List<SpeIndexVo> getSpeIndex(Long id);

    /**
     * 按照组态格式获取系统详情
     *
     * @param id
     * @return
     */
    List<AlarmDataVO> getSystemById(Long id);

    IPage<EquipmentAlarmBySystemIdOrSourceIdVO> getEquipmentAlarmBySystemIdOrSourceIdVO(@Param("page") IPage<EquipmentAlarmBySystemIdOrSourceIdVO> page
            , @Param("sourceId") Long sourceId
            , @Param("systemId") Long systemId
            , @Param("confirmType") Integer confirmType
            , @Param("createDate") String createDate
            , @Param("type") String type
            , @Param("equipmentId")String equipmentId);

    IPage<EquipTypeImgAmountVO> getColaCategoryAmountList(@Param("page") IPage page,
                                                          @Param("hierarchy") int hierarchy,
                                                          @Param("codeHead") String codeHead,
                                                          @Param("equipTypeAmountPage") EquipTypeAmountPageDTO equipTypeAmountPage);

    IPage<EquipTypeImgAmountVO> getColaCategoryAmountListIot(@Param("page") IPage page,
                                                             @Param("hierarchy") int hierarchy,
                                                             @Param("codeHead") String codeHead,
                                                             @Param("equipTypeAmountPage") EquipTypeAmountPageDTO equipTypeAmountPage);

    IPage<EquipTypeImgAmountVO> getColaCategoryAmountCarList(@Param("page") IPage page,
                                                             @Param("hierarchy") int hierarchy,
                                                             @Param("codeHead") String codeHead,
                                                             @Param("equipTypeAmountPage") EquipTypeAmountPageDTO equipTypeAmountPage);


    IPage<EquipTypeImgAmountVO> getColaCategoryAmountEquList(@Param("page") IPage page,
                                                             @Param("hierarchy") int hierarchy,
                                                             @Param("codeHead") String codeHead,
                                                             @Param("equipTypeAmountPage") EquipTypeAmountPageDTO equipTypeAmountPage);


    List<FireFightingSystem> getFireFightingSystemDetail(@Param("fireFightingSystemVo") FireFightingSystemVo fireFightingSystemVo);

    List<FireFightingSystemEntity> getFightingSysByCodes(@Param("ids") String[] idsArr);

    List<FireFightingSystemEntity> getFightingSysByIds(@Param("ids") String[] idsArr);

    List<FireFightingSystem3dVo> get3dFightingSystemList(@Param("list") List<String> collect);

    List<SpeIndexVo> getSpeIndexIn(@Param("list") List<Long> idList);


    Map<String, Object> getFireSystemState();

    Map<String, Object> getFireOnlSystem();

    Map<String, Object> getFireOnlSystemThreeSmall();

    Map<String, Object> getFireCafsSystem();

    Map<String, Object> getFireFfsSystem();

    Map<String, Object> getFireFasSystem();

    Map<String, Object> getFireAcsSystem();

    Map<String, Object> getFireFhsSystem();

    Map<String, Object> getTodayConfirmAlarmInfo();

    Map<String, Object> getPoolInfo();

    FireFightingSystemVo getFightingSysInfo(@Param("code") String code, @Param("id") Long id);

    /**
     * 火灾报警系统3小 ，装备定义数量
     *
     * @return Map<String, Object>
     */
    Map<String, Object> fireAlarmSysEquipmentNumber();

    /**
     * 火灾报警系统3小,指标
     *
     * @return Map<String, Object>
     */
    Map<String, Object> fireAlarmSysIndexNumber();

    /**
     * 消防水系统-》12号消防水池
     *
     * @return Map<String, Object>
     */
    Map<String, Object> fireWaterSysPool();

    /**
     * 消防水系统-》消防管网
     *
     * @return Map<String, Object>
     */
    Map<String, Object> fireWaterSysPipeNetwork();


    Map<String,Object> fireWaterSysPipeStatus();


    /**
     * 消防水系统-》消火栓按钮
     *
     * @return Map<String, Object>
     */
    Map<String, Object> fireWaterSysHydrant();

    /**
     * 消防水系统-》水泵房采集装置
     *
     * @return Map<String, Object>
     */
    Map<String, Object> fireWaterSysCollectingDevice();

    /**
     * 消防水系统-》消防泵、稳压泵,大屏用
     *
     * @return Map<String, Object>
     */
    Map<String, Object> fireWaterSysWaterPump();

    /**
     * 预混泡沫灭火系统3小
     *
     * @return Map<String, Object>
     */
    Map<String, Object> fireFoamSysEquipmentIndexNumber();

    /**
     * 其他系统总数及指标数量
     *
     * @return Map<String, Object>
     */
    Map<String, Object> otherSysIndexNumAndTotal();

    /**
     * 预混泡沫灭火系统概览
     *
     * @return Map<String, Object>
     */
    Map<String, Object> fireFoamSysEquipmentNumber();

    /**
     * 根据bizorgcode获取系统分类数量
     *
     * @param bizOrgCode
     * @return
     */
    List<Map<String, Object>> listByBizOrgCode(@Param("bizOrgCode") String bizOrgCode);

    /**
     * 获取系统告警信息
     *
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> getSystemAlarmInfo(Page page, @Param("bizOrgCode") String bizOrgCode);

    /**
     * 获取设备告警待确认和未处理信息
     *
     * @param bizOrgCode
     * @return
     */
    Map<String, Object> getEquipAlarmInfoNum(@Param("systemCode") String systemCode, @Param("bizOrgCode") String bizOrgCode);

    List<Map<String, String>> getStationBizOrgCode();

    /**
     * 获取消防力量信息（队伍值班等）
     *
     * @param bizOrgCode
     * @return
     */
    Map<String, Object> getFireTeamInfoBy117(@Param("bizOrgCode") String bizOrgCode);

    /**
     * 获取消防力量信息（队伍值班等）
     *
     * @param bizOrgCode
     * @return
     */
    Map<String, Object> getFireTeamInfoBy116(@Param("bizOrgCode") String bizOrgCode);

    /**
     * 消防车辆信息
     *
     * @param bizOrgCode
     * @return
     */
    Map<String, Object> getFireCarInfo(@Param("bizOrgCode") String bizOrgCode);

    /**
     * 物联监控页面消防车辆信息
     *
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> getFireCarInfoByWL(Page page, @Param("bizOrgCode") String bizOrgCode);



    /**
     * 获取水源信息
     *
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> getWaterInfo(Page page, @Param("bizOrgCode") String bizOrgCode, @Param("systemCode") String systemCode);

    /**
     * 获取水源信息(监盘概览)
     *
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> getWaterInfoBySuper(Page page, @Param("bizOrgCode") String bizOrgCode);

    /**
     * 监盘概览泡沫罐和水箱信息（监盘概览）
     * @param page
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> getFoamTankBySuper(Page page, @Param("bizOrgCode") String bizOrgCode);

    /**
     * 监盘概览管网压力信息（监盘概览）
     * @param page
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> getPipeNetworkBySuper(Page page, @Param("bizOrgCode") String bizOrgCode);

    /**
     * 监盘概览水池装置进水流量信息（监盘概览）
     * @param page
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> getInfluentFlowBySuper(Page page, @Param("bizOrgCode") String bizOrgCode);


    /**
     * 获取系统今日告警信息
     *
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> getSystemInfo(Page page, @Param("bizOrgCode") String bizOrgCode, @Param("systemCode") String systemCode);

    /**
     * 获取系统名称及该系统工作状态
     *
     * @return
     */
    List<Map<String, Object>> getFireSystemInfo(HashMap<String, Object> hashMap);

    /**
     * 获取系统状态 大于0异常 小于0正常
     * @param hashMap
     * @return
     */
    Integer getSystemStatus(HashMap<String, Object> hashMap);

    /**
     * 获取系统近一月告警设备top5
     *
     * @param hashMap
     * @return
     */
    List<Map<String, Object>> equipAlarmTOP(HashMap<String, Object> hashMap);

    /**
     * 获取设备id
     *
     * @param hashMap
     * @return
     */
    String equipmentId(HashMap<String, Object> hashMap);

    /**
     * 获取设备id
     *
     * @param hashMap
     * @return
     */
    String equipmentIdBySuper(HashMap<String, Object> hashMap);

    /**
     * 获取系统设备状态
     *
     * @param page
     * @param id
     * @return
     */
    Page<Map<String, Object>> equipmentState(Page page, String id);

    /**
     * 获取系统设备状态
     *
     * @param page
     * @param id
     * @return
     */
    Page<Map<String, Object>> equipmentStateBySuper(Page page, String id);

    /**
     * 稳压泵信息
     *
     * @param page
     * @param bizOrgCode
     * @param systemCode
     * @return
     */
    Page<Map<String, Object>> getPressurePumpInfo(Page page, @Param("bizOrgCode") String bizOrgCode, @Param("systemCode") String systemCode);

    /**
     * 根据装备ID查指标信息
     * @param id
     * @return
     */
    Map<String, String> queryPressureNowStateBySpecificId(@Param("id") Long id);

    /**
     * 稳压泵信息-3小消防给水信息
     * @param bizOrgCode
     * @param systemCode
     * @return
     */
    List<Map<String, Object>> getPressurePumpInfo3Small(@Param("bizOrgCode") String bizOrgCode, @Param("systemCode") String systemCode);

    /**
     * 装备导出列表查询
     *
     * @param dto
     * @return
     */
    List<EquipmentExportVO> exportEquipmentList(@Param("dto") EquipTypeAmountPageDTO dto);

    /**
     * 获取系统告警信息
     * @param bizOrgCode
     * @return
     */
    List<Map<String, Object>> getSystemAlarmInfoNum(@Param("bizOrgCode") String bizOrgCode);

    /**
     * 工业水池信息
     * @param bizOrgCode
     * @return
     */
    List<Map<String, Object>> getWaterIndustryPoolInfoNum(@Param("bizOrgCode") String bizOrgCode);

    /**
     * 消防水池信息
     * @param bizOrgCode
     * @return
     */
    List<Map<String, Object>> getWaterPoolInfoNum(@Param("bizOrgCode") String bizOrgCode);

//    /**
//     * 消防水源总量统计
//     * @param companyCode
//     * @return
//     */
//    Map<String, Object> getWaterPoolVolumeInfo(@Param("companyCode") String companyCode);

    /**
     * 获取车辆总数
     * @param companyCode
     * @return
     */
    Integer getCarNum(@Param("companyCode") String companyCode);

    List<Map<String, Object>> getCarInfo(@Param("bizOrgCode") String bizOrgCode);

    List<Map<String, Object>> getEquipInfo(@Param("bizOrgCode") String bizOrgCode, @Param("alarmType") String alarmType);

    /**
     * 统计某站下装备总数、摄像头总数
     * @param bizOrgCode
     * @return
     */
    Map<String, Object> statisticsByStation(@Param("bizOrgCode") String bizOrgCode);

    /**
     * 查询某站今日告警设备信息
     * @param bizOrgCode
     * @return
     */
    Map<String, Object> todayAlarmEquipment(@Param("bizOrgCode") String bizOrgCode);
    /**
     * 查询某站今日告警信息
     * @param bizOrgCode
     * @return
     */
    Map<String, Object> todayAlarmMessage(@Param("bizOrgCode") String bizOrgCode);
    /**
     * 查询某站今日未消除设备
     * @param bizOrgCode
     * @return
     */
    Map<String, Object> todayAlarmUnEliminateEquipment(@Param("bizOrgCode") String bizOrgCode);

    /**
     * 查询某站今日未消除告警
     * @param bizOrgCode
     * @return
     */
    Map<String, Object> todayAlarmUnEliminateMessage(@Param("bizOrgCode") String bizOrgCode);
    /**
     * 查询某站近一月告警趋势
     * @param bizOrgCode
     * @return
     */
    List<Map<String, Object>> monthAlarm(@Param("bizOrgCode") String bizOrgCode);

    /**
     * 查询某站近一年告警统计
     * @param bizOrgCode
     * @return
     */
    List<Map<String, Object>> yearsAlarm(@Param("bizOrgCode") String bizOrgCode);

    /**
     * 分页查询站下检测告警记录
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> alarmList(Page page, @Param("bizOrgCode") String bizOrgCode);

    /**
     * 站端装备列表
     * @param page
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> equipList (Page page, @Param("bizOrgCode") String bizOrgCode);


    String queryByCompanyCode(@Param("companyCode") String companyCode);

    List<Map<String, Object>> selectSystemByBizOrgCode(@Param("bizOrgCode") String bizOrgCode);

    List<Map<String, Object>> selectAlarmList(@Param("bizOrgCode") String bizOrgCode, @Param("month")String month, @Param("systemId") String systemId);

    Map<String, Object> selectMonthSummarize(@Param("month")String month, @Param("systemId") String systemId);

    List<Map<String, Object>> selectMonthPieChart(@Param("systemCode")String month, @Param("startDate") String startDate, @Param("endDate") String endDate);

    List<Map<String, Object>> selectMonthPieChartTwo(@Param("systemCode") String sysCode, @Param("startDate") String startDate, @Param("endDate") String endDate, @Param("indicator") List<String> indicator);

    List<Map<String, Object>> selectMonthPolyline(@Param("systemCode") String sysCode, @Param("startDate") String startDate, @Param("endDate") String endDate, @Param("indicator") List<String> indicator);

    List<Map<String, Object>> selectWeekReportList(@Param("systemId") String systemId,@Param("startDate") String startDate, @Param("endDate") String endDate);

    Integer selectAlarms(@Param("systemId") String systemId,
                         @Param("indexType") String indexType,
                         @Param("equipmentCode") String equipmentCode,
                         @Param("startDate") String startDate,
                         @Param("endDate") String endDate,
                         @Param("indicator") List<String> indicator);
    Map<String, Object> selectWeekSummarize(@Param("systemId") String systemId,
                                            @Param("startDate") String startDate,
                                            @Param("endDate") String endDate,
                                            @Param("indicator") List<String> indicator);

    List<Map<String, Object>> selectWeekEquipEchart(@Param("systemCode") String systemCode,
                                                    @Param("startDate") String startDate,
                                                    @Param("endDate") String endDate,
                                                    @Param("indicator") List<String> indicator);

    List<Map<String, Object>> selectWeekEchart(@Param("systemCode") String systemCode,
                                                    @Param("startDate") String startDate,
                                                    @Param("endDate") String endDate);

    List<Map<String, Object>> selectWeekLinesEchart(@Param("systemCode") String systemCode,
                                               @Param("startDate") String startDate,
                                               @Param("endDate") String endDate,
                                                    @Param("indicator") List<String> indicator);

    Map<String, Object> selectDaySummarize(@Param("systemId") String systemId,
                                            @Param("startDate") String startDate,
                                            @Param("endDate") String endDate,
                                           @Param("indicator") List<String> indicator);

    List<Map<String, Object>> selectDayEquipEchart(@Param("systemCode") String systemCode,
                                                    @Param("startDate") String startDate,
                                                    @Param("endDate") String endDate);

    List<Map<String, Object>> selectDayEchart(@Param("systemId") String systemId,
                                                   @Param("date") String date,
                                              @Param("indicator") List<String> indicator);


    List<Map<String, Object>> queryStartAndStopBySpecificId(@Param("ids")List<Long> ids);

    List<Map<String, Object>> queryStateBySpecificId(@Param("id")long id);

    Map<String, Object> getFoamTankLevel(@Param("equipSpeId") Long equipSpeId);

    Map<String, Object> getPipeNetwork(@Param("equipSpeId") Long equipSpeId);

    Map<String, Object> getWaterPoolLevel(@Param("equipSpeId") Long equipSpeId);

    BigDecimal getWaterPoolLevelByEquipSpeId(@Param("equipSpeId") String equipSpeId);

    List<Map<String, Object>> getEquipExpiryStatistics(@Param("bizOrgCode") String bizOrgCode, @Param("expiryDayNum") Integer expiryDayNum);

    Page<Map<String, String>> getEquipExpiryListByPage(@Param("page") Page page, @Param("bizOrgCode") String bizOrgCode, @Param("expiryDayNum") Integer expiryDayNum);

    List<Map<String, Integer>> getStockEquipStatistics(@Param("bizOrgCode") String bizOrgCode);

    List<Map<String, Object>> getSystemInfoList();

    List<Map<String, Object>> getSystemAlarmInfoList(@Param("startDate") String startDate, @Param("endDate") String endDate);

    Map<String, Object> getSystemCountInfo();

    Map<String, Object> getSystemRunningInfoList();

    List<Map<String, Object>> getFireCarInfoByYJYA(@Param("bizOrgCode") String bizOrgCode);

    Page<Map<String, Object>> getCenterWaterInfo(Page page, String bizOrgCode);

    List<Map<String, Object>> systemAndEquipment(@Param("bizOrgCode")String bizOrgCode);

    Long selectEquipCountBySystemId(Long id);

    String selectEquipSystemType(String code);

    Map<String, Object> getWaterlevelUnit();

}
