package com.yeejoin.amos.api.openapi.feign;


import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@FeignClient(name = "TZS-COMMON", path = "/tcm", configuration =
        {FeignConfiguration.class})
public interface TzsTcmServiceFeignClient {

    /**
     * 根据企业统一信用代码询许可信息
     *
     * @param unitCode 企业唯一编码
     * @return
     */
    @RequestMapping(value = "/baseEnterprise/getUnitLicenceMessage", method = RequestMethod.GET)
    ResponseModel<Object> getLicenceByUnitCode(@RequestParam String unitCode);


    /**
     * 字段列表查询
     * @param dictCode 字段类型
     * @return 列表
     */
    @RequestMapping(value = "/data-dictionary/getDataDictionary/{dictCode}", method = RequestMethod.GET)
    ResponseModel<Object> getDataDictionary(@PathVariable String dictCode);

}
