package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RequestContextWrapper;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.ComprehensiveStatisticalAnalysisServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 综合统计分析API
 *
 * @author system_generator
 * @date 2025-06-24
 */
@RestController
@Api(tags = "综合统计分析API")
@RequestMapping(value = "/comprehensiveStatisticalAnalysis")
public class ComprehensiveStatisticalAnalysisController extends BaseController {

    @Autowired
    private ComprehensiveStatisticalAnalysisServiceImpl statisticalAnalysisService;

    /**
     * 查询设备分类
     *
     * @param category
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/select/equipmentCategory")
    @ApiOperation(httpMethod = "POST", value = "查询设备分类", notes = "查询设备分类")
    public ResponseModel<List<Map<String, Object>>> queryEquipmentCategory(@RequestBody JSONObject category) {
        String key = category.getString("key") == null ? null : category.getString("key");
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryEquipmentCategory(key));
    }

    /**
     * @param jsonObject
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/select/queryEquipmentSearchData")
    @ApiOperation(httpMethod = "POST", value = "查询设备查询条件", notes = "查询设备查询条件")
    public ResponseModel<JSONArray> queryEquipmentSearchData(@RequestBody JSONObject jsonObject) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryEquipmentSearchData(jsonObject));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryAdvancedSearch/{type}")
    @ApiOperation(httpMethod = "GET", value = "查询高级筛选", notes = "查询高级筛选")
    public ResponseModel<JSONArray> query(@PathVariable String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryAdvancedSearch(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryCompanySearchData")
    @ApiOperation(httpMethod = "GET", value = "查询企业条件", notes = "查询企业条件")
    public ResponseModel<JSONObject> queryCompanySearchData(@RequestParam(required = false) String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryCompanySearchData(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryPersonSearchData")
    @ApiOperation(httpMethod = "GET", value = "查询个人条件", notes = "查询个人条件")
    public ResponseModel<JSONObject> queryPersonSearchData(@RequestParam(required = false) String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryPersonSearchData(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/permitStatus")
    @ApiOperation(httpMethod = "GET", value = "查询许可状态", notes = "查询许可状态")
    public ResponseModel<JSONArray> getPermitStatus() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.getPermitStatus());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryUnitType")
    @ApiOperation(httpMethod = "GET", value = "查询单位类型", notes = "查询单位类型")
    public ResponseModel<JSONArray> queryUnitType(@RequestParam(required = false) String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryUnitType(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryXK")
    @ApiOperation(httpMethod = "GET", value = "查询许可", notes = "查询许可")
    public ResponseModel<JSONArray> queryXK(@RequestParam(required = false) String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryXK(type));
    }


    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/querySubXK")
    @ApiOperation(httpMethod = "GET", value = "高级筛选查询许可子项目", notes = "高级筛选查询许可子项目")
    public ResponseModel<JSONArray> querySubXK(@RequestParam(required = false) String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.querySubXK(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/select/queryRYLX")
    @ApiOperation(httpMethod = "POST", value = "查询人员类型", notes = "查询人员类型")
    public ResponseModel<JSONArray> queryRYLX(@RequestBody JSONObject params) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryRYLX(params));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryRYLX")
    @ApiOperation(httpMethod = "GET", value = "高级筛选查询人员类型", notes = "高级筛选查询人员类型")
    public ResponseModel<JSONArray> queryRYLX(@RequestParam(required = false) String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryRYLX(type));
    }


    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/querySubRYLX")
    @ApiOperation(httpMethod = "GET", value = "高级筛选查询人员子类型", notes = "高级筛选查询人员子类型")
    public ResponseModel<JSONArray> querySubRYLX(@RequestParam(required = false) String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.querySubRYLX(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryZYXM")
    @ApiOperation(httpMethod = "GET", value = "查询作业项目", notes = "查询作业项目")
    public ResponseModel<JSONArray> queryZYXM(@RequestParam String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryZYXM(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryTypeZYXM")
    @ApiOperation(httpMethod = "GET", value = "高级筛选查询作业项目", notes = "高级筛选查询作业项目")
    public ResponseModel<JSONArray> queryTypeZYXM(@RequestParam String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryTypeZYXM(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryLevelZYXM")
    @ApiOperation(httpMethod = "GET", value = "高级沙筛选查询项目", notes = "高级沙筛选查询项目")
    public ResponseModel<JSONArray> queryLevelZYXM(@RequestParam String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryLevelZYXM(type));
    }


    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryUnitByOrgCode")
    @ApiOperation(httpMethod = "GET", value = "根据监管机构查询企业", notes = "根据监管机构查询企业")
    public ResponseModel<JSONArray> queryUnitByOrgCode(@RequestParam String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryUnitByOrgCode(type));
    }

    /**
     * 综合统计分析接口分页查询
     *
     * @param map
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "POST", value = "综合统计分析接口分页查询", notes = "综合统计分析接口分页查询")
    public ResponseModel<JSONObject> queryForPage(@RequestBody Map<String, Object> map) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryForPage(new JSONObject(map)));
    }

    /**
     * 综合统计分析接口分页查询-大屏中人员列表
     * 区别在于【资质状态】 无资质 certNo_0
     * @param map
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/person/page")
    @ApiOperation(httpMethod = "POST", value = "综合统计分析接口分页查询-大屏中人员列表", notes = "综合统计分析接口分页查询-大屏中人员列表")
    public ResponseModel<JSONObject> queryPersonForPage(@RequestBody Map<String, Object> map) {
        JSONObject jsonObject = new JSONObject(map);
        String targetValue = "certNo_0";
        boolean containsTarget = Optional.of(jsonObject)
                .map(obj -> obj.getJSONObject("filterParams"))
                .map(filterParams -> filterParams.getJSONArray("expiryDate"))
                .map(expiryDateArray -> expiryDateArray.contains(targetValue))
                .orElse(false);
        if (containsTarget) {
            JSONObject filterParams = jsonObject.getJSONObject("filterParams");
            JSONArray expiryDate = filterParams.getJSONArray("expiryDate");
            expiryDate.remove(targetValue);
            JSONArray certNo = Optional.ofNullable(filterParams.getJSONArray("certNo")).orElseGet(JSONArray::new);
            certNo.add("0");
            filterParams.fluentPut("expiryDate", expiryDate).fluentPut("certNo", certNo);
            jsonObject.put("filterParams", filterParams);
        }
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryForPage(jsonObject));
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "添加气瓶使用表中record同步到监管表", notes = "添加气瓶使用表中record同步到监管表")
    @PutMapping(value = "/equip/addGasRecordToSupervision")
    public ResponseModel<Integer> addGasRecordToSupervision() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.addGasRecordToSupervision());
    }


    /**
     * 大屏综合统计查询接口
     *
     * @param map
     * @return  inspectStatus
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/dp/statistics")
    @ApiOperation(httpMethod = "POST", value = "大屏综合统计查询接口", notes = "大屏综合统计查询接口")
    public ResponseModel<JSONObject> queryDpStatistics(@RequestBody Map<String, Object> map) {
        JSONObject jsonObject = new JSONObject(map);
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryDpStatistics(jsonObject));
    }

    /**
     * 综合统计分析接口-导出
     *
     * @param map 入参
     * @return result
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/export")
    @ApiOperation(httpMethod = "POST", value = "综合统计分析接口-导出", notes = "综合统计分析接口-导出")
    public ResponseModel<String> export(@RequestBody Map<String, Object> map) {
        RequestContextWrapper contextWrapper = RequestContextWrapper.capture();
        new Thread(() -> {
            contextWrapper.apply();
            statisticalAnalysisService.export(new JSONObject(map));
        }).start();
        return ResponseHelper.buildResponse("后台处理中，请注意下载！");
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryEquipList")
    @ApiOperation(httpMethod = "GET", value = "高级搜索设备种类", notes = "高级搜索设备种类")
    public ResponseModel<JSONArray> queryEquipList() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryEquipList());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryEquCategory")
    @ApiOperation(httpMethod = "GET", value = "高级搜索设备类别", notes = "高级搜索设备类别")
    public ResponseModel<JSONArray> queryEquCategory(@RequestParam(required = false) String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryEquCategory(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryEquDefine")
    @ApiOperation(httpMethod = "GET", value = "高级搜索设备品种", notes = "高级搜索设备品种")
    public ResponseModel<JSONArray> queryEquDefine(@RequestParam(required = false) String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryEquDefine(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryEquState")
    @ApiOperation(httpMethod = "GET", value = "高级搜索设备状态", notes = "高级搜索设备状态")
    public ResponseModel<JSONArray> queryEquState() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryEquState());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryDicData")
    @ApiOperation(httpMethod = "GET", value = "高级搜索字典类型", notes = "高级搜索字典类型")
    public ResponseModel<JSONArray> queryDicData(@RequestParam String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.getData(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryDicDataNew")
    @ApiOperation(httpMethod = "GET", value = "高级搜索字典类型", notes = "高级搜索字典类型")
    public ResponseModel<JSONArray> queryDicDataNew(@RequestParam String type) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryDicDataNew(type));
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryIsSupervisoryCode")
    @ApiOperation(httpMethod = "GET", value = "高级搜索赋码状态", notes = "高级搜索赋码状态")
    public ResponseModel<JSONArray> queryIsSupervisoryCode() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryIsSupervisoryCode());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryDataQualityScore")
    @ApiOperation(httpMethod = "GET", value = "高级搜索设备等级", notes = "高级搜索设备等级")
    public ResponseModel<JSONArray> queryDataQualityScore() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryDataQualityScore());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/vehicleCylinder")
    @ApiOperation(httpMethod = "GET", value = "高级搜索是否车用气瓶", notes = "高级搜索是否车用气瓶")
    public ResponseModel<JSONArray> queryVehicleCylinder() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryVehicleCylinder());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/qzOrTank")
    @ApiOperation(httpMethod = "GET", value = "高级搜索是否撬装球罐", notes = "高级搜索是否撬装球罐")
    public ResponseModel<JSONArray> queryQzOrTank() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryQzOrTank());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryRegisterStatus")
    @ApiOperation(httpMethod = "GET", value = "高级搜索登记状态", notes = "高级搜索登记状态")
    public ResponseModel<JSONArray> queryRegisterStatus() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryRegisterStatus());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryUscDate")
    @ApiOperation(httpMethod = "GET", value = "高级搜索使用年限", notes = "高级搜索使用年限")
    public ResponseModel<JSONArray> queryUscDate() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryUscDate());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/select/queryTechParam")
    @ApiOperation(httpMethod = "POST", value = "高级搜索技术参数", notes = "高级搜索技术参数")
    public ResponseModel<JSONArray> queryTechParam(@RequestBody JSONObject jsonObject) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryTechParam(jsonObject));
    }


    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryCertType")
    @ApiOperation(httpMethod = "GET", value = "高级搜索证书类型", notes = "高级搜索证书类型")
    public ResponseModel<JSONArray> queryCertType() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryCertType());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryPermissionLevel")
    @ApiOperation(httpMethod = "GET", value = "高级搜索证书级别", notes = "高级搜索证书级别")
    public ResponseModel<JSONArray> queryPermissionLevel() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryPermissionLevel());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryCertNo")
    @ApiOperation(httpMethod = "GET", value = "高级搜索有无资质", notes = "高级搜索有无资质")
    public ResponseModel<JSONArray> queryCertNo() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryCertNo());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryExpiryDate")
    @ApiOperation(httpMethod = "GET", value = "高级搜索资质状态", notes = "高级搜索资质状态")
    public ResponseModel<JSONArray> queryExpiryDate() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryExpiryDate());
    }

    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/select/queryInspectionDate")
    @ApiOperation(httpMethod = "GET", value = "高级搜索检验有效期", notes = "高级搜索检验有效期")
    public ResponseModel<JSONArray> queryInspectionDate() {
        return ResponseHelper.buildResponse(statisticalAnalysisService.queryInspectionDate());
    }


    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/updateDataByOrgBranchCode")
    @ApiOperation(httpMethod = "GET", value = "修改ORG_BRANCH_CODE为50*X综合搜索数据-设备", notes = "修改ORG_BRANCH_CODE为50*X综合搜索数据-设备")
    public ResponseModel<Object> updateDataByOrgBranchCode(@RequestParam(value = "code") String code, @RequestParam(value = "limit") Integer limit) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.updateDataByOrgBranchCode(code, limit));
    }


    /**
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/getDataDifference")
    @ApiOperation(httpMethod = "GET", value = "获取es和数据库数据差异", notes = "获取es和数据库数据差异")
    public ResponseModel<Object> getDataDifference(@RequestParam(value = "code") String code) {
        return ResponseHelper.buildResponse(statisticalAnalysisService.getDataDifference(code));
    }




}
