package com.yeejoin.amos.boot.module.common.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.HashMap;
import java.util.List;

import com.yeejoin.amos.boot.module.common.biz.service.impl.SpecialPositionStaffServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.SpecialPositionStaffDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 特岗人员
 *
 * @author system_generator
 * @date 2021-07-23
 */
@RestController
@Api(tags = "特岗人员Api")
@RequestMapping(value = "/common/special-position-staff")
public class SpecialPositionStaffController extends BaseController {

    @Autowired
    SpecialPositionStaffServiceImpl specialPositionStaffServiceImpl;

    /**
     * 新增特岗人员
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增特岗人员", notes = "新增特岗人员")
    public ResponseModel<SpecialPositionStaffDto> save(@RequestBody SpecialPositionStaffDto model) {
        model = specialPositionStaffServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新特岗人员", notes = "根据sequenceNbr更新特岗人员")
    public ResponseModel<SpecialPositionStaffDto> updateBySequenceNbrSpecialPositionStaff(@RequestBody SpecialPositionStaffDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(specialPositionStaffServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除特岗人员", notes = "根据sequenceNbr删除特岗人员")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
                                                      @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(specialPositionStaffServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个特岗人员", notes = "根据sequenceNbr查询单个特岗人员")
    public ResponseModel<SpecialPositionStaffDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(specialPositionStaffServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "特岗人员分页查询", notes = "特岗人员分页查询")
    public ResponseModel<Page<SpecialPositionStaffDto>> queryForPage(@RequestParam(value = "current") int current,
                                                                     @RequestParam(value = "size") int size,
                                                                     Long companyId,
                                                                     String positionNameCode) {
        Page<SpecialPositionStaffDto> page = new Page<SpecialPositionStaffDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(specialPositionStaffServiceImpl.queryForSpecialPositionStaffPage(page,
                companyId,
                false,
                positionNameCode));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "特岗人员列表全部数据查询", notes = "特岗人员列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<SpecialPositionStaffDto>> selectForList() {
        return ResponseHelper.buildResponse(specialPositionStaffServiceImpl.queryForSpecialPositionStaffList());
    }

    /**
     * 批量删除特岗人员
     *
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete_batch")
    @ApiOperation(httpMethod = "DELETE", value = "批量删除合同信息", notes = "批量删除合同信息")
    public ResponseModel<Boolean> batchDeleteBySequenceNbrList(@RequestParam(value = "sequenceNbrList") List<Long> sequenceNbrList) {
        return ResponseHelper.buildResponse(specialPositionStaffServiceImpl.batchDelete(sequenceNbrList));
    }

    /**
     * 查询没有数据的岗位类型
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询没有数据的岗位类型", notes = "查询没有数据的岗位类型")
    @GetMapping(value = "/gwmc_list")
    public ResponseModel<HashMap<Object, Object>> getSpecialPositionStaffList(Long companyId) throws Exception {
        return ResponseHelper.buildResponse(specialPositionStaffServiceImpl.getSpecialPositionStaffList(companyId));
    }
}
