package com.yeejoin.amos.maintenance.business.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.maintenance.business.service.intfc.IStatisticsService;
import com.yeejoin.amos.maintenance.business.util.CommonResponse;
import com.yeejoin.amos.maintenance.business.util.CommonResponseUtil;
import com.yeejoin.amos.maintenance.core.framework.PersonIdentify;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.HashMap;
import java.util.Map;

/**
 * @author DELL
 */
@RestController
@RequestMapping(value = "/api/statistics")
@Api(tags = "统计api")
public class StatisticsController extends AbstractBaseController {

    @Autowired
    IStatisticsService iStatisticsService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PersonIdentify
    @GetMapping(value = "/task")
    @ApiOperation(value = "app首页任务统计")
    public CommonResponse taskStatusStatistics(){
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getOrgCode(reginParams);
        Map<String,Object> result = iStatisticsService.taskStatusStatistics(opIdentifyInfo(),loginOrgCode);
        return CommonResponseUtil.success(result);
    }

}
