package com.yeejoin.amos.boot.module.jxiop.biz.config;
import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.github.pagehelper.PageInterceptor;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.Properties;


@Configuration
@MapperScan(basePackages  = "com.yeejoin.amos.boot.module.jxiop.api.mapper4", sqlSessionFactoryRef = "forthSqlSessionFactory")
public class ForthDbConfig {
    private Logger logger = LoggerFactory.getLogger(ForthDbConfig.class);
    // 精确到 master 目录，以便跟其他数据源隔离

    private static final String MAPPER_LOCATION = "classpath*:mapper/forth/*.xml";

    @Value("${spring.db4.datasource.url}")
    private String dbUrl;

    @Value("${spring.db4.datasource.username}")
    private String username;

    @Value("${spring.db4.datasource.password}")
    private String password;

    @Value("${spring.db4.datasource.driver-class-name}")
    private String driverClassName;


    @Bean(name="forthDataSource")   //声明其为Bean实例
    public DataSource masterDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.dbUrl);
        datasource.setUsername(username);
        datasource.setPassword(password);
        datasource.setDriverClassName(driverClassName);
        return datasource;
    }

    @Bean(name = "forthTransactionManager")
    public DataSourceTransactionManager masterTransactionManager() {
        return new DataSourceTransactionManager(masterDataSource());
    }

    @Bean(name = "forthSqlSessionFactory")
    public SqlSessionFactory masterSqlSessionFactory(@Qualifier("forthDataSource") DataSource masterDataSource)
            throws Exception {
        final MybatisSqlSessionFactoryBean sessionFactory = new MybatisSqlSessionFactoryBean();
        sessionFactory.setDataSource(masterDataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
                .getResources(ForthDbConfig.MAPPER_LOCATION));
        sessionFactory.setTypeAliasesPackage("com.yeejoin.amos.boot.module.jxiop.api.entity");
        //mybatis 数据库字段与实体类属性驼峰映射配置
        sessionFactory.getObject().getConfiguration().setMapUnderscoreToCamelCase(true);


        //分页插件
         Interceptor interceptor = new PageInterceptor();
         Properties properties = new Properties();
         properties.setProperty("helperDialect", "mysql");
         properties.setProperty("offsetAsPageNum", "true");
         properties.setProperty("rowBoundsWithCount", "true");
         properties.setProperty("reasonable", "true");
         properties.setProperty("supportMethodsArguments","true");
         properties.setProperty("params","pageNum=pageNum;pageSize=pageSize" +
                 "" +
                 ";");
         interceptor.setProperties(properties);



        sessionFactory.setPlugins(new Interceptor[] {interceptor});

        return sessionFactory.getObject();
    }
}
