package com.yeejoin.precontrol.common.service;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.web.multipart.MultipartFile;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.TaskPersonDto;
import com.yeejoin.precontrol.common.dto.TaskSalaryConfirmDto;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.Task;
import com.yeejoin.precontrol.common.entity.TaskSalaryConfirm;
import com.yeejoin.precontrol.common.param.PersonParam;
import com.yeejoin.precontrol.common.vo.PersonSalaryExcelVo;
import com.yeejoin.precontrol.common.vo.PersonVo;
import com.yeejoin.precontrol.common.vo.TaskPersonFeedbackVo;
import com.yeejoin.precontrol.common.vo.TaskSalaryConfirmOneVo;
import com.yeejoin.precontrol.common.vo.TaskSalaryConfirmVo;

/**
 * 薪资确认任务表 服务类
 *
 * @author duanwei
 * @date 2020-12-08
 */
public interface ITaskSalaryConfirmService extends IService<TaskSalaryConfirm> {

	Task save(TaskSalaryConfirmDto taskSalaryConfirmDto, Person person)  throws ParseException;

	IPage<TaskSalaryConfirmVo> pageInfo(CommonPageableDto pageable, TaskSalaryConfirmDto taskSalaryConfirmDto);

	TaskSalaryConfirmVo queryById(Long id);

	boolean confirm(TaskPersonDto taskPersonDto);

	IPage<TaskSalaryConfirmOneVo> todo(CommonPageableDto pageable, TaskSalaryConfirmOneVo taskSalaryConfirmOneVo);

	TaskSalaryConfirmOneVo todoDetail(long taskPersonId,long personId);

	List<PersonSalaryExcelVo> personImport(MultipartFile file) throws Exception;

	IPage<PersonVo> persons(Long id, CommonPageableDto pageable, PersonParam personParam);

	boolean resend(TaskSalaryConfirmOneVo salaryConfirmOneVo);

	TaskSalaryConfirmVo statistics(long id);

	Integer paidRatio(Long projectId, Long companyId);

	List<PersonVo> warnPersons(int day);

	boolean hasFirstRead(long personId);

	boolean doFirstRead(long taskPersonId);
	
	Map<String,Object> statistic(Long projectId,Long companyId,Date startDate,Date endDate,String type);
	
	IPage<TaskPersonFeedbackVo> listNotice(CommonPageableDto pageable, TaskSalaryConfirmDto taskSalaryConfirmDto);
	
	IPage<TaskPersonDto> listUnconfirm(CommonPageableDto pageable, TaskSalaryConfirmDto taskSalaryConfirmDto);
	
}
