package com.yeejoin.amos.boot.module.ymt.biz.controller;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsQyLog;
import com.yeejoin.amos.boot.module.ymt.api.service.ITzsQyLogService;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyModel;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RestController;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Arrays;
import java.util.Date;


/**
 * 96333操作记录日志表
 *
 * @author duanwei
 * @date 2022-12-27
 */
@RestController
@Api(tags = "96333操作记录日志表Api")
@RequestMapping(value = "/tzs-qy-log", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class TzsQyLogController extends BaseController {

  @Autowired
  ITzsQyLogService iTzsQyLogService;


    /**
    * 新增96333操作记录日志表
    * @return
    */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增96333操作记录日志表", notes = "新增96333操作记录日志表")
    public ResponseModel<Boolean> saveTzsQyLog(HttpServletRequest request, @RequestBody TzsQyLog data){
//        AgencyUserModel me = Privilege.agencyUserClient.getme().getResult();
//        data.setRecUserId(me.getUserId());
//        data.setRecUserName(me.getUserName());
//        data.setRecDate(new Date());
        return ResponseHelper.buildResponse(iTzsQyLogService.save(data));
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
        return iTzsQyLogService.removeById(id);
    }




    /**
    * 修改96333操作记录日志表
    * @return
    */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改96333操作记录日志表", notes = "修改96333操作记录日志表")
    public boolean updateByIdTzsQyLog(HttpServletRequest request, @RequestBody TzsQyLog tzsQyLog){
        return iTzsQyLogService.updateById(tzsQyLog);
    }



    /**
   * 根据id查询
   * @param id
   * @return
   */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
   @RequestMapping(value = "/{id}", method = RequestMethod.GET)
   @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
   public TzsQyLog selectById(HttpServletRequest request, @PathVariable Long id){
      return iTzsQyLogService.getById(id);
   }



  /**
  * 列表分页查询
  * @return
  */
  @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
  @RequestMapping(value = "/list", method = RequestMethod.GET)
  @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
  public IPage<TzsQyLog> listPage(String pageNum,String pageSize,
    TzsQyLog tzsQyLog){

    Page<TzsQyLog> pageBean;
    QueryWrapper<TzsQyLog> tzsQyLogQueryWrapper = new QueryWrapper<>();
    Class<? extends TzsQyLog> aClass = tzsQyLog.getClass();
    Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
        try {
            field.setAccessible(true);
            Object o = field.get(tzsQyLog);
            if (o != null) {
                Class<?> type = field.getType();
                String name = NameUtils.camel2Underline(field.getName());
                if (type.equals(Integer.class)) {
                Integer fileValue = (Integer) field.get(tzsQyLog);
                tzsQyLogQueryWrapper.eq(name, fileValue);
                } else if (type.equals(Long.class)) {
                Long fileValue = (Long) field.get(tzsQyLog);
                tzsQyLogQueryWrapper.eq(name, fileValue);
                } else if (type.equals(String.class)) {
                String fileValue = (String) field.get(tzsQyLog);
                tzsQyLogQueryWrapper.eq(name, fileValue);
                } else {
                String fileValue = (String) field.get(tzsQyLog);
                tzsQyLogQueryWrapper.eq(name, fileValue);
            }
          }
        }catch (Exception e) {
        }
    });
    IPage<TzsQyLog> page;
    if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
        pageBean = new Page<>(0, Long.MAX_VALUE);
    }else{
        pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
    }
    page = iTzsQyLogService.page(pageBean, tzsQyLogQueryWrapper);
    return page;
  }
}


