package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.Date;

/**
 * 消防设施资源数据对象 mt_maintenance_resource_data
 *
 * @author gaojianqiang
 * @date 2021-07-16
 */
@Data
@TableName("mt_maintenance_resource_data")
@ApiModel(value = "MaintenanceResourceData", description = "维保设施资源数据")
public class MaintenanceResourceData extends BaseEntity {

    private static final long serialVersionUID = -6785360787829189896L;

    /**
     * 维保单位ID
     */
    private Long maintenanceCompanyId;

    /**
     * 维保单位编码
     */
    private String maintenanceCompanyCode;

    /**
     * 维保单位名称
     */
    private String maintenanceCompanyName;

    /**
     * 业主单位ID
     */
    private Long ownerUnitId;

    /**
     * 业主单位编码
     */
    private String ownerUnitCode;

    /**
     * 业主单位名称
     */
    private String ownerUnitName;

    /**
     * 消防系统ID
     */
    private Long fireFightSysId;

    /**
     * 消防系统编码
     */
    private String fireFightSysCode;

    /**
     * 消防系统名称
     */
    private String fireFightSysName;

    /**
     * 分类ID
     */
    private Long classifyId;

    /**
     * 分类编码
     */
    private String classifyCode;

    /**
     * 分类名称
     */
    private String classifyName;

    /**
     * 分类类型
     */
    private String classifyType;

    /**
     * 消防设施ID
     */
    private Long fireFacilityId;

    /**
     * 消防设施编码
     */
    private String fireFacilityCode;

    /**
     * 消防设施名称
     */
    private String fireFacilityName;

    /**
     * 消防设施类型
     */
    private String fireFacilityType;

    /**
     * 维保周期
     */
    private Integer maintenanceCycle;

    /**
     * 维保到期时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date maintenanceExpirationTime;

    /**
     * 维保时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date maintenanceTime;

    /**
     * 位置
     */
    private String status;

    /**
     * 位置
     */
    private String location;

    /**
     * 建筑ID
     */
    private Long buildingId;

    /**
     * 建筑名称
     */
    private String buildingName;

}
