package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.SourceFile;
import com.yeejoin.equipmanage.common.vo.SourceFileVo;

import java.util.List;

/**
 * @author DELL
 */
public interface IEqSourceFileService extends IService<SourceFile> {
    /**
     * @param sourceId 所属者ID
     * @Description 根据所属者ID查询所属文件并根据fileCategory分组
     * @Return Map<String, List < SourceFile>>
     * @Date 2020/12/18 14:12
     */
    List<SourceFile> findBySourceId(Long sourceId);

    /**
     * @param sourceFiles
     * @Description 批量保存文件
     * @Return List<SourceFile>
     * @Date 2020/12/18 14:27
     */
    List<SourceFile> saveSourceFile(Long sourceId, List<SourceFile> sourceFiles);

    List<SourceFileVo> findImgByFileCategory(Long id, String fileCategory);
}
