package com.yeejoin.precontrol.common.mapper;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.BadPersonDto;
import com.yeejoin.precontrol.common.dto.CompanyPersonAdmissionDto;
import com.yeejoin.precontrol.common.dto.CompanyPersonDto;
import com.yeejoin.precontrol.common.dto.NoJobCompanyDto;
import com.yeejoin.precontrol.common.dto.NoJobDto;
import com.yeejoin.precontrol.common.dto.NoJobPersonDto;
import com.yeejoin.precontrol.common.dto.SafeConstructionDto;
import com.yeejoin.precontrol.common.dto.SafeOperationStatisticsDto;
import com.yeejoin.precontrol.common.dto.TaskPageDto;
import com.yeejoin.precontrol.common.entity.Task;
import com.yeejoin.precontrol.common.vo.BadCompanyVo;
import com.yeejoin.precontrol.common.vo.BadPersonVo;
import com.yeejoin.precontrol.common.vo.CompanyPersonAdmissionVo;
import com.yeejoin.precontrol.common.vo.CompanyPersonVo;
import com.yeejoin.precontrol.common.vo.NoCompanyVo;
import com.yeejoin.precontrol.common.vo.NoJobPersonVo;
import com.yeejoin.precontrol.common.vo.NoJobProjectVo;
import com.yeejoin.precontrol.common.vo.PersonVo;
import com.yeejoin.precontrol.common.vo.RewardAndRetributionListVo;
import com.yeejoin.precontrol.common.vo.TaskPageVo;
import com.yeejoin.precontrol.common.vo.TaskPersonAndImageInfo;

/**
 * 作业活动 Mapper 接口
 *
 * @author duanwei
 * @date 2020-06-30
 */
public interface TaskMapper extends BaseMapper<Task> {
	IPage<TaskPageVo> listByPage(IPage<TaskPageVo> page, @Param("taskPageDto") TaskPageDto taskPageDto);

	IPage<TaskPageVo> myToDoListByPage(IPage<TaskPageVo> page, @Param("taskPageDto") TaskPageDto taskPageDto,
			@Param("doIds") List<Long> doIds);

	IPage<TaskPageVo> safeConstructionTaskStatusList(@Param("page") Page<TaskPageVo> page,
			@Param("safeConstructionDto") SafeConstructionDto safeConstructionDto);

	IPage<TaskPageVo> safeRiskTaskStatusList(@Param("page") Page<TaskPageVo> page,
			@Param("safeConstructionDto") SafeConstructionDto safeConstructionDto);

	IPage<PersonVo> noJobPersonNum(Page<?> page, @Param("noJobDto") NoJobDto noJobDto);

	IPage<NoJobProjectVo> noJobProject(Page<?> page, @Param("noJobDto") NoJobDto noJobDto);

	IPage<NoCompanyVo> noJobCompany(Page<?> page, @Param("noJobCompanyDto") NoJobCompanyDto noJobCompanyDto);

	IPage<CompanyPersonVo> noJobCompanyPerosn(@Param("page") Page<?> page,
			@Param("noJobCompanyDto") NoJobCompanyDto noJobCompanyDto);

	IPage<TaskPageVo> riskWork(@Param("page") Page<TaskPageVo> page, @Param("startTime") String startTime,
			@Param("endTime") String endTime,
			@Param("safeOperationStatisticsDto") SafeOperationStatisticsDto safeOperationStatisticsDto);

	IPage<TaskPageVo> jobTicket(@Param("page") Page<TaskPageVo> page, @Param("startTime") String startTime,
			@Param("endTime") String endTime,
			@Param("safeOperationStatisticsDto") SafeOperationStatisticsDto safeOperationStatisticsDto);

	IPage<TaskPageVo> taskList(@Param("page") Page<TaskPageVo> page, @Param("type") String type,
			@Param("startTime") String startTime, @Param("endTime") String endTime,
			@Param("safeOperationStatisticsDto") SafeOperationStatisticsDto safeOperationStatisticsDto);

	IPage<TaskPageVo> taskPay(@Param("page") Page<TaskPageVo> page, @Param("startTime") String startTime,
			@Param("endTime") String endTime,
			@Param("safeOperationStatisticsDto") SafeOperationStatisticsDto safeOperationStatisticsDto);

	IPage<TaskPageVo> bad(@Param("page") Page<TaskPageVo> page, @Param("startTime") String startTime,
			@Param("endTime") String endTime,
			@Param("safeOperationStatisticsDto") SafeOperationStatisticsDto safeOperationStatisticsDto);

	IPage<TaskPageVo> salaryConfirm(@Param("page") Page<TaskPageVo> page, @Param("startTime") String startTime,
			@Param("endTime") String endTime,
			@Param("safeOperationStatisticsDto") SafeOperationStatisticsDto safeOperationStatisticsDto);

	/**
	 * 今日分包商人员
	 *
	 * @param page
	 * @param companyPersonDto
	 * @return
	 */
	IPage<CompanyPersonVo> companyPerson(@Param("page") Page<?> page,
			@Param("companyPersonDto") CompanyPersonDto companyPersonDto);

	/**
	 * 今日入场分包商人员
	 *
	 * @param page
	 * @param companyPersonAdmissionDto
	 * @return
	 */
	IPage<CompanyPersonAdmissionVo> companyPersonAdmission(@Param("page") Page<?> page,
			@Param("companyPersonAdmissionDto") CompanyPersonAdmissionDto companyPersonAdmissionDto);

	/**
	 * 今日未交底人员
	 *
	 * @param page
	 * @param noJobPersonDto
	 * @return
	 */
	IPage<NoJobPersonVo> noJobPerson(@Param("page") Page<?> page,
			@Param("noJobPersonDto") NoJobPersonDto noJobPersonDto);

	/**
	 * 今日违章员列表
	 *
	 * @param page
	 * @param badPersonDto
	 * @return
	 */
	IPage<BadPersonVo> badPersonList(@Param("page") Page<?> page, @Param("badPersonDto") BadPersonDto badPersonDto);

	List<TaskPersonAndImageInfo> createPersonTask(@Param("personId") Long personId);

	IPage<TaskPageVo> myListByPage(IPage<TaskPageVo> page, @Param("taskPageDto") TaskPageDto taskPageDto);

	Integer myToDoListCount(@Param("type") String type, @Param("personId") Long personId);

	Integer countByPersonAndStatus(@Param("type") Integer type, @Param("personId") Long personId);

	IPage<Object> violationRank(Page<BadCompanyVo> page, @Param("key") String key, @Param("sortType") String sortType,
			@Param("orgCode") String orgCode, @Param("projectId") Long projectId);

	Integer sumTotal(@Param("orgCode") String orgCode, @Param("projectId") Long projectId);

	List<Map> riskStatus(@Param("orgCode") String orgCode, @Param("projectId") Long projectId);

	IPage<RewardAndRetributionListVo> violationList(Page<RewardAndRetributionListVo> objectPage,
			@Param("rewardVo") RewardAndRetributionListVo rewardVo);

	List<Long> noJobPersonIdList(@Param("taskIds") Set<Long> taskIds);

	IPage<NoJobProjectVo> noJobProjectNew(Page<?> page, @Param("personIds") List<Long> personIds,
			@Param("noJobDto") NoJobDto noJobDto);
	
	IPage<NoCompanyVo> noJobCompanyNew(Page<?> page, @Param("personIds") List<Long> personIds,
			@Param("noJobCompanyDto") NoJobCompanyDto noJobCompanyDto);
}
