package com.yeejoin.amos.boot.module.tzs.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.EquipmentCategoryDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.tzs.api.mapper.EquipmentCategoryMapper;
import com.yeejoin.amos.boot.module.tzs.api.service.IEquipmentCategoryService;
import com.yeejoin.amos.boot.module.tzs.biz.utils.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 装备分类服务实现类
 *
 * @author system_generator
 * @date 2021-10-20
 */
@Service
public class EquipmentCategoryServiceImpl extends BaseService<EquipmentCategoryDto, EquipmentCategory, EquipmentCategoryMapper> implements IEquipmentCategoryService {

    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;

    @Value("classpath:/json/equipCategory.json")
    private Resource equipCategory;

    @Value("classpath:/json/equipStatus.json")
    private Resource equipStatus;

    /**
     * 分页查询
     */
    public Page<EquipmentCategoryDto> queryForEquipmentCategoryPage(Page<EquipmentCategoryDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<EquipmentCategoryDto> queryForEquipmentCategoryList() {
        return this.queryForList("", false);
    }

    public List<EquipmentCategoryDto> selectClassify() {
        return equipmentCategoryMapper.selectClassify();
    }

    @Override
    public List<Map<String, Object>> equipTree() {
        List<Map> mapList = JsonUtils.getResourceJson(equipCategory);
        List<Map<String, Object>> menus = new ArrayList<>();
        for (Map map : mapList) {
            Map<String, Object> resultMap = new HashMap<>();
            resultMap.put("instanceName", map.get("name"));
            resultMap.put("instanceId", map.get("code"));
            menus.add(resultMap);
        }
        return menus;
    }

    @Override
    public Page equipClaimOverview() {
        Page page = new Page<>();
        List<Map> mapList = JsonUtils.getResourceJson(equipCategory);
        List<Map<String, Object>> list = new ArrayList<>();
        for (Map map : mapList) {
            Map<String, Object> resultMap = new HashMap<>();
//            Map<String, Object> map1 = equipmentCategoryMapper.getCategoryCount(map.get("code").toString());
            Map<String,Object> objectMap = new HashMap<>();
            objectMap.put("waitClaim",985);
            objectMap.put("alreadyClaim",18985);
            objectMap.put("refuseClaim",985);
            List<Map<String, Object>> list1= new ArrayList<>();
            List<Map> equipStatusList = JsonUtils.getResourceJson(equipStatus);
            for (Map equipStatusMap : equipStatusList) {
                Map<String, Object> map1 = new HashMap<>();
                map1.put("name",equipStatusMap.get("value"));
                map1.put("value",objectMap.get(equipStatusMap.get("value")));
                list1.add(map1);
            }
            resultMap.put("name",map.get("name"));
            resultMap.put("image",map.get("image"));
            resultMap.put("waitClaim",985);
            resultMap.put("alreadyClaim",18985);
            resultMap.put("refuseClaim",985);
            resultMap.put("sum",20955);
            resultMap.put("value",list1);
            list.add(resultMap);
        }
        page.setCurrent(1);
        page.setTotal(list.size());
        page.setRecords(list);
        return page;
    }

}