package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.Enum.ProcessTypeEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.PipeDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Pipe;
import com.yeejoin.amos.boot.module.ugp.api.mapper.PipeMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IPipeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.Map;


@Service
public class IPipeServiceImpl extends BaseService<PipeDto, Pipe, PipeMapper> implements IPipeService {

    @Autowired
    PipeMapper pipeMapper;

    @Override
    @Transactional
    public void addPipeMessage(String jsonMessage, Long projectId) {
        List<PipeDto> userList = JSON.parseArray(jsonMessage, PipeDto.class);
        if (!ObjectUtils.isEmpty(userList)) {
            LambdaQueryWrapper<Pipe> lambda = new QueryWrapper<Pipe>().lambda();
            lambda.eq(Pipe::getProjectId, projectId);
            pipeMapper.delete(lambda);
            userList.forEach(item -> {
                item.setStartPosition(item.getStartPositionObject().getString("latitude")+","+item.getStartPositionObject().getString("longitude"));
                item.setStartName(item.getStartPositionObject().getString("address"));
                item.setEndPosition(item.getEndPositionObject().getString("latitude")+","+item.getEndPositionObject().getString("longitude"));
                item.setEndName(item.getEndPositionObject().getString("address"));
                item.setProjectId(projectId);
                this.createWithModel(item);
            });
        }
    }

    @Override
    public Page<Map<String, Object>> getOperationalLogs(Page<Map<String, Object>> mapPage, String instanceId) {
        return pipeMapper.getOperationalLogs(mapPage, instanceId);
    }
}
