package com.yeejoin.amos.boot.module.ugp.biz.service.impl;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.ugp.api.Enum.*;
import com.yeejoin.amos.boot.module.ugp.api.dto.*;
import com.yeejoin.amos.boot.module.ugp.api.entity.*;
import com.yeejoin.amos.boot.module.ugp.api.mapper.VerifyMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.WeldMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IVerifyService;
import com.yeejoin.amos.boot.module.ugp.biz.fegin.MaasServiceFeignClient;
import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
/**
 * 智能监检管理表服务实现类
 * @author system_generator
 * @date 2022-09-22
 */

@Service

public class VerifyServiceImpl extends BaseService<VerifyDto,Verify,VerifyMapper> implements IVerifyService {

    @Autowired
    private EmqKeeper emqKeeper;
    @Autowired
    InstallNoticeServiceImpl installNoticeService;
    @Autowired
    WeldServiceImpl weldService;
    @Autowired
    WeldMapper weldMapper;
    @Autowired
    OrgServiceImpl orgService;
    @Autowired
    private  MaterialServiceImpl materialService;
    @Autowired
    VerifyMapper verifyMapper;
     @Autowired
     private EquipmentServiceImpl equipmentService;
    @Autowired
    private QualityProblemServiceImpl qualityProblemService;
    @Autowired
    private ProjectServiceImpl projectServiceImpl;
    @Autowired
    private ProjectResourceServiceImpl projectResourceService;
    @Autowired
    private AttachmentServiceImpl attachmentService;
    @Autowired
    private ProblemInitiationServiceImpl problemInitiationService;
    @Autowired
    private  CompanyServiceImpl companyService;

    @Value("${mqtt.topic.weldUpdate}")
    private String weldUpdate;

    @Autowired
    private MaasServiceFeignClient maasServiceFeignClient;
    /**

     * 分页查询

     */

    public Page<VerifyDto> queryForVerifyPage(Page<VerifyDto> page)   {

        return this.queryForPage(page, null, false);

    }

    /**
     * 列表查询 示例
     */
    public List<VerifyDto> queryForVerifyList()   {
        return this.queryForList("" , false);
    }
    /**  cpp
     * 智能监检共用查询方法
     * stage 阶段
     * page 分页
     */
    @Override
    public Page<SmartListDto> commonality(String stage, Page<SmartListDto> page, SmartListDto smartListDto){
        Page<Verify> objectPage = new Page<>( );
        objectPage.setCurrent(page.getCurrent());
        objectPage.setSize(page.getSize());
        Page<Verify> pageDto=verifyMapper.commonality(objectPage,stage,smartListDto,null );
        List<Verify> verifyList =pageDto.getRecords();
        List<SmartListDto> dtoList =new ArrayList<>();
        //进入焊前
        if (verifyList !=null && verifyList.size() !=0){
            for (Verify verify : verifyList) {
                SmartListDto dto = new SmartListDto( );
                dto.setSequenceNbr(verify.getSequenceNbr());//智能监检表id
                dto.setProjectId(verify.getProjectId());  //项目id
                dto.setName(verify.getProject().getName());//项目名称
                dto.setProjectCode(verify.getProject().getCode());//项目编号
                //检验状态
                String status = verify.getStatus( );
                if (status.equals(VerifyEnum.已通过.getStatus())) {
                    dto.setStatus(VerifyEnum.已通过.getName());
                }
                if (status.equals(VerifyEnum.未通过.getStatus())) {
                    dto.setStatus(VerifyEnum.未通过.getName());
                }
                dto.setType(verify.getType());//检验方式
                Date verifyTime = verify.getVerifyTime( );
                dto.setSubmitTime(verify.getVerifyTime());//交检日期
                dto.setVerifyTime(verify.getVerifyTime());//检验时间
                String stage1 = verify.getStage( );//检验检测阶段
                Map<String, String> map = StageEnum.getStatusByVerifyNameMap;
                for (String key:map.keySet()){
                    if (key.equals(stage1)) {
                        dto.setStage(String.valueOf(map.get(key)));//将阶段赋值
                    }
                }
                String targetInfo = verify.getTargetInfo();//app上传数据
                JSONObject jsonObject = JSONObject.parseObject(targetInfo);
                String code = jsonObject.getString("code");//焊口编码
                String manyCode = jsonObject.getString("manyCode");
                if (!StringUtils.isEmpty(code)) {
                    dto.setCode(code);
                }
                if (!StringUtils.isEmpty(manyCode)) {
                        dto.setCode(manyCode);
                }
                String location = jsonObject.getString("location");
                if (!StringUtils.isEmpty(location)) {
                    dto.setPeopleLocation(location);
                }
                Long welderId = jsonObject.getLong("welderId");
                if (welderId!=null) {
                    dto.setWelderId(welderId);
                    OrgUsr orgUsr = orgService.getOrgUsrById(welderId.toString());
                    if (orgUsr != null) {
                        if (!StringUtils.isEmpty(orgUsr.getBizOrgName())) {
                            dto.setPeopleName(orgUsr.getBizOrgName());//焊工姓名
                        }
                        if (!StringUtils.isEmpty(orgUsr.getCode())) {
                            dto.setPersonWeld(orgUsr.getCode());//焊工编号
                        }
                    }
                }
                //人员持证判断 设备检定状态  管材质量许可
                String peopleStatus = jsonObject.getString("peopleStatus");
                if (!StringUtils.isEmpty(peopleStatus)) {
                    dto.setPeopleStatus(peopleStatus);
                    dto.setFacilityStatus(peopleStatus);
                    dto.setPermission(peopleStatus);
                }
                Long weldingId = jsonObject.getLong("weldingId");
                if (weldingId !=null) {
                    dto.setWeldingId(weldingId);
                    EquipmentDto equipmentDto = equipmentService.queryBySeq(weldingId);
                    if (equipmentDto != null) {
                        //设备名  设备编号
                        dto.setFacilityName(equipmentDto.getName());
                        dto.setFacilityNumber(equipmentDto.getCode());
                    }
                }
                String materiaCode = jsonObject.getString("materialId");
                if (!ValidationUtil.isEmpty(materiaCode)) {
                    //管材编号
                    dto.setMaterialCode(materiaCode);
                    Material material = materialService.getMaterial(materiaCode);
                    if (material != null) {
                        //管材厂家 管材批号
                        dto.setManufacturer(material.getManufacturer());
                        dto.setBatchNumber(material.getCode());
                    }
                }
                //工艺
                String craft = jsonObject.getString("craft");
                if (!StringUtils.isEmpty(craft)) {
                    dto.setCraft(craft);
                }
                String duration = jsonObject.getString("duration");
                if (!StringUtils.isEmpty(duration)) {
                    dto.setDuration(duration);
                }
                //耐压
                Long pressureId = jsonObject.getLong("pressureId");
                if (pressureId != null) {
                    EquipmentDto equipmentDto = equipmentService.queryBySeq(pressureId);
                    if (equipmentDto != null && !StringUtils.isEmpty(equipmentDto.getName()) &&!StringUtils.isEmpty(equipmentDto.getCode())) {
                        dto.setPressureName(equipmentDto.getName());
                        dto.setPressureCode(equipmentDto.getCode());
                    }
                }
                String pressureTest = jsonObject.getString("pressureTest");
                if (!StringUtils.isEmpty(pressureTest)) {
                    dto.setMpa(pressureTest);
                }
                String pressureNumber = jsonObject.getString("pressureNumber");
                if (!ValidationUtil.isEmpty(pressureNumber)) {
                    dto.setPressureNumber(pressureNumber);
                }
                //埋深
                String depthType = jsonObject.getString("depthType");
                if (!StringUtils.isEmpty(depthType)) {
                    dto.setDetectionMethod(depthType);
                }
                String depth = jsonObject.getString("depth");
                if (!StringUtils.isEmpty(depth)) {
                    dto.setBurialDepth(depth);
                }
                //位置标定
                String locationType = jsonObject.getString("locationType");
                if (!StringUtils.isEmpty(locationType)) {
                    dto.setPreciseWeldingPosition(locationType);
                }
                String resuts = jsonObject.getString("resuts");
                if (!StringUtils.isEmpty(resuts)) {
                    dto.setResuts(resuts);
                }
                dtoList.add(dto);
            }
        }
        page.setRecords(dtoList);
        page.setTotal(dtoList.size());

        return page ;
    }

    public void weldUpdate(JSONObject jsonObject,Integer status){
        Weld weld = weldService.getOne(new LambdaQueryWrapper<Weld>().eq(Weld::getCode,jsonObject.getString("code")));
        String location = jsonObject.getString("location");

        if(!ValidationUtil.isEmpty(status)){
            weld.setStatus(status);
        }

        if(!"4.9E-3244.9E-324".equals(location)) {
            if (location.contains(",")) {
                String longitude = location.substring(0, location.indexOf(","));
                String latitude = location.substring(longitude.length() + 1);
                weld.setLongitude(longitude);
                weld.setLatitude(latitude);
                weldService.updateById(weld);
                try {
                    emqKeeper.getMqttClient().publish(weldUpdate, weld.toString().getBytes(), 1, false);
                } catch (MqttException e) {
                    e.printStackTrace();
                }
            }
        }
    }
    
    /**  cpp
     * 智能监检校验数据
     * @param jsonObject
     * @return String
     */
    private static final String TYPE="智能检验";

    /**
     * 焊前校验不通过时删除焊口码 并将tz_ugp_verify表中的code制空
     * @param weldCode
     */
    public void deleteWeld(String weldCode){
        //焊前校验不通过需要将新申请的焊口删除！
        LambdaQueryWrapper<Weld> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Weld::getCode,weldCode);
        Long weldId = weldService.getOne(wrapper).getSequenceNbr();
        weldService.deleteBySeq(weldId);
        //检查tz_ugp_verify表中code=weldCode的校验记录，将code制空
        LambdaQueryWrapper<Verify> verifierWrap = new LambdaQueryWrapper<>();
        verifierWrap.eq(Verify::getCode,weldCode);
        List<Verify> list = this.list(verifierWrap);
        Iterator<Verify> iterator = list.iterator();
        while (iterator.hasNext()) {
            Verify verifyNew = iterator.next();
            verifyNew.setCode("");
            this.updateById(verifyNew);
        }
    }

    @BusinessIdentify
    public String checks(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.size() ==0) {
            return  VerifyEnum.未通过.getName();
        }

        //通过userid和projectId来对应
        Long welderId = orgService.getReginParams( ).getBusinessInfo( ).getUserSequenceNbr( );
        Long random = jsonObject.getLong("random");//随机值
        Long projectId= jsonObject.getLong("projectId");//项目id
      //Long welderId = jsonObject.getLong("welderId"); //焊工id
        String location = jsonObject.getString("location");//焊接定位信息
        String stage = jsonObject.getString("stage");//阶段检验
        Date time = new Date();// //获取当前校验时间
        String photo = jsonObject.getString("photo");//图片
        String weldCode = jsonObject.getString("code"); //焊口码
        Verify verify = new Verify( );
        jsonObject.put("welderId",welderId);
        verify.setProjectId(projectId);//项目id
        verify.setType(TYPE);//检验方式
        verify.setVerifyTime(time);//获取当前时间
     List<Verify>  verifyList = verifyMapper.selectByWelder(projectId,welderId,null,null,random);

        //人员
        if (stage.equals(StageEnum.焊前人员.getVerifyName())) {
            verify.setStage(StageEnum.焊前人员.getStage()); //阶段
            verify.setCode(jsonObject.getString("code"));
            //人脸
            //1.人脸识别校验
            //2.焊工资质有效期判断,查询焊工信息获取
            //3.证书是否和项目符合
            //失败
            //属性赋值
            jsonObject.put(CheckEnum.符合.getKey(),CheckEnum.符合.getName());//人脸
            if (welderId != null) {
                ProjectResource resource = projectResourceService.getprojectResource(welderId, null, "welder");
                if (!ValidationUtil.isEmpty(resource)) {
                    Map map = orgService.getdetialInfo(welderId.toString( ));
                    String certValidDate = String.valueOf(map.get("certValidDate"));
                    if (certValidDate!=null && !certValidDate.equals("")) {
                        Date vaildParse =null;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        try {
                            vaildParse = sdf.parse(certValidDate);
                        } catch (ParseException e) {
                            e.printStackTrace( );
                        }
                        if (time.compareTo(vaildParse) <=0) {
                            jsonObject.put(CheckEnum.有效.getKey(),CheckEnum.有效.getName());
                            jsonObject.put(CheckEnum.合格期内.getKey(),CheckEnum.合格期内.getName());
                        }else {
                            jsonObject.put(CheckEnum.已过期.getKey(),CheckEnum.已过期.getName());
                            jsonObject.put(CheckEnum.超期未检.getKey(),CheckEnum.超期未检.getName());
                        }
                    }
                }
            }
            Boolean flag =true;
            if (!CheckEnum.符合.getName().equals(jsonObject.getString(CheckEnum.符合.getKey())) ||
                    !CheckEnum.有效.getName().equals(jsonObject.getString(CheckEnum.有效.getKey()))) {
                 flag =false;
            }
            String targetInfo = jsonObject.toString();
            verify.setTargetInfo(targetInfo);//json信息
            if (!flag) {
                //焊前校验不进行质量问题生产
//                this.addFailData(verify,jsonObject,new QualityProblem());
                deleteWeld(weldCode);
                return VerifyEnum.未通过.getName();
            }
            //成功
            this.addSuccessData(verify,null,jsonObject);
            //更新weld焊口信息表中的经纬度信息
            weldUpdate(jsonObject,null);
        }
        //管材
        if (stage.equals(StageEnum.焊前管材质量.getVerifyName())){
            verify.setCode(jsonObject.getString("code"));
            //从图片中获取管材编号materialId
           //管材编号(暂时写死)
            String url = photo;
            String materialCode = getMaterialCodeByOcr(url);
            verify.setStage(StageEnum.焊前管材质量.getStage());
            /**校验*/
            Boolean flag =false;
            if (!ValidationUtil.isEmpty(materialCode)) {
                //由于通过管材编号查询,项目资源中没有管材编号,先查管材资源,在通过管材资源id查询项目资源
                Material material = materialService.getMaterial(materialCode);
                ProjectResource resource = null;
                if(!ValidationUtil.isEmpty(material)) {
                    resource = projectResourceService.getOne(new LambdaQueryWrapper<ProjectResource>().eq(ProjectResource::getResourceId,material.getSequenceNbr()).eq(ProjectResource::getType,"material"));
                }
                if (!ValidationUtil.isEmpty(material) && !ValidationUtil.isEmpty(resource)) {
                        jsonObject.put(CheckEnum.有效.getKey(),CheckEnum.有效.getName());
                        jsonObject.put(CheckEnum.符合.getKey(),CheckEnum.符合.getName());
                        if (!ValidationUtil.isEmpty(material.getManufacturer())) {
                            jsonObject.put("manufacturer",material.getManufacturer());
                        }
                        if (!ValidationUtil.isEmpty(material.getBatchNum())) {
                            jsonObject.put("batchNumber",material.getBatchNum());
                        }
                        jsonObject.put(CheckEnum.合格期内.getKey(),CheckEnum.合格期内.getName());
                        flag = true;
                }else {
                    jsonObject.put(CheckEnum.已过期.getKey(),CheckEnum.已过期.getName());
                    jsonObject.put(CheckEnum.不符合.getKey(),CheckEnum.不符合.getName());
                    jsonObject.put(CheckEnum.超期未检.getKey(),CheckEnum.超期未检.getName());
                }
            }
            String targetInfo = jsonObject.toString();
            verify.setTargetInfo(targetInfo);
            if (!flag) {
                //焊前校验不进行质量问题生产
//                this.addFailData(verify,jsonObject,new QualityProblem());
                deleteWeld(weldCode);
                return VerifyEnum.未通过.getName();
            }
            this.addSuccessData(verify,null,jsonObject);
            //更新weld焊口信息表中的经纬度信息
            weldUpdate(jsonObject,null);
        }
        //设备
        if (stage.equals(StageEnum.焊前设备.getVerifyName())){
            verify.setCode(jsonObject.getString("code"));
            verify.setStage(StageEnum.焊前设备.getStage());
            Long weldingId = jsonObject.getLong("weldingId");
            Boolean flag =false ;
            //后面需要修改此处
            if (!ValidationUtil.isEmpty(weldingId)) {
                ProjectResource resource = projectResourceService.getprojectResource(weldingId, null, "equipment");
                Equipment equipment = equipmentService.getEquipment(weldingId);
                if (!ValidationUtil.isEmpty(equipment) && !ValidationUtil.isEmpty(resource)) {
                    jsonObject.put(CheckEnum.有效.getKey(),CheckEnum.有效.getName());
                    jsonObject.put(CheckEnum.符合.getKey(),CheckEnum.符合.getName());
                    jsonObject.put(CheckEnum.合格期内.getKey(),CheckEnum.合格期内.getName());
                    if (StringUtils.isNotEmpty(equipment.getName())) {
                        jsonObject.put("facilityName",equipment.getName());
                    }
                    if (StringUtils.isNotEmpty(equipment.getCode())) {
                        jsonObject.put("facilityNumber",equipment.getCode());
                    }
                    flag=true;
                }else{
                    jsonObject.put(CheckEnum.已过期.getKey(),CheckEnum.已过期.getName());
                    jsonObject.put(CheckEnum.不符合.getKey(),CheckEnum.不符合.getName());
                    jsonObject.put(CheckEnum.超期未检.getKey(),CheckEnum.超期未检.getName());
                }
            }
            String targetInfo = jsonObject.toString();
            verify.setTargetInfo(targetInfo);//json信息
            if (!flag) {
                //校验不通过
                //焊前校验不进行质量问题生产
//                this.addFailData(verify,jsonObject,new QualityProblem());
                deleteWeld(weldCode);
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            this.addSuccessData(verify,null,jsonObject);
            //更新weld焊口信息表中的经纬度信息
            weldUpdate(jsonObject,null);
        }
        //工艺
        if (stage.equals(StageEnum.焊接工艺.getVerifyName())){
            //焊口编号是否上传
            String code = jsonObject.getString("code");
            if (StringUtils.isEmpty(code)) {
                return VerifyEnum.未通过.getName();
            }
            //判断人员是否效验通过
            List<Verify> welderList = verifyList.stream( ).filter(b -> b.getStage( ).equals(StageEnum.焊前人员.getStage( ))).collect(Collectors.toList( ));
            //判断管材是否效验通过
            List<Verify> materialList = verifyList.stream( ).filter(b -> b.getStage( ).equals(StageEnum.焊前管材质量.getStage( ))).collect(Collectors.toList( ));
            //判断设备是否校验通过
            List<Verify> facilityList = verifyList.stream( ).filter(b -> b.getStage( ).equals(StageEnum.焊前设备.getStage( ))).collect(Collectors.toList( ));
            if (welderList ==null ||materialList ==null || facilityList ==null || welderList.size()==0 || materialList.size()==0  || facilityList.size()==0) {
                return VerifyEnum.未通过.getName();
            }
            for (Verify v1 : welderList) {
                if (v1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
            }
            for (Verify v2 : materialList) {
                if (v2.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
            }
            for (Verify v3 : facilityList) {
                if (v3.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
            }
            //如果焊前效验已经通过进行效验步骤
            Boolean flag =false;
            verify.setStage(StageEnum.焊接工艺.getStage());
            String result = jsonObject.getString("result");
            if ("ok".equals(result)) {
               flag =true;
            }
            jsonObject.put("duration","时长");
            jsonObject.put("facilityNumber","焊机编号");
            String targetInfo = jsonObject.toString();
            verify.setTargetInfo(targetInfo);//json信息
            verify.setCode(code);
            if (!flag) {
                //校验不通过
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            this.addSuccessData(verify,null,jsonObject);
            /**注意: app那边没有 暂时耐压假数据*/
            Verify v1 = new Verify( );
            JSONObject object = new JSONObject( );
            object.put("pressureTest","10Mpa");
            object.put("stage","耐压");
            object.put("code",code);
            object.put("pressureId",1587252459623968770L);
            object.put("welderId",welderId);
            object.put("photo","upload/ugp/amos_studio/E47A1E7D1BD4517B20923F108FC03F1.jpg");
            object.put("location","经纬度");
            object.put("projectId",projectId);
            Calendar calendar = Calendar.getInstance();
            String year = String.valueOf(calendar.get(Calendar.YEAR));
            int month = calendar.get(Calendar.MONTH) + 1;
            int day = calendar.get(Calendar.DATE);
            StringBuffer stringBuffer = new StringBuffer( );
            stringBuffer.append(year).append(month).append(day).append("-")
                    .append(UUID.randomUUID().toString().substring(UUID.randomUUID().toString().length()-4));
            jsonObject.put("pressureNumber",stringBuffer.toString());
            String info = object.toJSONString();
            v1.setTargetInfo(info);
            v1.setProjectId(projectId);//项目id
            v1.setType(TYPE);//检验方式
            v1.setVerifyTime(time);
            v1.setCode(code);
            v1.setStage(StageEnum.管道耐压.getStage());
            v1.setSubmitTime(time);
            this.addSuccessData(v1,null,object);
            //更新weld焊口信息表中的经纬度信息,更新焊口状态 已完成
            weldUpdate(jsonObject,WeldStatusEnum.已完成.getStatus());
        }
        //耐压
        if (stage.equals(StageEnum.管道耐压.getVerifyName())){
            //查询工艺是否校验通过(可能有好几个焊口码)
            //获取前端传的焊口编号(工艺阶段焊口编号必传)
            String manyCode = jsonObject.getString("manyCode");//获取多个焊口编号
            if (StringUtils.isEmpty(manyCode)) {
                return VerifyEnum.未通过.getName();
            }
            String[] codeArray = manyCode.split(",");
            //工艺的效验
            for (String code : codeArray) {
                List<Verify> verifyList1 = verifyMapper.selectByWelder(projectId, welderId, code,StageEnum.焊接工艺.getStage(),null);
                for (Verify verify1 : verifyList1) {
                    //工艺阶段未效验
                    if (verify1 == null) {
                        return VerifyEnum.未通过.getName();
                    }
                    //工艺已校验
                    if (!StringUtils.isEmpty(verify1.getStatus())&&verify1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                        return VerifyEnum.未通过.getName();
                    }
                }
            }
            //如果工艺效验已经通过进行耐压校验步骤,(特别注意,只需要效验头部和尾部耐压)
            verify.setStage(StageEnum.管道耐压.getStage());
            verify.setCode(manyCode);
            /**
             * 效验假数据
             */
            Boolean flag =true ;
            Calendar calendar = Calendar.getInstance();
            String year = String.valueOf(calendar.get(Calendar.YEAR));
            int month = calendar.get(Calendar.MONTH) + 1;
            int day = calendar.get(Calendar.DATE);
            StringBuffer stringBuffer = new StringBuffer( );
            stringBuffer.append(year).append(month).append(day).append("-")
                    .append(UUID.randomUUID().toString().substring(UUID.randomUUID().toString().length()-4));
            jsonObject.put("pressureNumber",stringBuffer.toString());
            String targetInfo = jsonObject.toString();
            verify.setTargetInfo(targetInfo);//json信息
            if (!flag) {
                //校验不通过
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            this.addSuccessData(verify,codeArray,jsonObject);
            //更新weld焊口信息表中的经纬度信息
            weldUpdate(jsonObject,null);
        }
        //埋深
        if (stage.equals(StageEnum.敷设质量.getVerifyName())){
            //查询耐压是否校验通过
            String manyCode = jsonObject.getString("manyCode");//获取多个焊口编号
            if (StringUtils.isEmpty(manyCode)) {
                return VerifyEnum.未通过.getName();
            }
            Verify verify1 = verifyMapper.selectByCode(manyCode, projectId, StageEnum.管道耐压.getStage( ),null);
            //耐压没有效验数据
            if (verify1 == null) {
                return VerifyEnum.未通过.getName();
            }
            //耐压有效验数据,但是不通过
            if (verify1 != null && verify1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                return VerifyEnum.未通过.getName();
            }
            //耐压校验已经通过,进行埋深校验
            verify.setStage(StageEnum.敷设质量.getStage());
            verify.setCode(manyCode);
            /**
             * 效验假数据
             */
            Boolean flag =true ;
            String targetInfo = jsonObject.toString();
            verify.setTargetInfo(targetInfo);//json信息
            if (!flag) {
                //校验不通过
                String[] codeArray = manyCode.split(",");
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            String []codeArray =manyCode.split(",");
            this.addSuccessData(verify,codeArray,jsonObject);
        }
         //定位
        if (stage.equals(StageEnum.定位.getVerifyName())){
            //查询埋深是否校验通过
            String manyCode = jsonObject.getString("manyCode");
            if (StringUtils.isEmpty(manyCode)) {
                return VerifyEnum.未通过.getName();
            }
            Verify v1 = verifyMapper.selectByCode(manyCode, projectId, StageEnum.敷设质量.getStage( ),null);
            //埋深没有效验数据
            if (v1 == null) {
                return VerifyEnum.未通过.getName();
            }
            //埋深有效验数据,但是不通过
            if (v1 != null && v1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                return VerifyEnum.未通过.getName();
            }
            //耐压校验已经通过,没有埋深数据,进行埋深校验
            verify.setStage(StageEnum.定位.getStage());
            verify.setCode(manyCode);
            /**
             * 效验假数据
             */
            Boolean flag =true ;
            jsonObject.put("resuts","标定结果");
            String targetInfo = jsonObject.toString();
            verify.setTargetInfo(targetInfo);//json信息
            if (!flag) {
                //校验不通过
                QualityProblem qp = new QualityProblem( );
                String[] codeArray = manyCode.split(",");
                this.addFailData(verify,jsonObject,qp);
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            String []codeArray =manyCode.split(",");
            this.addSuccessData(verify,codeArray,jsonObject);
            //更新weld焊口信息表中的经纬度信息
            weldUpdate(jsonObject,null);
        }
        //回填
        if (stage.equals(StageEnum.回填.getVerifyName())) {
            String manyCode = jsonObject.getString("manyCode");
            if (StringUtils.isEmpty(manyCode)) {
                return VerifyEnum.未通过.getName();
            }
            Verify v1 = verifyMapper.selectByCode(manyCode, projectId, StageEnum.定位.getStage( ),null);
            //判断定位没有校验数据
            if (v1 == null) {
                return VerifyEnum.未通过.getName();
            }
            //定位有效验数据,但是不通过
            if (v1 != null && v1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                return VerifyEnum.未通过.getName();
            }
            //定位校验已经通过,没有回填数据,进行回填校验
            verify.setStage(StageEnum.回填.getStage());
            verify.setCode(manyCode);
            /**
             * 效验假数据
             */
            Boolean flag =true ;
            String targetInfo = jsonObject.toString();
            verify.setTargetInfo(targetInfo);//json信息
            if (!flag) {
                //校验不通过
                QualityProblem qualityProblem = new QualityProblem( );
                this.addFailData(verify,jsonObject,qualityProblem);
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            String []codeArray =manyCode.split(",");
            this.addSuccessData(verify,codeArray,jsonObject);
            //更新weld焊口信息表中的经纬度信息
            weldUpdate(jsonObject,null);


        }
        return VerifyEnum.已通过.getName();
    }


    /**  cpp
     * 校验失败需要添加的数据
     * @param verify
     * @param qualityProblem
     */
    // 静态变量存储最大值
    private static final AtomicInteger atomicNum = new AtomicInteger(1);
    public void addFailData(Verify verify,JSONObject jsonObject,QualityProblem qualityProblem){
        //校验不通过，存入校验信息，
        verify.setStatus(VerifyEnum.未通过.getStatus());
        try {
            //智能监检管理表添加数据
            boolean save = this.save(verify);
        } catch (Exception e) {
            e.printStackTrace();
        }
        //质量问题表添加数据
        qualityProblem.setProjectId(verify.getProjectId());
        qualityProblem.setSubmitDate(new Date());
        Calendar calendar = Calendar.getInstance();
        // 获取当前年
        int year = calendar.get(Calendar.YEAR);
        // 获取当前月
        int month = calendar.get(Calendar.MONTH) + 1;
        // 获取当前日
        int day = calendar.get(Calendar.DATE);
        StringBuffer stringBuffer = new StringBuffer( );
        stringBuffer.append(year).append(month).append(day);
        String date = stringBuffer.toString( );
        //获取当前的值并自增
        int newNum  = atomicNum.incrementAndGet( );

        String code =String.format(date+"-WT-"+"%05d", newNum);
        qualityProblem.setCode(code);
        String stage = StageEnum.getDetailVerifyNameMap.get(jsonObject.getString("stage"));//获取效验阶段
        qualityProblem.setGenerateStage(stage);
        qualityProblem.setProblemDescribe(stage+"不通过");
        //获取智能监检表id(项目id和检验时间)
        Verify verify2=null;
        if (ValidationUtil.isEmpty(jsonObject.getString("manyCode"))) {
             verify2 = verifyMapper.getOnes(verify.getProjectId(), verify.getVerifyTime().toLocaleString(), jsonObject.getString("code"), null);
        } else {
            verify2 = verifyMapper.getOnes(verify.getProjectId(), verify.getVerifyTime().toLocaleString(), null, jsonObject.getString("manyCode"));
        }
        if(!ValidationUtil.isEmpty(verify2)) {
            Long sequenceNbr = verify2.getSequenceNbr();
            qualityProblem.setStageVerifyId(sequenceNbr);
        }
        qualityProblemService.save(qualityProblem);
        problemInitiationService.start(qualityProblem);
    }
    /**   cpp
     * 校验成功需要添加的数据
     * @param verify
     * @param
     */
    public void addSuccessData(Verify verify,String[] codeArray,JSONObject js){
        //效验通过状态
        verify.setStatus(VerifyEnum.已通过.getStatus());
        try {
            //智能监检管理表添加数据
          this.save(verify);
        } catch (Exception e) {
            e.printStackTrace( );
        }
        //焊口表修改状态
        if (codeArray ==null) {
            String targetInfo = verify.getTargetInfo( );
            JSONObject jsonObject = JSONObject.parseObject(targetInfo);
            String code = jsonObject.getString("code");//获取焊口编号
            // 通过焊口码和项目id查询
            if (!StringUtils.isEmpty(code)&& verify.getProjectId() !=null) {
                Weld weld=weldMapper.getWeldByCodeAndProjectId(code, verify.getProjectId());
                if (weld != null) {
                    //判断是哪一个阶段
                    String stage = verify.getStage();
                    Map<String, String> mapEnum = StageEnum.getStageByNameMap;
                    //修改的值
                    String name = mapEnum.get(stage);
                    weld.setSuperInspecStatus(name);//更改监检状态
                    try {
                        //修改
                        int i = weldMapper.updateById(weld);
                    } catch (Exception e) {
                        e.printStackTrace( );
                    }
                }
            }
        }
        if (codeArray !=null) {
            for (String code : codeArray) {
                if (!ValidationUtil.isEmpty(code)&& verify.getProjectId() !=null) {
                    Weld weld=weldMapper.getWeldByCodeAndProjectId(code, verify.getProjectId());
                    if (weld != null) {
                        //判断是哪一个阶段
                        String stage = verify.getStage( );
                        Map<String, String> mapEnum = StageEnum.getStageByNameMap;
                        //修改的值
                        String name = mapEnum.get(stage);
                        weld.setSuperInspecStatus(name);//更改监检状态
                           weldMapper.updateById(weld);
                    }
                }
            }

        }
    }
    /**
     * 弹窗
     * @param sequenceNbr
     * @return
     */
    public List<OpenDto> selectById(Long sequenceNbr ){

        Verify verify = verifyMapper.selectById(sequenceNbr);
        OpenDto openDto = new OpenDto( );
        if (verify !=null && !StringUtils.isEmpty( verify.getStatus())) {
            String targetInfo=  verify.getTargetInfo();
            JSONObject object = JSONObject.parseObject(targetInfo);
            //获取新照片
            String newPhoto = object.getString("photo");
            if (!StringUtils.isEmpty(newPhoto)) {
                openDto.setNewPhoto(newPhoto);
            }
            if (VerifyEnum.未通过.getStatus().equals(verify.getStatus())) {
                openDto.setResult(VerifyEnum.未通过.getName());
            }
            if (VerifyEnum.已通过.getStatus().equals(verify.getStatus())) {
                openDto.setResult(VerifyEnum.已通过.getName());
            }
                //有效性
                String peopleStatus = object.getString("valid");
                if (!StringUtils.isEmpty(peopleStatus)) {
                    openDto.setValid(peopleStatus);
                }
                //符合性
                String accord = object.getString("accord");
                if (!StringUtils.isEmpty(accord)) {
                    openDto.setAccord(accord);
                }
            if (StageEnum.焊前人员.getStage().equals(verify.getStage())) {
                Long welderId = object.getLong("welderId");
                if (welderId != null) {
                    openDto.setSequenceNbr(String.valueOf(welderId));
                    //焊工的老照片
                    Map map = orgService.getdetialInfo(welderId.toString( ));
                    if (!ValidationUtil.isEmpty(map)) {
                        String  image =String.valueOf(map.get("image")) ;
                        if (StringUtils.isNotEmpty(image)) {
                            JSONArray jsonArray = JSONArray.parseArray(image);
                            if (jsonArray != null && jsonArray.size()>0) {
                                for (Object o : jsonArray) {
                                    JSONObject ob = JSONObject.parseObject(o.toString( ));
                                    if (ob != null) {
                                        String url = ob.getString("url");
                                        if (!StringUtils.isEmpty(url)) {
                                            openDto.setOldPhoto(url);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (StageEnum.焊前设备.getStage().equals(verify.getStage())) {
                Long weldingId = object.getLong("weldingId");
                if (weldingId != null) {
                    openDto.setSequenceNbr(String.valueOf(weldingId));
                    String image = this.getImage(weldingId);
                    if (!ValidationUtil.isEmpty(image)) {
                        openDto.setOldPhoto(image);
                    }
                }
            }
            if (StageEnum.焊前管材质量.getStage().equals(verify.getStage())) {
                String materialCode = object.getString("materialId");//管材编号
                if (!ValidationUtil.isEmpty(materialCode)) {
                    Material material = materialService.getMaterial(materialCode);
                    if (!ValidationUtil.isEmpty(material)) {
                        Long sequenceNbr1 = material.getSequenceNbr( );//管材id
                        openDto.setSequenceNbr(String.valueOf(sequenceNbr1));
                        if (!ValidationUtil.isEmpty(sequenceNbr1)) {
                            String image = this.getImage(sequenceNbr1);
                            if (!ValidationUtil.isEmpty(image)) {
                                openDto.setOldPhoto(image);
                            }
                        }
                    }
                }
            }
        }
        ArrayList<OpenDto> list = new ArrayList<>( );
        list.add(openDto);
        return list  ;
    }
    // 图片公共方法
    public String getImage(Long id){
        String oldPhoto =null;
        if (id != null) {
            AttachmentDto enuipment = attachmentService.getAttachment(id);
            if (enuipment != null) {
                String info = enuipment.getInfo( );
                if (StringUtils.isNotEmpty(info)) {
                    JSONArray jsonArray = JSONArray.parseArray(info);
                    for (Object o : jsonArray) {
                        JSONObject object1 = JSONObject.parseObject(o.toString( ));
                        String info1 = object1.getString("info");
                        JSONArray jsonArray1 = JSONArray.parseArray(info1);
                        for (Object o1 : jsonArray1) {
                            JSONObject object2 = JSONObject.parseObject(o1.toString( ));
                            oldPhoto= object2.getString("url");
                            if (StringUtils.isNotEmpty(oldPhoto)) {
                                String[] split = oldPhoto.split(".");
                                //不区分大小写.jpe .JPE,需要转换成小写写
                                String suffix = split[split.length - 1].toLowerCase( );
                                if (suffix.contains(ImageEnum.GIF.getName()) || suffix.contains(ImageEnum.PNG.getName()) ||
                                        suffix.contains(ImageEnum.JPG.getName()) || suffix.contains(ImageEnum.JPEG.getName()) ||
                                        suffix.contains(ImageEnum.BMP.getName()) || suffix.contains(ImageEnum.PSD.getName())) {
                                   return oldPhoto;
                                }
                            }
                        }
                    }
                }
            }
        }
        return oldPhoto;
    }
    private static final String HEGE ="合格";
    private static final String NOTHEGE ="不合格";
    private static final String _id="_id";
//耐压所属焊口查看
    public JSONArray getWeldLook(Long sequenceNbr){
        JSONObject object = new JSONObject( );
        JSONArray jsonArray = new JSONArray( );
        if (sequenceNbr != null) {
            Verify verify = verifyMapper.selectById(sequenceNbr); //耐压信息
            if (verify != null ) {
                String codes = verify.getCode( );
                if (!ValidationUtil.isEmpty(codes)) {
                    String[] codeArray = codes.split(",");
                    int num =0;
                    for (String code : codeArray) {
                        //查工艺
                        object.put("code",code);

                        String targetInfo = verify.getTargetInfo( );
                        if (!ValidationUtil.isEmpty(targetInfo)) {
                            List<Verify> verifyList = verifyMapper.selectByWelder(verify.getProjectId( ), null, code, StageEnum.焊接工艺.getStage( ), null);
                            Verify verify1 = verifyList.stream( ).max((d1, d2) -> d1.getVerifyTime( ).compareTo(d2.getVerifyTime( ))).orElse(null);
                            JSONObject craftInfo=null;
                            if (verify1 != null) {
                                String status = verify.getStatus( );
                                if (VerifyEnum.已通过.getStatus().equals(status)) {
                                    object.put("craftStatus",HEGE);
                                }
                                if (VerifyEnum.未通过.getStatus().equals(status)) {
                                    object.put("craftStatus",NOTHEGE);
                                }
                                String targetInfo1 = verify1.getTargetInfo( );
                                craftInfo= JSONObject.parseObject(targetInfo1);
                                String location = (String)craftInfo.get("location");
                                object.put("location",location);
                            }
                            List<Verify> verifyPeople = verifyMapper.selectByWelder(verify1.getProjectId( ), (Long) craftInfo.get("welderId"), null, StageEnum.焊前人员.getStage( ), (Long) craftInfo.get("random"));
                            List<Verify> verifyEquipment= verifyMapper.selectByWelder(verify1.getProjectId( ), (Long) craftInfo.get("welderId"), null, StageEnum.焊前设备.getStage( ), (Long) craftInfo.get("random"));
                            List<Verify> verifyMaterial= verifyMapper.selectByWelder(verify1.getProjectId( ), (Long) craftInfo.get("welderId"), null, StageEnum.焊前管材质量.getStage( ), (Long) craftInfo.get("random"));
                            Verify vp= verifyPeople.stream( ).max((d1, d2) -> d1.getVerifyTime( ).compareTo(d2.getVerifyTime( ))).orElse(null);
                            Verify ve= verifyEquipment.stream( ).max((d1, d2) -> d1.getVerifyTime( ).compareTo(d2.getVerifyTime( ))).orElse(null);
                            Verify vm= verifyMaterial.stream( ).max((d1, d2) -> d1.getVerifyTime( ).compareTo(d2.getVerifyTime( ))).orElse(null);
                            if (vp != null) {
                                String status = vp.getStatus();
                                if (VerifyEnum.已通过.getStatus().equals(status)) {
                                    object.put("peopleStatus",HEGE);
                                }
                                if (VerifyEnum.未通过.getStatus().equals(status)) {
                                    object.put("peopleStatus",NOTHEGE);
                                }
                            }
                            if (ve != null) {
                                String status = ve.getStatus();
                                if (VerifyEnum.已通过.getStatus().equals(status)) {
                                    object.put("equipmentStatus",HEGE);
                                }
                                if (VerifyEnum.未通过.getStatus().equals(status)) {
                                    object.put("equipmentStatus",NOTHEGE);
                                }
                            }
                            if (vm != null) {
                                String status = vm.getStatus();
                                if (VerifyEnum.已通过.getStatus().equals(status)) {
                                    object.put("materialStatus",HEGE);
                                }
                                if (VerifyEnum.未通过.getStatus().equals(status)) {
                                    object.put("materialStatus",NOTHEGE);
                                }
                            }
                            object.put(_id,num+1);
                        }
                       jsonArray.add(object);
                    }
                }
            }
        }
        return jsonArray;
    }


    /**
     * 焊口定位详情查看
     */
    public JSONArray calibration(Long sequenceNbr){
        JSONArray jsonArray = new JSONArray( );
        JSONObject object = new JSONObject( );
        if (!ValidationUtil.isEmpty(sequenceNbr)){
            Verify verify = verifyMapper.selectById(sequenceNbr); //定位信息
            String codes = verify.getCode( );
            String[] split = codes.split(",");
            int num =0;
            for (String code : split) {
                object.put("code",code);
                LambdaQueryWrapper<Verify> wrapper = new LambdaQueryWrapper<>( );
                wrapper.eq(Verify::getCode,code).eq(Verify::getStage,StageEnum.焊接工艺.getStage());
                List<Verify> verifyList = verifyMapper.selectList(wrapper);
                Verify vfy= verifyList.stream( ).max((v1, v2) -> v1.getVerifyTime( ).compareTo(v2.getVerifyTime( ))).orElse(null);
                String targetInfo = vfy.getTargetInfo( );
                JSONObject jt = JSONObject.parseObject(targetInfo);
                String craftLocation = jt.getString("location");
                object.put("craftLocation",craftLocation);
                LambdaQueryWrapper<Verify> wp = new LambdaQueryWrapper<>( );
                wp.eq(Verify::getCode,code).eq(Verify::getStage,StageEnum.定位.getStage());
                List<Verify> lists = verifyMapper.selectList(wp);
                Verify verify1= lists.stream( ).max((v1, v2) -> v1.getVerifyTime( ).compareTo(v2.getVerifyTime( ))).orElse(null);
                String targetInfo1 = verify1.getTargetInfo( );
                JSONObject parseObject = JSONObject.parseObject(targetInfo1);
                String layLocation = parseObject.getString("location");
                object.put("layLocation",layLocation);
                //缺一个位置偏差计算
                object.put("offset","");
                object.put("verification","");
                object.put(_id,num+1);
                jsonArray.add(object);
            }

        }

return jsonArray;
    }
//焊口修复 (焊口信息 弹窗工艺信息)
  public Page<WeldDto> repair(Integer current ,Integer size, WeldDto weldDto){
      Page<WeldDto> objectPage1 = new Page<>( );
      List<CodeWeldDto> codeList = verifyMapper.getCode( );
      Page<Weld> objectPage = new Page<>( );
      objectPage.setCurrent(current);
      objectPage.setSize(size);
      ArrayList<WeldDto> list = Lists.newArrayList( );
      codeList.forEach(code ->{
          WeldDto weldDto1 = weldMapper.getSqe(code.getCode( ));
          list.add(weldDto1);
      });
      //分页
      List<WeldDto> collect = list.stream( ).skip((current - 1) * size).limit(size).collect(Collectors.toList( ));
      ArrayList<WeldDto> list1 = Lists.newArrayList( );
      collect.forEach(c ->{
          ProjectDto projectDto = projectServiceImpl.queryBySeq(c.getProjectId( ));
         c.setName(projectDto.getName());
         c.setRegion(projectDto.getAddress());
         c.setCodingStatus(WeldCodeEnum.map.get(c.getCodingStatus()));
         c.setCodingMethod(WeldMethodEnum.map.get(c.getCodingMethod()));
          CompanyDto companyDto = companyService.queryBySeq(c.getInstallCompany( ));
          c.setInstallationUnit(companyDto.getName());
          list1.add(c);
      });
      objectPage1.setRecords(list1);
      List<WeldDto> list2=null;
      List<WeldDto> list3=null;
      List<WeldDto> list4=null;
      if (weldDto != null) {
          if (!ValidationUtil.isEmpty(weldDto.getName())) {
              list2 = list1.stream( ).filter(weldDto1 -> weldDto1.getName( ).contains(weldDto.getName( ))).collect(Collectors.toList( ));
          }
          if (!ValidationUtil.isEmpty(weldDto.getInstallationUnit()) ) {
              list3= list1.stream( ).filter(weldDto1 -> weldDto1.getInstallationUnit().contains(weldDto.getInstallationUnit())).collect(Collectors.toList( ));
          }
          if (!ValidationUtil.isEmpty(weldDto.getName()) && !ValidationUtil.isEmpty(weldDto.getInstallationUnit())) {
              list4= list2.stream( ).filter(weldDto1 -> weldDto1.getInstallationUnit().contains(weldDto.getInstallationUnit())).collect(Collectors.toList( ));
          }
          if (!ValidationUtil.isEmpty(weldDto.getName())) {
              objectPage1.setRecords(list2);
          }
          if (!ValidationUtil.isEmpty(weldDto.getInstallationUnit())) {
              objectPage1.setRecords(list3);
          }
          if (!ValidationUtil.isEmpty(weldDto.getName()) && !ValidationUtil.isEmpty(weldDto.getInstallationUnit())) {
              objectPage1.setRecords(list4);
          }

      }
      objectPage1.setCurrent(current);
      objectPage1.setSize(size);
      return objectPage1;
    }

    //焊口修复弹窗

    public Page<TableDto> fixedPopovers(String code) {
        List<Verify> verity=null;
        if (!ValidationUtil.isEmpty(code)) {
            verity = verifyMapper.getVerity(code);
        }
        JSONArray jsonArray = new JSONArray( );
        int num=0;
        verity.forEach(v -> {
            ProjectDto projectDto = projectServiceImpl.queryBySeq(v.getProjectId( ));
            JSONObject object = new JSONObject( );
            object.put("projectName",projectDto.getName());
            object.put("pCode",projectDto.getCode());
            object.put("code",v.getCode());
            String targetInfo = v.getTargetInfo( );
            JSONObject info = JSONObject.parseObject(targetInfo);
            Long weldingId = info.getLong("weldingId");
            if (weldingId !=null) {
                EquipmentDto equipmentDto = equipmentService.queryBySeq(weldingId);
                if (equipmentDto != null) {
                    object.put("eCode",equipmentDto.getCode());
                }
            }
            object.put("carft", info.getString("craft"));
            object.put("duration",info.getString("duration"));
            object.put("location",info.getString("location"));

            String status = v.getStatus( );
            if (status.equals(VerifyEnum.已通过.getStatus())) {
                object.put("status", VerifyEnum.已通过.getName());
            }
            else if (status.equals(VerifyEnum.未通过.getStatus())) {
                object.put("status", VerifyEnum.未通过.getName());
            }
            object.put("type",TYPE);
            object.put("submitTime",v.getSubmitTime());
            object.put("verifyTime",v.getVerifyTime());
            object.put(_id,num+1);
            jsonArray.add(object);
        });
         //非逻辑,页面格式
        String js=JSONObject.toJSONString(jsonArray, SerializerFeature.WriteClassName);
        List<JSONObject> list = JSONObject.parseArray(js,JSONObject.class);
        TableDto tableDto = new TableDto( );
        DataGridMock dataGridMock = new DataGridMock( );
        dataGridMock.setDataList(list);
        dataGridMock.setTotal(list.size());
        ColModel colModel1 = new ColModel( );
        colModel1.setFid("projectName");
        colModel1.setDataIndex("projectName");
        colModel1.setName("项目名称");
        colModel1.setTitle("项目名称");
        colModel1.setType("dataGrid");
        colModel1.setKey("projectName");
        ColModel colModel2 = new ColModel( );
        colModel2.setFid("pCode");
        colModel2.setDataIndex("pCode");
        colModel2.setName("项目编号");
        colModel2.setTitle("项目编号");
        colModel2.setType("dataGrid");
        colModel2.setKey("pCode");
        ColModel colModel3 = new ColModel( );
        colModel3.setFid("code");
        colModel3.setDataIndex("code");
        colModel3.setName("焊口编号");
        colModel3.setTitle("焊口编号");
        colModel3.setType("dataGrid");
        colModel3.setKey("code");
        ColModel colModel4 = new ColModel( );
        colModel4.setFid("carft");
        colModel4.setDataIndex("carft");
        colModel4.setName("焊接工艺");
        colModel4.setTitle("焊接工艺");
        colModel4.setType("dataGrid");
        colModel4.setKey("carft");
        ColModel colModel5 = new ColModel( );
        colModel5.setFid("eCode");
        colModel5.setDataIndex("eCode");
        colModel5.setName("焊机编号");
        colModel5.setTitle("焊机编号");
        colModel5.setType("dataGrid");
        colModel5.setKey("eCode");
        ColModel colModel6 = new ColModel( );
        colModel6.setFid("duration");
        colModel6.setDataIndex("duration");
        colModel6.setName("焊接时长");
        colModel6.setTitle("焊接时长");
        colModel6.setType("dataGrid");
        colModel6.setKey("duration");

        ColModel colModel7 = new ColModel( );
        colModel7.setFid("location");
        colModel7.setDataIndex("location");
        colModel7.setName("焊接定位信息");
        colModel7.setTitle("焊接定位信息");
        colModel7.setType("dataGrid");
        colModel7.setKey("location");

        ColModel colModel8 = new ColModel( );
        colModel8.setFid("status");
        colModel8.setDataIndex("status");
        colModel8.setName("检验状态");
        colModel8.setTitle("检验状态");
        colModel8.setType("dataGrid");
        colModel8.setKey("status");

        ColModel colModel9= new ColModel( );
        colModel9.setFid("type");
        colModel9.setDataIndex("type");
        colModel9.setName("检验方式");
        colModel9.setTitle("检验方式");
        colModel9.setType("dataGrid");
        colModel9.setKey("type");
        ColModel colModel10= new ColModel( );
        colModel10.setFid("type");
        colModel10.setDataIndex("type");
        colModel10.setName("检验方式");
        colModel10.setTitle("检验方式");
        colModel10.setType("dataGrid");
        colModel10.setKey("type");

        ColModel colModel11= new ColModel( );
        colModel11.setFid("submitTime");
        colModel11.setDataIndex("submitTime");
        colModel11.setName("交检日期");
        colModel11.setTitle("交检日期");
        colModel11.setType("dataGrid");
        colModel11.setKey("submitTime");
        ColModel colModel12= new ColModel( );
        colModel12.setFid("verifyTime");
        colModel12.setDataIndex("verifyTime");
        colModel12.setName("检验时间");
        colModel12.setTitle("检验时间");
        colModel12.setType("dataGrid");
        colModel12.setKey("verifyTime");
        ArrayList<ColModel> list1 = Lists.newArrayList( );
        list1.add(colModel1);
        list1.add(colModel2);
        list1.add(colModel3);
        list1.add(colModel4);
        list1.add(colModel5);
        list1.add(colModel6);
        list1.add(colModel7);
        list1.add(colModel8);
        list1.add(colModel9);
        list1.add(colModel10);
        list1.add(colModel11);
        list1.add(colModel12);
        tableDto.setDataGridMock(dataGridMock);
        tableDto.setColModel(list1);
        ArrayList<TableDto> list2 = Lists.newArrayList( );
        list2.add(tableDto);
        Page<TableDto> objectPage1 = new Page<>( );
        objectPage1.setRecords(list2);
       return objectPage1 ;
    }



    public String getMaterialCodeByOcr(String urlPath){
        JSONObject param = new JSONObject();
        JSONArray urls = new JSONArray();
        JSONObject url = new JSONObject();
        url.put("url", urlPath);
        urls.add(url);
        param.put("data", urls);
        ResponseModel<Object> result = maasServiceFeignClient.execProcessApiByServiceId(param);
        String resultStr = JSONObject.parseObject(JSONObject.toJSONString(result.getResult())).getJSONObject("result1").getJSONArray("rows").getJSONObject(0).getString("ocrResult");
        return resultStr;
    }
}
