package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.QRCodeUtil;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.ugp.api.Enum.*;
import com.yeejoin.amos.boot.module.ugp.api.dto.*;
import com.yeejoin.amos.boot.module.ugp.api.entity.*;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.SuperviseRuleMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.VerifyMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.WeldMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IWeldService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.compress.utils.Lists;
import org.apache.http.entity.ContentType;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 焊口信息表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public
class WeldServiceImpl extends BaseService<WeldDto, Weld, WeldMapper> implements IWeldService {

    @Autowired
    WeldMapper weldMapper;
    @Autowired
    ProjectMapper projectMapper;
    @Autowired
    OrgServiceImpl orgService;
    @Autowired
    SuperviseRuleMapper superviseRuleMapper;
    @Autowired
    ProjectResourceServiceImpl projectResourceService;
    @Autowired
    VerifyMapper verifyMapper;
    @Autowired
    ProjectInitiationServiceImpl projectInitiationService;

    @Autowired
    OrgUsrServiceImpl orgUsrServiceImpl;

    @Autowired
    ProjectServiceImpl projectService;

    @Autowired
    VerifyServiceImpl verifyService;


//    Logger logger = LoggerFactory.getLogger(WeldServiceImpl.class);

//    private final String 安装单位="INSTALL";
//
//    private final String 监察单位="SUPERVISION";
    /**
     * 分页查询(安装单位管理员只能查看本单位项目所有焊口信息。
     *         监检机构管理员可查看所有项目焊口信息。)
     */
    public IPage<WeldDto> queryForWeldPage(int current, int size, WeldDto weldDto) {
        IPage<WeldDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        //获取当前登陆人下的项目id
        List<Project> projectList = projectResourceService.getProjectList();

        Set<String> codes = new HashSet<>();
        for (Project project : projectList) {
            codes.add(project.getSequenceNbr().toString());
        }
        //获取焊口数据
        IPage<WeldDto> weldDtoIPage = weldMapper.queryForWeldPage(page, codes, weldDto);
        //页面回显
        for (WeldDto weld : weldDtoIPage.getRecords()) {

            weld.setCodingStatus(WeldCodeEnum.map.get(weld.getCodingStatus()));
            weld.setCodingMethod(WeldMethodEnum.map.get(weld.getCodingMethod()));
        }
//        Page<WeldDto> weldDtoPage = this.queryForPage(page, null, false);
//
//        for (WeldDto weldDto : weldDtoPage.getRecords()) {
//            QueryWrapper<Project> wrapper = new QueryWrapper<>();
//            wrapper.eq("sequence_nbr", weldDto.getProjectId());
//            Project project = projectMapper.selectOne(wrapper);
//            weldDto.setName(project.getName());
//
//            QueryWrapper<Project> wrapperUnit = new QueryWrapper<>();
//            wrapperUnit.eq("installation_unit_id", weldDto.getInstallCompany());
//
//            List<Project> projects = projectMapper.selectList(wrapperUnit);
//            for (Project project1 : projects) {
//                weldDto.setInstallationUnit(project1.getInstallationUnit());
//                weldDto.setCodingStatus(WeldCodeEnum.map.get(weldDto.getCodingStatus()));
//                weldDto.setCodingMethod(WeldMethodEnum.map.get(weldDto.getCodingMethod()));
//            }
//
//        }
//
//        //获取登录人信息
//        OrgUsr orgUsr = orgService.getOrgUsr();
//        //获取登录人企业下的所有焊口
//        if (orgUsr.getOrgExpandAttr1().equals(安装单位)) {
//
//            List<WeldDto> L = weldDtoPage.getRecords().stream().filter(b -> b.getInstallCompany().equals(orgUsr.getParentId())).collect(Collectors.toList());
//            weldDtoPage.setRecords(L);
//        }
//
//        //根据 所在地 筛选焊口
//        if (orgUsr.getOrgExpandAttr1().equals(监察单位)) {
//
//            LambdaQueryWrapper<SuperviseRule> wrapper = new LambdaQueryWrapper<>();
//            LambdaQueryWrapper<SuperviseRule> eq = wrapper.eq(SuperviseRule::getSuperviseDeptId, orgUsr.getParentId());
//            List<SuperviseRule> superviseRules = superviseRuleMapper.selectList(eq);
//            for (SuperviseRule i : superviseRules)
//            {
//
//                List<WeldDto> L = weldDtoPage.getRecords().stream().filter(b -> b.getRegion().equals(i.getAdminRegion())).collect(Collectors.toList());
//                weldDtoPage.setRecords(L);
//            }
//        }
        return weldDtoIPage;
    }

    /**
     * 更新焊口编码任务状态
     */
    public String updateTask(Weld weld) {
        LambdaQueryWrapper<Weld> wrapper = new LambdaQueryWrapper<>();
        //根据焊口编码修改任务状态
        wrapper.eq(Weld::getCode, weld.getCode());
        int update = weldMapper.update(weld, wrapper);

        return "成功更新" + update + "条";

    }



    /**
     * 列表查询 示例
     */
    public List<WeldDto> queryForWeldList() {
        return this.queryForList("", false);
    }

    /**
     * 生成焊口编号保存并查询
     */
    // 静态变量存储最大值
    private static final AtomicInteger atomicNum = new AtomicInteger();
    // 初始化编号
    private final int INIT_CODE_NUM = 0;
    private final String FIRST_CHARACTER = "-HK";

    public synchronized List<Weld> getCode(Long sequenceNbr, int number) {

        List<Weld> welds = new ArrayList<>();
        Project project = projectMapper.selectById(sequenceNbr);
        QueryWrapper<Weld> wrapper = new QueryWrapper<>();
        //根据seq查询条件判断是否已经存在该项目的该焊口编码
        wrapper.eq("project_id", sequenceNbr).orderByDesc("code").last("limit 1");
        Weld weld1 = weldMapper.selectOne(wrapper);

        if (weld1 != null) {
            //存在时取后四位
            String substring = weld1.getCode().substring(weld1.getCode().length() - 4, weld1.getCode().length());
            atomicNum.set(Integer.parseInt(substring));
        } else {
            //不存在时将atomicNum初始化
            atomicNum.set(INIT_CODE_NUM);
        }
        for (int i = 0; i < number; i++) {
            Weld weld = new Weld();
            //生成四位数
            String i1 = String.format("%04d", atomicNum.incrementAndGet());
            //生成编码
            String code = (project.getCode()) + FIRST_CHARACTER + i1;
            weld.setRegion(project.getAddress());
            weld.setProjectId(Long.valueOf(project.getSequenceNbr()));
            weld.setInstallCompany(project.getInstallationUnitId());
            weld.setCode(code);
            weld.setRegion(project.getInstallRegionCode());
            weld.setCodingMethod(WeldMethodEnum.自动赋码.getState());
            weld.setCodingStatus(WeldCodeEnum.已赋值.getState());
            weld.setCodingDate(new Date());
            welds.add(weld);
        }
        saveBatch(welds);
        return welds;
    }


    /**
     * 根据焊口编码获取焊口信息
     */
    public Weld getWeldInfo( String code){
        LambdaQueryWrapper<Weld> wrapper = new LambdaQueryWrapper<>();
        LambdaQueryWrapper<Weld> eq = wrapper.eq(Weld::getCode, code);
        Weld weld = weldMapper.selectOne(eq);
        return weld;
    }

    /**
     * 通过项目id获取数据
     * @param projectId
     * @return
     */
    public List<WeldDto> getProjectId(Long projectId){
        return weldMapper.select(projectId);
    }

    /**
     * 通过项目id获取焊口编码
     */
    public IPage<Weld> lookCode(long current,long size,String projectId){
        IPage<Weld> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        LambdaQueryWrapper<Weld> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Weld::getProjectId,projectId);
        IPage<Weld> weldPage = this.page(page,wrapper);
        return weldPage;
    }

    public IPage<WeldDto> getWeldInfoByProjectId(long current,long size,String projectId){
        IPage<Weld> weldPage = lookCode(current,size,projectId);
        List<WeldDto> weldDtos = getWeldVerify(weldPage);
        IPage<WeldDto> page = new Page<>();
        BeanUtils.copyProperties(weldPage, page);
        page.setRecords(weldDtos);
        return page;
    }

    public List<WeldDto> getWeldVerify(IPage<Weld> weldPage){
        List<Weld> weldList = weldPage.getRecords();
        List<WeldDto> weldDtos = new ArrayList<>();
        for(Weld weld : weldList){
            WeldDto weldDto = new WeldDto();
            BeanUtils.copyProperties(weld, weldDto);
            String weldCode = weld.getCode();
            LambdaQueryWrapper<Verify> wapper = new LambdaQueryWrapper<>();
            wapper.eq(Verify::getCode,weldCode);
            List<Verify> verifyList = verifyService.list(wapper);
            for (Verify verify : verifyList) {
                if(StageEnum.焊前人员.getStage().equals(verify.getStage())){
                    weldDto.setWelderVerify("详情");
                    weldDto.setWelderVerifyID(verify.getSequenceNbr());
                    weldDto.setWelderVerifyColor(ColorEnum.green.getColor());
                    if(VerifyEnum.未通过.getStatus().equals(verify.getStatus())){
                        weldDto.setWelderVerifyColor(ColorEnum.red.getColor());
                    }
                }
                if(StageEnum.焊前管材质量.getStage().equals(verify.getStage())){
                    weldDto.setMaterialVerify("详情");
                    weldDto.setMaterialVerifyID(verify.getSequenceNbr());
                    weldDto.setMaterialVerifyColor(ColorEnum.green.getColor());
                    if(VerifyEnum.未通过.getStatus().equals(verify.getStatus())){
                        weldDto.setMaterialVerifyColor(ColorEnum.red.getColor());
                    }
                }
                if(StageEnum.焊接工艺.getStage().equals(verify.getStage())){
                    weldDto.setCraftVerify("详情");
                    weldDto.setCraftVerifyID(verify.getSequenceNbr());
                    weldDto.setCraftVerifyColor(ColorEnum.green.getColor());
                    if(VerifyEnum.未通过.getStatus().equals(verify.getStatus())){
                        weldDto.setCraftVerifyColor(ColorEnum.red.getColor());
                    }
                }
                if(StageEnum.管道耐压.getStage().equals(verify.getStage())){
                    weldDto.setVoltageVerify("详情");
                    weldDto.setVoltageVerifyID(verify.getSequenceNbr());
                    weldDto.setVoltageVerifyColor(ColorEnum.green.getColor());
                    if(VerifyEnum.未通过.getStatus().equals(verify.getStatus())){
                        weldDto.setVoltageVerifyColor(ColorEnum.red.getColor());
                    }
                }
                if(StageEnum.敷设质量.getStage().equals(verify.getStage())){
                    weldDto.setLayVerify("详情");
                    weldDto.setLayVerifyID(verify.getSequenceNbr());
                    weldDto.setLayVerifyColor(ColorEnum.green.getColor());
                    if(VerifyEnum.未通过.getStatus().equals(verify.getStatus())){
                        weldDto.setLayVerifyColor(ColorEnum.red.getColor());
                    }
                }
                if(StageEnum.定位.getStage().equals(verify.getStage())){
                    weldDto.setLotcationVerify("详情");
                    weldDto.setLotcationVerifyID(verify.getSequenceNbr());
                    weldDto.setLotcationVerifyColor(ColorEnum.green.getColor());
                    if(VerifyEnum.未通过.getStatus().equals(verify.getStatus())){
                        weldDto.setLotcationVerifyColor(ColorEnum.red.getColor());
                    }
                }
            }
            weldDtos.add(weldDto);
        }
        return weldDtos;
    }

    /**
     * 通过项目id获取焊口智能监验信息

     */
    public WeldVerifyDto selectStatus(Long projectId,String code){
        LambdaQueryWrapper<Project> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Project::getSequenceNbr,projectId);
        Project project = projectMapper.selectOne(wrapper);
        WeldVerifyDto weldVerifyDtos = new WeldVerifyDto();
        weldVerifyDtos.setName(project.getName());
        weldVerifyDtos.setCode(project.getCode());
        weldVerifyDtos.setInstallRegion(project.getInstallRegion());
        LambdaQueryWrapper<Verify> wrapper1 = new LambdaQueryWrapper<>();
        wrapper1.eq(Verify::getProjectId,projectId)
                .eq(Verify::getCode,code)
                .groupBy(Verify::getStage)
                .orderByDesc(Verify::getRecDate);
        List<Verify> verifyList = verifyMapper.selectList(wrapper1);
        for(Verify verify : verifyList){
            if("1".equals(verify.getStatus())){
                if(StageEnum.定位.getStage().equals(verify.getStage())){
                    weldVerifyDtos.setLocationStatus("合格");
                }
                if(StageEnum.管道耐压.getStage().equals(verify.getStage())){
                    weldVerifyDtos.setVoltageStatus("合格");
                }
                if(StageEnum.敷设质量.getStage().equals(verify.getStage())){
                    weldVerifyDtos.setLayStatus("合格");
                }
                if(StageEnum.焊接工艺.getStage().equals(verify.getStage())){
                    weldVerifyDtos.setCraftStatus("合格");
                }
            } else if("0".equals(verify.getStatus())){
                if(StageEnum.定位.getStage().equals(verify.getStage())){
                    weldVerifyDtos.setLocationStatus("不合格");
                }
                if(StageEnum.管道耐压.getStage().equals(verify.getStage())){
                    weldVerifyDtos.setVoltageStatus("不合格");
                }
                if(StageEnum.敷设质量.getStage().equals(verify.getStage())){
                    weldVerifyDtos.setLayStatus("不合格");
                }
                if(StageEnum.焊接工艺.getStage().equals(verify.getStage())){
                    weldVerifyDtos.setCraftStatus("不合格");
                }
            }
        }
        return weldVerifyDtos;
    }

    /**
     *      检验责任单位及监检状态
     */
    public WeldDto selectDept(String projectId){
        LambdaQueryWrapper<Project> wrapper = new LambdaQueryWrapper<>();
        Project project = projectMapper.selectOne(wrapper.eq(Project::getSequenceNbr,projectId));
        LambdaQueryWrapper<SuperviseRule> wrapper1 = new LambdaQueryWrapper<>();
        WeldDto weldDtos = new WeldDto();
        if(!ValidationUtil.isEmpty(project.getInstallRegionCode())){
            SuperviseRule superviseRule = superviseRuleMapper.selectOne( wrapper1.eq(SuperviseRule::getAdminRegionCode,project.getInstallRegionCode()));
            OrgUsr orgUsr = orgService.getOrgUsrById(String.valueOf(superviseRule.getSuperviseDeptId()));
            weldDtos.setSuperviseDept(orgUsr.getBizOrgName());
        }
        LambdaQueryWrapper<ProjectInitiation> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(ProjectInitiation::getInstanceId,project.getInstanceId())
                .groupBy(ProjectInitiation::getTaskName)
                .orderByDesc(ProjectInitiation::getRecDate);
        List<ProjectInitiation> projectInitiations = projectInitiationService.list(wrapper2);
        for(ProjectInitiation projectInitiation:projectInitiations){
            String context = projectInitiation.getContext();
            JSONObject jsonObject = (JSONObject) JSONObject.parse(context);
            if(ProjectInitiationEnum.监检员分配.getName().equals(projectInitiation.getTaskName())){
                weldDtos.setInsPerson(jsonObject.getString("insPerson"));
            }
            if(ProjectInitiationEnum.监检科室分配.getName().equals(projectInitiation.getTaskName())){
                weldDtos.setInsDep(jsonObject.getString("insDep"));
            }
        }
        return weldDtos;
    }


    /**
     * 获取焊口编号
     * @return
     */
    public IPage getWeldQRCode(String HKCode){
        String url = "";
        JSONObject jsonObject = new JSONObject();
        byte[] bytes = QRCodeUtil.generateQRCodeImageByteData(HKCode,200);
        InputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            MultipartFile file = new MockMultipartFile(HKCode+".jpg",HKCode+".jpg", ContentType.APPLICATION_OCTET_STREAM.toString(), inputStream);
            FeignClientResult<Map<String, String>> date = Systemctl.fileStorageClient.updateCommonFileFree(file, "ugp/qrcode");
            if (date != null) {
                Map<String, String> map = date.getResult();
                Iterator<String> it = map.keySet().iterator();
                String urlString=it.next();
                jsonObject.put("fileUrl", urlString);
                jsonObject.put("fileName", HKCode);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        List list = new ArrayList();
        list.add(jsonObject);
        IPage page = new Page(1,100);
        page.setRecords(list);
        return page;
    }

    public List<List<Double>> getWeldCode(String projectId){
        LambdaQueryWrapper<Weld> wrapper = new LambdaQueryWrapper();
        wrapper.eq(Weld::getProjectId,projectId);
        List<Weld> weldList = weldMapper.selectList(wrapper);
        ArrayList<List<Double>> list = Lists.newArrayList();
        for(Weld weld : weldList){
            if(!ValidationUtil.isEmpty(weld.getLatitude()) && !ValidationUtil.isEmpty(weld.getLongitude())) {
                ArrayList<Double> objects = Lists.newArrayList();
                objects.add(Double.valueOf(weld.getLongitude()));
                objects.add(Double.valueOf(weld.getLatitude()));
                list.add(objects);
            }
        }
        return list;
    }

    /**
     * 根据地图经纬度信息获取项目id
     * @param obj
     * @param obj
     * @return
     */

    public List<ProjectDto> getWeldListByLocation(Object obj){
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(obj));
        JSONObject left = jsonObject.getJSONObject("northeast");
        JSONObject right = jsonObject.getJSONObject("southwest");
        Double leftLongitude = left.getDouble("longitude");
        Double leftLatitude = left.getDouble("latitude");
        Double rightLongitude = right.getDouble("longitude");
        Double rightLatitude = right.getDouble("latitude");
        List<ProjectDto> projectList = projectService.getProjectLocation();
        List<String> projectIds = new ArrayList<>();
        List<ProjectDto> projectDtos = new ArrayList<>();
        List<Weld> weldList = new ArrayList<>();
        for(ProjectDto projectDto:projectList){
            if(!ValidationUtil.isEmpty(projectDto.getLatitude()) && !ValidationUtil.isEmpty(projectDto.getLongitude())) {
                Double longitude = Double.valueOf(projectDto.getLongitude());
                Double latitude = Double.valueOf(projectDto.getLatitude());
                if (rightLongitude < longitude && longitude < leftLongitude && rightLatitude < latitude && latitude < leftLatitude) {
                    projectDtos.add(projectDto);
                }
            }
        }
        for(ProjectDto projectDto : projectDtos){
            projectDto.setWeldList(this.list(new LambdaQueryWrapper<Weld>().eq(Weld::getProjectId,projectDto.getSequenceNbr())));
            projectDto.setWeldLines(getWeldCode(String.valueOf(projectDto.getSequenceNbr())));
        }
        return projectDtos;
    }

}