package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.DynamicFormGroup;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import com.yeejoin.equipmanage.common.utils.StringUtil;
import com.yeejoin.equipmanage.service.IEqDynamicFormGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;


/**
 * 动态表单树形分组表
 *
 * @author duanwei
 * @date 2021-03-08
 */
@RestController
@Api(tags = "动态表单树形分组表Api")
@RequestMapping(value = "/dynamic-form-group", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EquipDynamicFormGroupController extends AbstractBaseController {

    @Autowired
    IEqDynamicFormGroupService iEqDynamicFormGroupService;


    /**
     * 新增动态表单树形分组表
     *
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "新增动态表单树形分组表", notes = "新增动态表单树形分组表")
    public DynamicFormGroup saveDynamicFormGroup(@RequestBody DynamicFormGroup dynamicFormGroup) {
        String orgCode = getOrgCode();
        dynamicFormGroup.setOrgCode(orgCode);
        dynamicFormGroup.setParentId(0L);
        iEqDynamicFormGroupService.saveAndCheck(dynamicFormGroup);
        return dynamicFormGroup;
    }

    /**
     * 根据id删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/", method = RequestMethod.DELETE)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(@RequestBody List<Long> ids) {
        return iEqDynamicFormGroupService.checkAndRemoveById(ids);
    }


    /**
     * 修改动态表单树形分组表
     *
     * @return
     */
    @RequestMapping(value = "/updateById/{id}", method = RequestMethod.PUT)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "修改动态表单树形分组表", notes = "修改动态表单树形分组表")
    public DynamicFormGroup updateByIdDynamicFormGroup(@PathVariable Long id, @RequestBody DynamicFormGroup dynamicFormGroup) {
        String orgCode = getOrgCode();
        DynamicFormGroup formGroup = iEqDynamicFormGroupService.getById(id);
        formGroup.setGroupCode(dynamicFormGroup.getGroupCode());
        formGroup.setGroupType(dynamicFormGroup.getGroupType());
        formGroup.setGroupName(dynamicFormGroup.getGroupName());
        formGroup.setOrgCode(orgCode);
        formGroup.setCreateDate(new Date());
        iEqDynamicFormGroupService.updateById(formGroup);
        return formGroup;
    }


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public DynamicFormGroup selectById(HttpServletRequest request, @PathVariable Long id) {
        return iEqDynamicFormGroupService.getById(id);
    }

    /**
     * 按照组织机构查询分组
     *
     * @return 查询分组
     */
    @GetMapping("/list")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询分组不分页", notes = "查询分组不分页")
    public List<DynamicFormGroup> getGroupList() {
        String orgCode = getOrgCode();
        return iEqDynamicFormGroupService.list(new LambdaQueryWrapper<DynamicFormGroup>()
                .eq(DynamicFormGroup::getOrgCode, orgCode)
                .eq(DynamicFormGroup::getParentId,0)
                .orderByDesc(BaseEntity::getCreateDate));
    }

    @GetMapping("/page-list")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "一级分组分页查询",notes = "一级分组分页查询")
    public IPage getPageList(
            @RequestParam long current,
            @RequestParam long size,
            @RequestParam String groupType,
            @RequestParam(required = false) String systemName){
        return iEqDynamicFormGroupService.page(new Page<>(current,size), new LambdaQueryWrapper<DynamicFormGroup>()
                .eq(DynamicFormGroup::getGroupType,groupType)
                .eq(DynamicFormGroup::getParentId,0)
                .like(StringUtil.isNotEmpty(systemName),DynamicFormGroup::getGroupName,systemName));

    }

}


