package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.hygf.api.dto.PowerCurveDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.ReviewDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpStation;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpStationMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IJpStationService;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpStationDto;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.MonthPowerMapper;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 第三方场站服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class JpStationServiceImpl extends BaseService<JpStationDto,JpStation,JpStationMapper> implements IJpStationService {

    @Autowired
    JpStationMapper jpStationMapper;
    @Autowired
    MonthPowerMapper monthPowerMapper;
    @Autowired
    MonthPowerServiceImpl monthPowerServiceImpl;
    /**
     * 分页查询
     */
    public Page<JpStationDto> queryForJpStationPage(int pageNum, int pageSize, JpStationDto reviewDto)   {
        PageHelper.startPage(pageNum, pageSize);
        List<JpStationDto> list = jpStationMapper.queryForDealerReviewPage(reviewDto);
        PageInfo<JpStationDto> page = new PageInfo(list);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<JpStationDto> pagenew = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<JpStationDto>();
        pagenew.setCurrent(pageNum);
        pagenew.setTotal(page.getTotal());
        pagenew.setSize(pageSize);
        pagenew.setRecords(page.getList());
        return pagenew;
    }
    @Async
    public void getMonthPower() {
        monthPowerServiceImpl.getMonthPower();
    }




    @Override
    public  Map<String, List<Object>> getPowerqx(String date, String type,List<String> statioId) {
        List<PowerCurveDto>  data=null;
        List<Object> listx =new  ArrayList<>();
        List<Object> listy =new ArrayList<>();
        Map<String, List<Object>> map =new HashMap<>();
        try {

            if(type.equals("day")){
                map= gethourList();
                data =monthPowerMapper.getDayPowercount(date, statioId);
            }else if(type.equals("month")){
                map= getDayListOfMonth(date);
                data=monthPowerMapper.getMonthPower(date, statioId);

            }else if(type.equals("year")){
                map= getyearListOfMonth(date);
                data= monthPowerMapper.getYearPower(date,statioId);
            }else{
                map= getyearList();
                data= monthPowerMapper.getAllPower(date, statioId);
            }

            listx =map.get("x");
            listy =map.get("y");
            if(data!=null&&!data.isEmpty()){
                for (PowerCurveDto datum : data) {
                    for (int i = 0; i < listx.size(); i++) {
                       if(datum.getDate().equals(listx.get(i).toString())){
                           listy.remove(i);
                           String format = datum.getNum()!=null?new DecimalFormat("#.000").format(datum.getNum()):"0";
                           listy.add(i,format);
                           break;
                       }
                    }
                }
            }
            map.put("x",listx);
            map.put("y",listy);

        } catch (Exception e) {
            e.printStackTrace();
            throw  new RuntimeException("系统异常！");
        }

        return map;
    }











    public static  Map<String,  List<Object>> getDayListOfMonth(String date) {
        Map<String,  List<Object>> map =new HashMap<>();
        try {
            List<Object> listx =new  ArrayList<>();
            List<Object> listy =new ArrayList<>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date dat = sdf.parse(date);
            Calendar aCalendar = Calendar.getInstance();
            aCalendar.setTime(dat);
            int month = aCalendar.get(Calendar.MONTH) + 1;//月份
            int day = aCalendar.getActualMaximum(Calendar.DATE);
            for (int i = 1; i <= day; i++) {
                String aDate =null;
                if(i<10){
                    aDate = date+"-0"+i;
                }else{
                    aDate = date+"-"+i;
                }

                listx.add(aDate);
                listy.add(0);
            }
            map.put("x",listx);
            map.put("y",listy);
        }catch (Exception e){
            e.printStackTrace();
            throw  new RuntimeException("系统异常！");
        }
        return map;
    }
    public static  Map<String,  List<Object>> getyearListOfMonth(String date) {
        Map<String,  List<Object>> map =new HashMap<>();
        List<Object> listx =new  ArrayList<>();
        List<Object> listy =new ArrayList<>();
        for (int i = 1; i <= 12; i++) {
            String aDate =null;
            if(i<10){
                 aDate = date+"-0"+i;
            }else{
                aDate = date+"-"+i;
            }

            listx.add(aDate);
            listy.add(0);
        }
        map.put("x",listx);
        map.put("y",listy);
        return map;
    }

    public static  Map<String,  List<Object>> getyearList() {
        Map<String,  List<Object>> map =new HashMap<>();
        List<Object> listx =new  ArrayList<>();
        List<Object> listy =new ArrayList<>();
        Calendar aCalendar = Calendar.getInstance(Locale.CHINA);
        int year = aCalendar.get(Calendar.YEAR);//年份
        for (int i = 1; i <= 10; i++) {
            int aDate = year-(10-i);
            listx.add(String.valueOf(aDate));
            listy.add(0);
        }
        map.put("x",listx);
        map.put("y",listy);
        return map;
    }

    public static  Map<String,  List<Object>> gethourList() {
        Map<String,  List<Object>> map =new HashMap<>();
        List<Object> listx =new  ArrayList<>();
        List<Object> listy =new ArrayList<>();
        try {
            ArrayList<String> dates = new ArrayList<String>();
            for (int i = 0; i < 24; i++) {
                String s1 =i+":00";
                listx.add(s1);
                listy.add(0);
            }

        }catch (Exception e){
            e.printStackTrace();
            throw  new RuntimeException("系统异常！");
        }
        map.put("x",listx);
        map.put("y",listy);
        return map;
    }


}