package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IndicatorData;
import com.yeejoin.amos.boot.module.jxiop.biz.kafka.FanConditionVariablesMessage;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanHealthIndexMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.IndicatorDataMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

import static com.yeejoin.amos.boot.module.jxiop.biz.kafka.Constant.*;

@RestController
@Api(tags = "智能分析")
@RequestMapping(value = "/kafkaAnalyse")
public class KafkaAnalyseController {

    @Autowired
    FanConditionVariablesMessage fanConditionVariablesMessage;

    @Autowired
    RedisUtils redisUtils;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getFanConditionVariables")
    @ApiOperation(httpMethod = "POST", value = "计算相关性分析 - 风机 - 新", notes = "计算相关性分析 - 风机 - 新")
    public ResponseModel<Object> getFanConditionVariables() {
        if (redisUtils.hasKey(kafkaTopicConsumer)) {
            return ResponseHelper.buildResponse("计算中");
        }
        fanConditionVariablesMessage.getFanConditionVariables();
        redisUtils.set(kafkaTopicConsumer, RequestContext.getTraceId(), 300);
        return ResponseHelper.buildResponse("开始计算");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getPvConditionVariables")
    @ApiOperation(httpMethod = "POST", value = "计算相关性分析 - 光伏 - 新", notes = "计算相关性分析 - 光伏 - 新")
    public ResponseModel<Object> getPvConditionVariables() {
        if (redisUtils.hasKey(kafkaTopicConsumerPv)) {
            return ResponseHelper.buildResponse("计算中");
        }
        fanConditionVariablesMessage.getPvConditionVariables();
        redisUtils.set(kafkaTopicConsumerPv, RequestContext.getTraceId(), 300);
        return ResponseHelper.buildResponse("开始计算");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getFanConditionVariablesGKHF")
    @ApiOperation(httpMethod = "POST", value = "工况划分 - 风电 - 新", notes = "工况划分 - 风电 - 新")
    public ResponseModel<Object> getFanConditionVariablesGKHF() {
        if (redisUtils.hasKey(kafkaTopicConsumerGKHFFan)) {
            return ResponseHelper.buildResponse("计算中");
        }
        fanConditionVariablesMessage.getFanConditionVariablesGKHF();
        redisUtils.set(kafkaTopicConsumerGKHFFan, RequestContext.getTraceId(), 300);
        return ResponseHelper.buildResponse("开始计算");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getPvConditionVariablesPvGKHF")
    @ApiOperation(httpMethod = "POST", value = "工况划分 - 光伏 - 新", notes = "工况划分 - 光伏 - 新")
    public ResponseModel<Object> getPvConditionVariablesPvGKFX() {
        if (redisUtils.hasKey(kafkaTopicConsumerGKHFPv)) {
            return ResponseHelper.buildResponse("计算中");
        }
        fanConditionVariablesMessage.getPvConditionVariablesPvGKFX();
        redisUtils.set(kafkaTopicConsumerGKHFPv, RequestContext.getTraceId(), 300);
        return ResponseHelper.buildResponse("开始计算");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getFanConditionVariablesZXZ")
    @ApiOperation(httpMethod = "POST", value = "中心值 - 风电 - 新", notes = "中心值 - 风电 - 新")
    public ResponseModel<Object> getFanConditionVariablesZXZ() {
        if (redisUtils.hasKey(kafkaTopicConsumerZXZFan)) {
//            redisUtils.del(kafkaTopicConsumerZXZFan);
//            redisUtils.getExpire(kafkaTopicConsumerZXZFan);
            return ResponseHelper.buildResponse("计算中");
        }
        fanConditionVariablesMessage.getFanConditionVariablesZXZ();
        redisUtils.set(kafkaTopicConsumerZXZFan, RequestContext.getTraceId(), 300);
        return ResponseHelper.buildResponse("开始计算");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getPvConditionVariablesZXZ")
    @ApiOperation(httpMethod = "POST", value = "中心值 - 光伏 - 新", notes = "工况划分 - 光伏 - 新")
    public ResponseModel<Object> getPvConditionVariablesZXZ() {
        if (redisUtils.hasKey(kafkaTopicConsumerZXZPv)) {
//            redisUtils.del(kafkaTopicConsumerZXZPv);
            return ResponseHelper.buildResponse("计算中");
        }
        fanConditionVariablesMessage.getPvConditionVariablesZXZ();
        redisUtils.set(kafkaTopicConsumerZXZPv, RequestContext.getTraceId(), 300);
        return ResponseHelper.buildResponse("开始计算");
    }













    @Autowired
    IndicatorDataMapper indicatorDataMapper;

    @Autowired
    IdxBizFanHealthIndexMapper idxBizFanHealthIndexMapper;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/getAddressInfo")
    @ApiOperation(httpMethod = "GET", value = "getAddressInfo", notes = "getAddressInfo")
    public ResponseModel<List<IndicatorData>> getAddressInfo() {

        List<String> addressInfo = idxBizFanHealthIndexMapper.getAddressInfo();
        String join = String.join(",", addressInfo);
        List<IndicatorData> indicatorData = indicatorDataMapper.selectByAddresses(join, "1668801435891929089");
        return ResponseHelper.buildResponse(indicatorData);
    }

}
