package com.yeejoin.amos.boot.module.jxiop.biz.tdmapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IndicatorData;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IndicatorDataMapper extends BaseMapper<IndicatorData> {

    @Select("select `value`, created_time as createdTime, `value_f` as valueF from iot_data.indicator_data where address=#{address} and  created_time >= #{startTime} and created_time <= #{endTime} and gateway_id =#{gatewayId}")
    List<IndicatorData>   selectDataByAddressAndtime(@Param("address")String address,@Param("startTime") String startTime, @Param("endTime")String endTime, @Param("gatewayId")String gatewayId);


    @Select("select `unit` from iot_data.indicator_data where address=#{address} and gateway_id =#{gatewayId} limit 1")
    IndicatorData selectUnitByAddressAndGatewayId(@Param("address")String address, @Param("gatewayId")String gatewayId);


    @Select("select `value`, created_time as createdTime, `value_f` as valueF, `address`, gateway_id as gatewayId from iot_data.indicator_data where  created_time >= #{startTime} and created_time <= #{endTime} and ((gateway_id =#{gatewayId} and address=#{address}) or (gateway_id =#{gatewayId1} and address=#{address1})) ")
    List<IndicatorData>   selectDataByAddressAndtimeNew(@Param("address")String address,@Param("startTime") String startTime, @Param("endTime")String endTime, @Param("gatewayId")String gatewayId, @Param("gatewayId1")String gatewayId1, @Param("address1")String address1);


    @Select("select `value` from iot_data.indicator_data where id =#{id}")
    List<IndicatorData> selectDataById (@Param("id")String id);


    @Select("select `id`,  `value` from iot_data.indicator_data where `address` in (${addresses}) and gateway_id = #{gatewayId}")
    List<IndicatorData> selectByAddresses(@Param("addresses") String addresses, @Param("gatewayId") String gatewayId);

}
