package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.yeejoin.amos.boot.module.jxiop.api.dto.PersonDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationBasicDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.UserMapperDto;
import com.yeejoin.amos.boot.module.jxiop.api.feign.McbWarningFeign;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.PersonBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationQrCodeStatisticsMapper;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.PersonBasicServiceImpl;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.dto.PersonBasicDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 人员基本信息
 *
 * @author system_generator
 * @date 2023-04-20
 */
@RestController
@Api(tags = "人员基本信息Api")
@RequestMapping(value = "/person-basic")
public class PersonBasicController extends BaseController {

    @Autowired
    PersonBasicServiceImpl personBasicServiceImpl;

    @Autowired
    McbWarningFeign mcbWarningFeign;


    @Autowired
    PersonBasicMapper personBasicMapper;

    @Autowired
    private StationQrCodeStatisticsMapper stationQrCodeStatisticsMapper;

    /**
     * 新增人员基本信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增人员基本信息", notes = "新增人员基本信息")
	public ResponseModel<Object> save(@RequestBody PersonDto model,HttpServletRequest httpServletRequest) {

	    try {
            personBasicServiceImpl.addPerson(model, httpServletRequest);
        }catch (Exception e){
            e.printStackTrace();
            return  this.buildResponseFalse(e.getMessage());
        }
	    return ResponseHelper.buildResponse(null);
	}

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/addRedisPostAndCerInfo")
    @ApiOperation(httpMethod = "POST", value = "岗位和证书信息缓存至redis", notes = "岗位和证书信息缓存至redis")
    public ResponseModel<Object> addRedisPostAndCerInfo() {
            personBasicServiceImpl.addRedisPostAndCerInfo();
        return ResponseHelper.buildResponse(null);
    }



	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/update")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新人员基本信息", notes = "根据sequenceNbr更新人员基本信息")
	public ResponseModel<PersonDto> updateBySequenceNbrPersonBasic(@RequestBody PersonDto model,@RequestParam(value = "sequenceNbr") Long sequenceNbr,HttpServletRequest httpServletRequest) {
        try {
	    personBasicServiceImpl.updatePerson(model,httpServletRequest,sequenceNbr);
        }catch (InnerInvokException | ParseException e){
            e.printStackTrace();
            return  this.buildResponseFalse(e.getMessage());
        }
        return ResponseHelper.buildResponse(null);

	}

	/**
     * 根据sequenceNbr删除
     *
     * @param ids 主键列表
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除人员基本信息", notes = "根据sequenceNbr删除人员基本信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,@RequestParam(value = "ids") String ids){
        int num=0;
        try {
            String[] idss=ids.split(",");
		    num= personBasicServiceImpl.deletePerson(idss);
        }catch (InnerInvokException e){
            e.printStackTrace();
        return  this.buildResponseFalse(e.getMessage());
    }
        return ResponseHelper.buildResponse(num>0?true:false);


    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个人员基本信息",  notes = "根据sequenceNbr查询单个人员基本信息")
	public ResponseModel<PersonDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(personBasicServiceImpl.getPerson(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "人员基本信息分页查询",  notes = "人员基本信息分页查询")
	public ResponseModel<Page<UserMapperDto>> queryForPage(
	        @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam(value = "name",required = false) String name,
            @RequestParam(value = "accountName",required = false)String accountName,
            @RequestParam(value = "projectName",required = false)String projectName,
            @RequestParam(value = "orgCode",required = false)String orgCode

    ) {
        Page<UserMapperDto> page = new Page<UserMapperDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(personBasicServiceImpl.queryPage(page, name,
                accountName,
                projectName,orgCode));
    }


	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "人员基本信息列表全部数据查询",   notes = "人员基本信息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<PersonBasicDto>> selectForList() {
	    return ResponseHelper.buildResponse(personBasicServiceImpl.queryForPersonBasicList());
	}


    public  ResponseModel buildResponseFalse(String message) {
        ResponseModel response = new ResponseModel();
        response.setResult(null);
        response.setDevMessage("FAILURE");
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        response.setMessage(message);
        response.setDevMessage(message);
        return response;
    }

//    /**
//     * 评估大屏 - 人员赋码环形图查询
//     *
//     * @param parentCode 父级code
//     */
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @GetMapping(value = "/getPersonYardStatistics")
//    @ApiOperation(httpMethod = "GET", value = "评估大屏 - 人员赋码环形图查询", notes = "评估大屏 - 人员赋码环形图查询")
//    public ResponseModel<List<Map<String, Object>>> getPersonYardStatistics(@RequestParam(required = false, value = "parentCode") String parentCode) {
//        List<Map<String, Object>> resultList = personBasicServiceImpl.getPersonYardStatistics(parentCode);
//        return ResponseHelper.buildResponse(resultList);
//    }

//    /**
//     * 评估大屏 - 人员赋码列表查询
//     *
//     * @param parentCode 父级code
//     */
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @GetMapping(value = "/getPersonYardByPage")
//    @ApiOperation(httpMethod = "GET", value = "评估大屏 - 人员赋码列表查询", notes = "评估大屏 - 人员赋码列表查询")
//    public ResponseModel<Page<Map<String, Object>>> getPersonYardByPage(@RequestParam(required = false, value = "parentCode") String parentCode,
//                                                                        @RequestParam(value = "current") Integer current,
//                                                                        @RequestParam(value = "size") Integer size) {
//        Page<Map<String, Object>> resultList = personBasicServiceImpl.getPersonYardByPage(parentCode, current, size);
//        return ResponseHelper.buildResponse(resultList);
//    }
//
//    /**
//     * 评估大屏 - 人员赋码数量等统计
//     *
//     * @param parentCode 父级code
//     */
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @GetMapping(value = "/getQrCodeCount")
//    @ApiOperation(httpMethod = "GET", value = "评估大屏 - 人员赋码数量等统计", notes = "评估大屏 - 人员赋码数量等统计")
//    public ResponseModel<Map<String, Object>> getQrCodeCount(@RequestParam(required = false, value = "parentCode") String parentCode) {
//
//        FeignClientResult<Map<String, Object>> sevenEntity = null;
//        try {
//            sevenEntity = mcbWarningFeign.getQrCodeCount(parentCode, "RYFM");
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        if (sevenEntity != null && 200 == sevenEntity.getStatus()) {
//            Map<String, Object> result = sevenEntity.getResult();
//            String red = result.get("red").toString();
//            String yellow = result.get("yellow").toString();
//            String redToGreen = result.get("redToGreen").toString();
//            String yellowToGreen = result.get("yellowToGreen").toString();
//            Integer countAll = personBasicMapper.getPersonYardByPageCount(parentCode);
//            result.put("redToGreenPercent", getPercent(new BigDecimal(red), new BigDecimal(countAll)));
//            result.put("redPercent", getPercent(new BigDecimal(redToGreen), new BigDecimal(countAll)));
//            result.put("yellowToGreenPercent", getPercent(new BigDecimal(yellow), new BigDecimal(countAll)));
//            result.put("yellowPercent", getPercent(new BigDecimal(yellowToGreen), new BigDecimal(countAll)));
//            return ResponseHelper.buildResponse(result);
//        }
//        return ResponseHelper.buildResponse(null);
//    }
//
//
//    /**
//     * 评估大屏 - 场站 人员赋码数量等统计 【折线图】
//     *
//     * @param parentCode 父级code
//     * @param dataType 类型 - 人员、任务、设备等
//     */
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @GetMapping(value = "/getQrCodeCountByStation")
//    @ApiOperation(httpMethod = "GET", value = "评估大屏 - 场站 人员赋码数量等统计 【折线图】", notes = "评估大屏 - 场站 人员赋码数量等统计 【折线图】")
//    public ResponseModel<List<Map<String, Object>>> getQrCodeCountByStation(@RequestParam(required = false, value = "parentCode") String parentCode,
//                                                                            @RequestParam(required = false, value = "dataType") String dataType) {
//        List<Map<String, Object>> qrCodeCountByStation = stationQrCodeStatisticsMapper.getQrCodeCountByStation(parentCode, dataType);
//        return ResponseHelper.buildResponse(qrCodeCountByStation);
//    }
//
//
//    /**
//     * 百分比
//     *
//     * @param numerator   分子
//     * @param denominator 分母
//     * @return 百分比
//     */
//    private double getPercent(BigDecimal numerator, BigDecimal denominator) {
//        BigDecimal multiply = numerator.divide(denominator.compareTo(BigDecimal.ZERO) != 0 ? denominator : new BigDecimal(1), 4, BigDecimal.ROUND_DOWN).multiply(new BigDecimal(100));
//        return Math.abs(multiply.doubleValue());
//    }

}
