package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ColModel;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.DataGridMock;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.EquipAlarmEventDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ResultsData;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.EquipAlarmEvent;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.EquipAlarmEventMapper;

@Service
public class EquipAlarmEventServiceImpl
		extends BaseService<EquipAlarmEventDto, EquipAlarmEvent, EquipAlarmEventMapper> {

	@Autowired
	EquipAlarmEventMapper equipAlarmEventMapper;
	@Autowired
	StationBasicMapper stationBasicMapper;

	public ResultsData getEquipEvent(int current, int size, String gatewayId, String equipIndex, String frontModule) {
		PageHelper.startPage(current, size);
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.DAY_OF_MONTH, -2);
		String equipName = null;
		if (equipIndex != null && frontModule != null) {
			if ("箱变".equals(frontModule)) {
				equipName = equipIndex + "子阵/箱变";
			} else if ("逆变器".equals(frontModule)) {
				String[] s = equipIndex.split("-");
				equipName = s[0] + "子阵/逆变器" + s[1];
			} else if ("汇流箱".equals(frontModule)) {
				String[] s = equipIndex.split("-");
				if (s[2].indexOf("0")==0) {
					s[2] = s[2].substring(1);
				}
				equipName = s[0] + "子阵/逆变器" + s[1] + "/#" + s[2] + "汇流箱";
			} else if ("风机".equals(frontModule)) {
				equipName = equipIndex + "风机";
			}
			equipName = '%' + equipName + '%';
		}
		
		List<EquipAlarmEvent> alarmEventList = this.baseMapper.getEventList(gatewayId, equipName, null,
				calendar.getTime());

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Calendar car = Calendar.getInstance();
		alarmEventList.forEach(i -> {
			if ("true".equals(i.getValue())) {
				i.setValue("合");
			} else if ("false".equals(i.getValue())) {
				i.setValue("分");
			}
			long mills = i.getCreatedTime()/1000000;
			car.setTimeInMillis(mills);
			//System.out.println(sdf.format(car.getTime()));
			i.setTime(sdf.format(car.getTime()));
			//car.add(Calendar.HOUR, 12);
			//System.out.println(sdf.format(car.getTime()));
		});

		PageInfo<EquipAlarmEvent> page = new PageInfo(alarmEventList);

		// 构建平台数据
		DataGridMock DataGridMock = new DataGridMock(current, (int) page.getTotal(), false, current, alarmEventList);
		ColModel colModelEventMovement = new ColModel("equipName", "equipName", "设备名称", "设备名称", "dataGrid",
				"equipName");
		ColModel colModelStationName = new ColModel("eventDesc", "eventDesc", "事件描述", "事件描述", "dataGrid", "eventDesc");
		ColModel colModelEventDesc = new ColModel("time", "time", "事件发生时间", "事件发生时间", "dataGrid",
				"time");
		ColModel colModelValueDesc = new ColModel("value", "value", "事件值", "事件值", "dataGrid", "value");
		List<ColModel> listColModel = Arrays.asList(colModelEventMovement, colModelStationName, colModelEventDesc,
				colModelValueDesc);
		ResultsData resultsData = new ResultsData(DataGridMock, listColModel);
		return resultsData;
	}
}
