package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 工商信息附件
 *
 * @author sqy
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_company_qualifications_attachment")
@ApiModel(value = "CompanyQualificationsSttachment对象", description = "企业资质附件")
public class CompanyQualificationsAttachment extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "企业资质id")
    private Long companyQualificationsId;
    @ApiModelProperty(value = "附件地址")
    @ImagePrefix
    private String attachment;
}
