package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
 * 安全追溯问题
 *
 * @author system_generator
 * @date 2024-05-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_safety_problem_tracing")
public class SafetyProblemTracing extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 问题编号
     */
	@TableField("problem_num")
    private String problemNum;

    /**
     * 问题类型（维保超期、检验超期、资质超期等）
     */
	@TableField("problem_type")
    private String problemType;

    /**
     * 问题来源类型（1个人、2企业、3设备）
     */
	@TableField("source_type")
    private String sourceType;

    /**
     * 问题来源ID（个人ID、设备ID、企业ID）
     */
	@TableField("source_id")
    private String sourceId;

    /**
     * 问题描述
     */
	@TableField("problem_desc")
    private String problemDesc;

    /**
     * 问题产生时间
     */
	@TableField("problem_time")
    private Date problemTime;

    /**
     * 主体单位名称
     */
	@TableField("principal_unit")
    private String principalUnit;

    /**
     * 主体单位统一代码
     */
	@TableField("principal_unit_code")
    private String principalUnitCode;

    /**
     * 主体单位类型（使用、安改维、检验检测等）
     */
	@TableField("principal_unit_type")
    private String principalUnitType;

    /**
     * 管辖机构名称
     */
	@TableField("governing_body")
    private String governingBody;

    /**
     * 管辖机构单位代码
     */
	@TableField("governing_body_code")
    private String governingBodyCode;

    /**
     * 管辖机构组织机构代码（例如50*60*70）
     */
	@TableField("governing_body_org_code")
    private String governingBodyOrgCode;

    /**
     * 主体单位所属区域名称（陕西省/西安市/莲湖区）
     */
	@TableField("region_name")
    private String regionName;

    /**
     * 所属区域代码（6100000/6100010/6100011）
     */
	@TableField("region_code")
    private String regionCode;

    /**
     * 问题状态（0未处理、1已处理）
     */
	@TableField("problem_status")
    private String problemStatus;

    /**
     * 问题状态代码（0未处理、1已处理）
     */
    @TableField("problem_status_code")
    private String problemStatusCode;

    /**
     * 更新人员
     */
	@TableField("rec_user")
    private String recUser;

    /**
     * 创建人ID
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 创建人
     */
	@TableField("create_user")
    private String createUser;

    /**
     * 企业负责人
     */
	@TableField("unit_charger")
    private String unitCharger;

    /**
     * 企业负责人联系电话
     */
	@TableField("unit_charger_phone")
    private String unitChargerPhone;

    /**
     * 设备监管码
     */
	@TableField("equip_supervise_code")
    private String equipSuperviseCode;

    /**
     * 设备种类
     */
	@TableField("equip_list")
    private String equipList;

    /**
     * 人员名称
     */
	@TableField("user_name")
    private String userName;

    /**
     * 人员电话
     */
	@TableField("user_phone")
    private String userPhone;

    /**
     * 人员岗位
     */
	@TableField("user_post")
    private String userPost;

    /**
     * 扩展信息
     */
	@TableField("extraInfo")
    private String extraInfo;

    /**
     * 设备种类代码
     */
	@TableField("equip_list_code")
    private String equipListCode;

    /**
     * 问题类型代码（维保超期、检验超期、资质超期等）
     */
	@TableField("problem_type_code")
    private String problemTypeCode;

    /**
     * 问题来源类型code（1个人、2企业、3设备）
     */
	@TableField("source_type_code")
    private String sourceTypeCode;

    /**
     * 问题等级（一级、二级、三级）
     */
	@TableField("problem_level")
    private String problemLevel;

    /**
     * 问题等级code
     */
	@TableField("problem_level_code")
    private String problemLevelCode;

}
