package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgResumeInfoDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgResumeInfo;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgResumeInfoMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgResumeInfoService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2024-05-29
 */
@Service
public class JgResumeInfoServiceImpl extends BaseService<JgResumeInfoDto, JgResumeInfo, JgResumeInfoMapper> implements IJgResumeInfoService {
    /**
     * 分页查询
     */
    public Page<JgResumeInfoDto> queryForJgResumeInfoPage(Page<JgResumeInfoDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<JgResumeInfoDto> queryForJgResumeInfoList() {
        return this.queryForList("", false);
    }

    public void saveBatchResume(List<JgResumeInfoDto> jgResumeInfoDtoList) {
        Collection<JgResumeInfo> jgResumeInfoCollection = jgResumeInfoDtoList.stream()
                .map(dto -> {
                    JgResumeInfo info = new JgResumeInfo();
                    BeanUtils.copyProperties(dto, info);
                    return info;
                })
                .collect(Collectors.toList());
        this.saveBatch(jgResumeInfoCollection);
    }

    /**
     * 根据业务id进行删除
     * @param businessId 业务id
     */
    public void deleteByBusinessId(String businessId) {
        this.baseMapper.delete(new LambdaQueryWrapper<JgResumeInfo>().eq(JgResumeInfo::getBusinessId, businessId));
    }
}