package com.yeejoin.amos.boot.module.jyjc.biz.event.listener;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.biz.common.utils.SnowflakeIdUtil;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationManage;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationManageMapper;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationEquip;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationPushLog;
import com.yeejoin.amos.boot.module.jyjc.api.enums.EquipCategoryEnum;
import com.yeejoin.amos.boot.module.jyjc.api.model.InspectionApplicationPushData;
import com.yeejoin.amos.boot.module.jyjc.api.model.InspectionEquipData;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationModel;
import com.yeejoin.amos.boot.module.jyjc.biz.event.InspectionApplicationPushEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.kafka.KafkaProducer;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionApplicationEquipServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionApplicationPushLogServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.util.JyjcConstant;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.*;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@Component
@Slf4j
public class InspectionApplicationPushEventListener implements ApplicationListener<InspectionApplicationPushEvent> {

    private BlockingQueue<JyjcInspectionApplicationModel> queue = new LinkedBlockingQueue<>();

    @Value("${inspection.push.max.deal.thread.num:2}")
    private int threadNum;

    @Autowired
    JyjcInspectionApplicationPushLogServiceImpl pushLogService;

    @Autowired
    JyjcInspectionApplicationEquipServiceImpl applicationEquipService;

    @Autowired
    IdxBizJgConstructionInfoMapper constructionInfoMapper;

    @Autowired
    IdxBizJgUseInfoMapper useInfoMapper;

    @Autowired
    IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;

    @Autowired
    TzBaseEnterpriseInfoMapper baseEnterpriseInfoMapper;

    @Autowired
    private EquipTechParamBoilerMapper equipTechParamBoilerMapper;

    @Autowired
    private EquipTechParamVesselMapper equipTechParamVesselMapper;

    @Autowired
    private EquipTechParamElevatorMapper equipTechParamElevatorMapper;

    @Autowired
    private EquipTechParamLiftingMapper equipTechParamLiftingMapper;

    @Autowired
    private EquipTechParamVehicleMapper equipTechParamVehicleMapper;

    @Autowired
    private EquipTechParamRidesMapper equipTechParamRidesMapper;

    @Autowired
    private EquipTechParamPipelineMapper equipTechParamPipelineMapper;

    @Autowired
    private EquipTechParamRopewayMapper equipTechParamRopewayMapper;

    @Autowired
    KafkaProducer kafkaProducer;

    @Autowired
    SnowflakeIdUtil sequence;

    @Autowired
    IdxBizJgFactoryInfoMapper factoryInfoMapper;

    @Autowired
    MaintenanceInfoMapper maintenanceInfoMapper;

    @Autowired
    JgUseRegistrationManageMapper jgUseRegistrationManageMapper;



    /**
     * 报检推送主题， 第一位为接收单位标识
     */
    private final static String INSPECTION_APPLICATION_PUSH_TOPIC = "%s_INSPECTION_APPLICATION_TOPIC";

    /**
     * 监督检验-检验类型
     */
    private final static List<String> JDJY_ARRAY = Arrays.asList("AZJDJY", "GZJDJY", "WXJDJY");

    /**
     * 定首检-检验类型
     */
    private final static List<String> DSJ_ARRAY = Arrays.asList("DQJY", "SCJY");


    @Override
    public void onApplicationEvent(InspectionApplicationPushEvent event) {
        log.info("收到报检推送请求：{}", event);
        queue.add(event.getJyjcInspectionApplicationModel());
    }

    @PostConstruct
    public void init() {
        ExecutorService executorService = Executors.newFixedThreadPool(threadNum);
        // 可处理的检验检测类型，目前只处理检验的，不处理检测业务
        List<String> canDealInspectionTypes = getCanDealInspectionType();
        for (int i = 0; i < threadNum; i++) {
            executorService.execute(() -> {
                while (true) {
                    try {
                        JyjcInspectionApplicationModel applicationModel = queue.take();
                        if (!canDealInspectionTypes.contains(applicationModel.getInspectionType())) {
                            return;
                        }
                        //构建数据
                        JyjcInspectionApplicationPushLog pushLog = this.createPushData(applicationModel);
                        // 发送数据
                        this.pushData2Kafka(applicationModel.getDockingUnitCode(), pushLog);
                    } catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                }
            });
        }
    }

    private void pushData2Kafka(String dockingUnitCode, JyjcInspectionApplicationPushLog pushLog) {
        // 发送kafka指定的主题
        String topic = String.format(INSPECTION_APPLICATION_PUSH_TOPIC, dockingUnitCode);
        kafkaProducer.sendMessage(topic, pushLog.getPushData());
        pushLog.setPushStatus("2");
        pushLogService.updateById(pushLog);
    }

    private JyjcInspectionApplicationPushLog createPushData(JyjcInspectionApplicationModel applicationModel) {
        long id = sequence.nextId();
        JyjcInspectionApplicationPushLog pushLog = new JyjcInspectionApplicationPushLog();
        pushLog.setInspectionUnitCode(applicationModel.getInspectionUnitCode());
        pushLog.setApplicationSeq(applicationModel.getSequenceNbr());
        // 初始状态
        pushLog.setSequenceNbr(id);
        pushLog.setPushStatus("1");
        pushLog.setPushData(this.buildData(id, applicationModel));
        pushLog.setRecDate(new Date());
        pushLogService.save(pushLog);
        return pushLog;
    }

    private List<String> getCanDealInspectionType() {
        List<String> canDealInspectionTypes = new ArrayList<>(JDJY_ARRAY);
        canDealInspectionTypes.addAll(DSJ_ARRAY);
        return canDealInspectionTypes;
    }

    private String buildData(long traceId, JyjcInspectionApplicationModel applicationModel) {
        InspectionApplicationPushData pushData = new InspectionApplicationPushData();
        BeanUtil.copyProperties(applicationModel, pushData);
        // 监管机构
        pushData.setSuperviseOrgName(this.getSuperviseNameByCode(applicationModel.getApplicationUnitCode()));
        // 报检的设备信息
        pushData.setInspectionEquips(this.buildInspectionEquipInfo(applicationModel));
        pushData.setTraceId(traceId + "");
        return JSONObject.toJSONString(pushData);
    }

    private List<InspectionEquipData> buildInspectionEquipInfo(JyjcInspectionApplicationModel applicationModel) {
        Long applicationSeq = applicationModel.getSequenceNbr();
        List<JyjcInspectionApplicationEquip> jyjcInspectionApplicationEquips = applicationEquipService.list(new LambdaQueryWrapper<JyjcInspectionApplicationEquip>().eq(JyjcInspectionApplicationEquip::getApplicationSeq, applicationSeq));
        return jyjcInspectionApplicationEquips.stream().map(e -> {
            InspectionEquipData equipData = new InspectionEquipData();
            BeanUtil.copyProperties(e, equipData);
            equipData.setEquipId(e.getEquipUnicode());
            // 使用信息
            this.setUseInfo(equipData, e.getEquipUnicode());
            // 注册信息
            this.setRegisterInfo(equipData, e.getEquipUnicode());
            // 制造信息
            this.setProductData(equipData,e.getEquipUnicode());
            // 维保单位信息
            this.setMaintenanceInfo(equipData,e.getEquipUnicode());
            // 单个查询执行，原因数据量较大 in 慢
            this.setOtherInfo(equipData, e.getEquipUnicode(), applicationModel.getInspectionType());
            // 单个查询执行，原因数据量较大 in 慢
            this.setTechParams(equipData, e.getEquipUnicode());
            return equipData;
        }).collect(Collectors.toList());
    }

    private void setMaintenanceInfo(InspectionEquipData equipData, String equipUnicode) {
        MaintenanceInfo maintenanceInfo = maintenanceInfoMapper.selectOne(new LambdaQueryWrapper<MaintenanceInfo>()
                .eq(AbstractEquipBaseEntity::getRecord, equipUnicode)
                .select(MaintenanceInfo::getRecord,MaintenanceInfo::getMeUnitCreditCode,MaintenanceInfo::getMeUnitName));
        if(maintenanceInfo != null){
            equipData.setMeUnitCreditCode(maintenanceInfo.getMeUnitCreditCode());
            equipData.setMeUnitName(maintenanceInfo.getMeUnitName());
        }
    }

    private void setUseInfo(InspectionEquipData equipData, String equipUnicode) {
        IdxBizJgUseInfo idxBizJgUseInfo = useInfoMapper.selectOne(
                new LambdaQueryWrapper<IdxBizJgUseInfo>()
                .eq(IdxBizJgUseInfo::getRecord, equipUnicode)
        );
        equipData.setUseInnerCode(idxBizJgUseInfo.getUseInnerCode());
        equipData.setAddress(getAddressByRecord(idxBizJgUseInfo));
        equipData.setUnitCreditCode(idxBizJgUseInfo.getUseUnitCreditCode());
        equipData.setUnitCreditName(idxBizJgUseInfo.getUseUnitName());
    }

    private String getAddressByRecord(IdxBizJgUseInfo idxBizJgUseInfo) {
        return null2Blank(idxBizJgUseInfo.getProvinceName()) + null2Blank(idxBizJgUseInfo.getCityName()) + null2Blank(idxBizJgUseInfo.getCountyName()) + null2Blank(idxBizJgUseInfo.getAddress());
    }

    private void setRegisterInfo(InspectionEquipData equipData, String equipUnicode) {
        LambdaQueryWrapper<IdxBizJgRegisterInfo> wrapper = new LambdaQueryWrapper<>();
        wrapper.select(IdxBizJgRegisterInfo::getEquType,IdxBizJgRegisterInfo::getRecord);
        wrapper.eq(IdxBizJgRegisterInfo::getRecord, equipUnicode);
        wrapper.select(IdxBizJgRegisterInfo::getRecord,
                IdxBizJgRegisterInfo::getEquType,
                IdxBizJgRegisterInfo::getUseOrgCode,
                IdxBizJgRegisterInfo::getLastUseCertFilePath);
        // 使用证信息
        IdxBizJgRegisterInfo jgRegisterInfo = idxBizJgRegisterInfoMapper.selectOne(wrapper);
        if (jgRegisterInfo != null) {
            equipData.setEquType(jgRegisterInfo.getEquType());
            equipData.setUseRegistrationCode(jgRegisterInfo.getUseOrgCode());
            equipData.setUseCertFilePath(jgRegisterInfo.getLastUseCertFilePath());
        }
        // 登记机关
        if(equipData.getUseRegistrationCode() != null){
            LambdaQueryWrapper<JgUseRegistrationManage> queryWrapper = new LambdaQueryWrapper<JgUseRegistrationManage>()
                    .eq(JgUseRegistrationManage::getUseRegistrationCode, equipData.getUseRegistrationCode())
                    .eq(JgUseRegistrationManage::getIsDelete, 0).select(JgUseRegistrationManage::getRegUnitName,BaseEntity::getSequenceNbr);
            JgUseRegistrationManage jgUseRegistrationManage = jgUseRegistrationManageMapper.selectOne(queryWrapper);
            if(jgUseRegistrationManage != null){
                equipData.setRegUnitName(jgUseRegistrationManage.getRegUnitName());
            }
        }
    }

    private void setProductData(InspectionEquipData equipData, String record) {
        IdxBizJgFactoryInfo idxBizJgFactoryInfo = factoryInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgFactoryInfo>().eq(IdxBizJgFactoryInfo::getRecord,record));
        if(idxBizJgFactoryInfo != null) {
            equipData.setFactoryNum(idxBizJgFactoryInfo.getFactoryNum());
            equipData.setProduceUnitCreditCode(idxBizJgFactoryInfo.getProduceUnitCreditCode());
            equipData.setProduceUnitName(idxBizJgFactoryInfo.getProduceUnitName());
            equipData.setProduceDate(DateUtil.formatDate(idxBizJgFactoryInfo.getProduceDate()));
        }
    }

    private void setTechParams(InspectionEquipData equipData, String equipUnicode) {
        // 按照设备类型查询不同的技术参数表
        equipData.setTechParams(this.populateEquipInfoWithTechParams(equipData.getEquList(), equipUnicode));
    }

    public Map<String, Object> populateEquipInfoWithTechParams(String equList, String record) {
        EquipCategoryEnum productType = EquipCategoryEnum.of(Integer.parseInt(equList));
        Map<String, Object> echParamMap = new HashMap<>();
        switch (Objects.requireNonNull(productType)) {
            case IDX_BIZ_JG_TECH_PARAMS_BOILER:
                // 锅炉-已确认
                echParamMap = BeanUtil.beanToMap(equipTechParamBoilerMapper.queryTechParamInUse(record));
                break;
            case IDX_BIZ_JG_TECH_PARAMS_VESSEL:
                // 压力容器-待核对
                echParamMap = BeanUtil.beanToMap(equipTechParamVesselMapper.queryTechParamInUse(record));
                break;
            case IDX_BIZ_JG_TECH_PARAMS_ELEVATOR:
                // 电梯-已确认
                echParamMap = BeanUtil.beanToMap(equipTechParamElevatorMapper.queryTechParamInUse(record));
                break;
            case IDX_BIZ_JG_TECH_PARAMS_LIFTING:
                // 起重机械-已确认
                echParamMap = BeanUtil.beanToMap(equipTechParamLiftingMapper.queryTechParamInUse(record));
                break;
            case IDX_BIZ_JG_TECH_PARAMS_VEHICLE:
                // 场（厂）内专用机动车辆-已确认
                echParamMap = BeanUtil.beanToMap(equipTechParamVehicleMapper.queryTechParamInUse(record));
                break;
            case IDX_BIZ_JG_TECH_PARAMS_RIDES:
                // 大型游乐设施-已确认
                echParamMap = BeanUtil.beanToMap(equipTechParamRidesMapper.queryTechParamInUse(record));
                break;
            case IDX_BIZ_JG_TECH_PARAMS_PIPELINE:
                // 压力管道-已确认
                echParamMap = BeanUtil.beanToMap(equipTechParamPipelineMapper.queryTechParamInUse(record));
                break;
            case IDX_BIZ_JG_TECH_PARAMS_ROPEWAY:
                // 客运索道-已确认
                echParamMap = BeanUtil.beanToMap(equipTechParamRopewayMapper.queryTechParamInUse(record));
                break;
            default:
                break;
        }
        this.castStr2JsonField(echParamMap);
        return echParamMap;
    }

    private void castStr2JsonField(Map<String, Object> echParamMap) {
        if (echParamMap != null) {
            echParamMap.forEach((k, v) -> {
                if (JyjcConstant.TECH_PARAM_JSON_FIELDS.contains(k) && v != null) {
                    echParamMap.put(k, JSON.parse(v.toString()));
                }
            });
        }
    }


    private String null2Blank(String str) {
        return StrUtil.isNotEmpty(str) ? str : "";
    }

    private void setOtherInfo(InspectionEquipData equipData, String equipUnicode, String inspectionType) {
        // 监督检验送施工单位信息
        if (JDJY_ARRAY.contains(inspectionType)) {
            setConstructionInfo(equipData, equipUnicode);
        }
    }

    private void setConstructionInfo(InspectionEquipData equipData, String equipUnicode) {
        LambdaQueryWrapper<IdxBizJgConstructionInfo> wrapper = new LambdaQueryWrapper<>();
        wrapper.select(IdxBizJgConstructionInfo::getUscUnitCreditCode,
                IdxBizJgConstructionInfo::getUscUnitName,
                IdxBizJgConstructionInfo::getInformCode,
                IdxBizJgConstructionInfo::getInformFilePath);
        wrapper.eq(IdxBizJgConstructionInfo::getRecord, equipUnicode);
        wrapper.orderByDesc(TzsBaseEntity::getRecDate);
        wrapper.last("limit 1");
        IdxBizJgConstructionInfo jgConstructionInfo = constructionInfoMapper.selectOne(wrapper);
        if (jgConstructionInfo != null) {
            equipData.setUscUnitCreditCode(jgConstructionInfo.getUscUnitCreditCode());
            equipData.setUscUnitName(jgConstructionInfo.getUscUnitName());
            // 施工告知后地址信息会写入到使用信息表，使用信息上个方法已经设置
            equipData.setUscAddress(equipData.getAddress());
            equipData.setInformCode(jgConstructionInfo.getInformCode());
            equipData.setInformFilePath(jgConstructionInfo.getInformFilePath());
        }
    }


    private void setUseCodeAndCertPath(InspectionEquipData equipData, String equipUnicode) {
        LambdaQueryWrapper<IdxBizJgRegisterInfo> wrapper = new LambdaQueryWrapper<>();
        wrapper.select(IdxBizJgRegisterInfo::getUseOrgCode, IdxBizJgRegisterInfo::getLastUseCertFilePath);
        wrapper.eq(IdxBizJgRegisterInfo::getRecord, equipUnicode);
        IdxBizJgRegisterInfo jgRegisterInfo = idxBizJgRegisterInfoMapper.selectOne(wrapper);
        if (jgRegisterInfo != null) {
            equipData.setUseRegistrationCode(jgRegisterInfo.getUseOrgCode());
            equipData.setUseCertFilePath(jgRegisterInfo.getLastUseCertFilePath());
        }
    }


    private String getSuperviseNameByCode(String applicationUnitCode) {
        //查询监管单位名称
        TzBaseEnterpriseInfo tzBaseEnterpriseInfo = baseEnterpriseInfoMapper.selectOne(new LambdaQueryWrapper<TzBaseEnterpriseInfo>().eq(TzBaseEnterpriseInfo::getUseCode, applicationUnitCode));
        return tzBaseEnterpriseInfo.getSuperviseOrgName();
    }


}
