package com.yeejoin.amos.boot.module.cylinder.api.enums;

/**
 * 
 * <pre>
 * 电梯是否在线枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: IsOnlineEnum.java, v 0.1 2021年9月29日 上午9:08:16 gwb Exp $
 */
public enum LiftIsOnlineEnum{

	OFF(0,"离线"),
	ON(1,"在线");

	/**
	 * 编码
	 */
	private Integer code;

	/**
	 * 名称
	 */
	private String name;


	// 构造方法
	private LiftIsOnlineEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}


	public Integer getCode() {
		return code;
	}
	
	public String getName()
	{
		return name;
	}
	
	public static LiftIsOnlineEnum getEnum(Integer code)
	{
		for (LiftIsOnlineEnum liftIsOnlineEnum : LiftIsOnlineEnum.values())
		{
			if (liftIsOnlineEnum.getCode().equals(code))
			{
				return liftIsOnlineEnum;
			}
		}
		return null;
	}
}
