package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 人员任务
 *
 * @author system_generator
 * @date 2023-09-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_to_do_tasks")
public class ToDoTasks extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 任务类型
     */
	@TableField("type")
    private String type;

    /**
     * 业务id
     */
	@TableField("business_id")
    private Long businessId;

    /**
     * 任务状态
     */
	@TableField("state")
    private String state;

    /**
     * 用户id
     */
	@TableField("amos_user_id")
    private String amosUserId;

    /**
     *   任务创建时间
     */
	@TableField("creation_time")
    private Date creationTime;

    /**
     * 完成时间
     */
	@TableField("complete_time")
    private Date completeTime;

    /**
     * 任务名称
     */
	@TableField("task_name")
    private String taskName;

    /**
     *经销商orgCode
     */
    @TableField("amos_org_code")
    private String amosOrgCode;




    public ToDoTasks(String type, Long businessId,  String taskName,String orgCode) {
        this.type = type;
        this.businessId = businessId;
        this.state = "待办";
        this.amosOrgCode = orgCode;
        this.creationTime = new Date();
        this.taskName = taskName;
    }

    public ToDoTasks() {
    }
}
