package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 人员消息
 *
 * @author system_generator
 * @date 2023-09-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_user_message")
public class UserMessage extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 任务类型
     */
	@TableField("type")
    private String type;

    /**
     * 业务id
     */
	@TableField("business_id")
    private Long businessId;

    /**
     * 用户id
     */
	@TableField("amos_user_id")
    private String amosUserId;

    /**
     *  消息创建时间
     */
	@TableField("creation_time")
    private Date creationTime;

    /**
     * 消息内容
     */
	@TableField("task_name")
    private String taskName;

    /**
     * 经销商orgCode
     */
	@TableField("amos_org_code")
    private String amosOrgCode;


    public UserMessage(String type, Long businessId, String amosUserId, Date creationTime, String taskName, String amosOrgCode) {
        this.type = type;
        this.businessId = businessId;
        this.amosUserId = amosUserId;
        this.creationTime = creationTime;
        this.taskName = taskName;
        this.amosOrgCode = amosOrgCode;
    }

    public UserMessage() {
    }
}
